/*
 * Decompiled with CFR 0.152.
 */
package dev.ftb.mods.ftblibrary.util;

import it.unimi.dsi.fastutil.chars.Char2ObjectOpenHashMap;
import java.util.function.Function;
import net.minecraft.ChatFormatting;
import net.minecraft.Util;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.Style;
import net.minecraft.network.chat.TextColor;
import net.minecraft.network.chat.contents.PlainTextContents;
import org.jetbrains.annotations.Nullable;

public class TextComponentParser {
    public static final Char2ObjectOpenHashMap<ChatFormatting> CODE_TO_FORMATTING = (Char2ObjectOpenHashMap)Util.make((Object)new Char2ObjectOpenHashMap(), map -> {
        map.put('0', (Object)ChatFormatting.BLACK);
        map.put('1', (Object)ChatFormatting.DARK_BLUE);
        map.put('2', (Object)ChatFormatting.DARK_GREEN);
        map.put('3', (Object)ChatFormatting.DARK_AQUA);
        map.put('4', (Object)ChatFormatting.DARK_RED);
        map.put('5', (Object)ChatFormatting.DARK_PURPLE);
        map.put('6', (Object)ChatFormatting.GOLD);
        map.put('7', (Object)ChatFormatting.GRAY);
        map.put('8', (Object)ChatFormatting.DARK_GRAY);
        map.put('9', (Object)ChatFormatting.BLUE);
        map.put('a', (Object)ChatFormatting.GREEN);
        map.put('b', (Object)ChatFormatting.AQUA);
        map.put('c', (Object)ChatFormatting.RED);
        map.put('d', (Object)ChatFormatting.LIGHT_PURPLE);
        map.put('e', (Object)ChatFormatting.YELLOW);
        map.put('f', (Object)ChatFormatting.WHITE);
        map.put('k', (Object)ChatFormatting.OBFUSCATED);
        map.put('l', (Object)ChatFormatting.BOLD);
        map.put('m', (Object)ChatFormatting.STRIKETHROUGH);
        map.put('n', (Object)ChatFormatting.UNDERLINE);
        map.put('o', (Object)ChatFormatting.ITALIC);
        map.put('r', (Object)ChatFormatting.RESET);
    });
    private final String text;
    private final Function<String, Component> substitutes;
    private MutableComponent component;
    private StringBuilder builder;
    private Style style;

    private TextComponentParser(String txt, @Nullable Function<String, Component> sub) {
        this.text = txt;
        this.substitutes = sub;
    }

    public static Component parse(String text, @Nullable Function<String, Component> substitutes) {
        Component c = TextComponentParser.parse0(text, substitutes);
        if (c == Component.EMPTY) {
            return c;
        }
        while (c.getContents() == PlainTextContents.EMPTY && c.getStyle().equals((Object)Style.EMPTY) && c.getSiblings().size() == 1) {
            c = (Component)c.getSiblings().get(0);
        }
        return c;
    }

    private static Component parse0(String text, @Nullable Function<String, Component> substitutes) {
        try {
            return new TextComponentParser(text, substitutes).parse();
        }
        catch (BadFormatException ex) {
            return Component.literal((String)ex.getMessage()).withStyle(ChatFormatting.RED);
        }
        catch (Exception ex) {
            return Component.literal((String)ex.toString()).withStyle(ChatFormatting.RED);
        }
    }

    private Component parse() throws BadFormatException {
        if (this.text.isEmpty()) {
            return Component.empty();
        }
        char[] c = this.text.replaceAll("\\\\n", "\n").toCharArray();
        boolean hasSpecialCodes = false;
        for (char c1 : c) {
            if (c1 != '{' && c1 != '&' && c1 != '\u00a7') continue;
            hasSpecialCodes = true;
            break;
        }
        if (!hasSpecialCodes) {
            return Component.literal((String)new String(c));
        }
        this.component = Component.literal((String)"");
        this.style = Style.EMPTY;
        this.builder = new StringBuilder();
        boolean sub = false;
        for (int i = 0; i < c.length; ++i) {
            boolean end;
            boolean escape = i > 0 && c[i - 1] == '\\';
            boolean bl = end = i == c.length - 1;
            if (sub && (end || c[i] == '{' || c[i] == '}')) {
                if (c[i] == '{') {
                    throw new BadFormatException("Invalid formatting! Can't nest multiple substitutes!");
                }
                this.finishPart();
                sub = false;
                continue;
            }
            if (!escape) {
                if (c[i] == '&' || c[i] == '\u00a7') {
                    this.finishPart();
                    if (end) {
                        throw new BadFormatException("Invalid formatting! Can't end string with &!");
                    }
                    if (c[++i] == '#') {
                        char[] rrggbb = new char[7];
                        rrggbb[0] = 35;
                        System.arraycopy(c, i + 1, rrggbb, 1, 6);
                        i += 6;
                        this.style = this.style.withColor(TextColor.parseColor((String)new String(rrggbb)).result().orElse(TextColor.fromRgb((int)0xFFFFFF)));
                        continue;
                    }
                    if (c[i] == ' ') {
                        throw new BadFormatException("Invalid formatting! You must escape whitespace after & with \\&!");
                    }
                    ChatFormatting formatting = (ChatFormatting)CODE_TO_FORMATTING.get(c[i]);
                    if (formatting == null) {
                        throw new BadFormatException("Invalid formatting! Unknown formatting symbol after &: '" + c[i] + "'!");
                    }
                    this.style = this.style.applyFormat(formatting);
                    continue;
                }
                if (c[i] == '{') {
                    this.finishPart();
                    if (end) {
                        throw new BadFormatException("Invalid formatting! Can't end string with {!");
                    }
                    sub = true;
                }
            }
            if (c[i] == '\\' && !escape) continue;
            this.builder.append(c[i]);
        }
        this.finishPart();
        return this.component;
    }

    private void finishPart() throws BadFormatException {
        String string = this.builder.toString();
        this.builder.setLength(0);
        if (string.isEmpty()) {
            return;
        }
        if (string.length() < 2 || string.charAt(0) != '{') {
            MutableComponent component1 = Component.literal((String)string);
            component1.setStyle(this.style);
            this.component.append((Component)component1);
            return;
        }
        Component component1 = this.substitutes.apply(string.substring(1));
        if (component1 == null) {
            throw new BadFormatException("Invalid formatting! Unknown substitute: " + string.substring(1));
        }
        Style style0 = component1.getStyle();
        Style style1 = this.style;
        style1 = style1.withHoverEvent(style0.getHoverEvent());
        style1 = style1.withClickEvent(style0.getClickEvent());
        style1 = style1.withInsertion(style0.getInsertion());
        component1 = Component.literal((String)"").append(component1).withStyle(style1);
        this.component.append(component1);
    }

    private static class BadFormatException
    extends IllegalArgumentException {
        private BadFormatException(String s) {
            super(s);
        }
    }
}

