/*
 * Decompiled with CFR 0.152.
 */
package dev.ftb.mods.ftblibrary;

import dev.architectury.event.events.client.ClientGuiEvent;
import dev.architectury.event.events.client.ClientTickEvent;
import dev.architectury.hooks.client.screen.ScreenAccess;
import dev.architectury.registry.ReloadListenerRegistry;
import dev.ftb.mods.ftblibrary.config.FTBLibraryClientConfig;
import dev.ftb.mods.ftblibrary.config.manager.ConfigManagerClient;
import dev.ftb.mods.ftblibrary.config.ui.resource.SelectImageResourceScreen;
import dev.ftb.mods.ftblibrary.icon.EntityIconLoader;
import dev.ftb.mods.ftblibrary.sidebar.SidebarButtonManager;
import dev.ftb.mods.ftblibrary.sidebar.SidebarGroupGuiButton;
import dev.ftb.mods.ftblibrary.ui.CursorType;
import dev.ftb.mods.ftblibrary.ui.IScreenWrapper;
import dev.ftb.mods.ftblibrary.util.client.ClientUtils;
import java.util.ArrayList;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.server.packs.PackType;
import net.minecraft.server.packs.resources.PreparableReloadListener;
import org.jetbrains.annotations.Nullable;

public class FTBLibraryClient {
    public static CursorType lastCursorType = null;

    public static void init() {
        if (Minecraft.getInstance() == null) {
            return;
        }
        ConfigManagerClient.initClient();
        ClientGuiEvent.INIT_POST.register(FTBLibraryClient::guiInit);
        ClientTickEvent.CLIENT_POST.register(FTBLibraryClient::clientTick);
        ReloadListenerRegistry.register((PackType)PackType.CLIENT_RESOURCES, (PreparableReloadListener)SidebarButtonManager.INSTANCE);
        ReloadListenerRegistry.register((PackType)PackType.CLIENT_RESOURCES, (PreparableReloadListener)SelectImageResourceScreen.ResourceListener.INSTANCE);
        ReloadListenerRegistry.register((PackType)PackType.CLIENT_RESOURCES, (PreparableReloadListener)new EntityIconLoader());
    }

    private static void guiInit(Screen screen, ScreenAccess access) {
        if (FTBLibraryClient.areButtonsVisible(screen)) {
            access.addRenderableWidget((AbstractWidget)new SidebarGroupGuiButton());
        }
    }

    private static void clientTick(Minecraft client) {
        CursorType t;
        CursorType cursorType = t = client.screen instanceof IScreenWrapper ? ((IScreenWrapper)client.screen).getGui().getCursor() : null;
        if (lastCursorType != t) {
            lastCursorType = t;
            CursorType.set(t);
        }
        if (!ClientUtils.RUN_LATER.isEmpty()) {
            for (Runnable runnable : new ArrayList<Runnable>(ClientUtils.RUN_LATER)) {
                runnable.run();
            }
            ClientUtils.RUN_LATER.clear();
        }
    }

    public static boolean areButtonsVisible(@Nullable Screen gui) {
        if (Minecraft.getInstance().level == null || Minecraft.getInstance().player == null) {
            return false;
        }
        if (!((Boolean)FTBLibraryClientConfig.SIDEBAR_ENABLED.get()).booleanValue()) {
            return false;
        }
        return gui instanceof AbstractContainerScreen && !SidebarButtonManager.INSTANCE.getButtons().isEmpty();
    }
}

