/*
 * Decompiled with CFR 0.152.
 */
package dev.qther.ars_controle.util;

import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import com.mojang.authlib.GameProfile;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import java.time.Duration;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.SkullBlockEntity;
import net.neoforged.neoforge.server.ServerLifecycleHooks;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class Cached {
    public static final Cache<UUID, Entity> ENTITIES_BY_UUID = CacheBuilder.newBuilder().weakValues().expireAfterAccess(Duration.ofMinutes(10L)).initialCapacity(8).build();
    private static final Map<UUID, CompletableFuture<Optional<GameProfile>>> PLAYER_NAME_BY_UUID = new Object2ObjectOpenHashMap();

    @Nullable
    public static ServerLevel getLevelByName(@NotNull String name) {
        ResourceLocation loc = ResourceLocation.tryParse((String)name);
        if (loc == null) {
            return null;
        }
        return Cached.getLevelByLoc(loc);
    }

    @Nullable
    public static ServerLevel getLevelByLoc(@NotNull ResourceLocation loc) {
        return Cached.getLevelByKey((ResourceKey<Level>)ResourceKey.create((ResourceKey)Registries.DIMENSION, (ResourceLocation)loc));
    }

    @Nullable
    public static ServerLevel getLevelByKey(@NotNull ResourceKey<Level> key) {
        MinecraftServer server = ServerLifecycleHooks.getCurrentServer();
        if (server == null) {
            return null;
        }
        return server.getLevel(key);
    }

    @Nullable
    public static Entity getEntityByUUID(@NotNull UUID uuid) {
        MinecraftServer server = ServerLifecycleHooks.getCurrentServer();
        return server != null ? Cached.getEntityByUUID(server.getAllLevels(), uuid) : null;
    }

    @Nullable
    public static Entity getEntityByUUID(@NotNull Iterable<ServerLevel> levels, @NotNull UUID uuid) {
        Entity cached = (Entity)ENTITIES_BY_UUID.getIfPresent((Object)uuid);
        if (cached != null && cached.isAlive()) {
            return cached;
        }
        for (ServerLevel l : levels) {
            Entity entity = (Entity)l.getEntities().get(uuid);
            if (entity == null || !entity.isAlive()) continue;
            ENTITIES_BY_UUID.put((Object)uuid, (Object)entity);
            return entity;
        }
        return null;
    }

    public static CompletableFuture<Optional<GameProfile>> getGameProfileFromUUID(@NotNull UUID uuid) {
        return PLAYER_NAME_BY_UUID.computeIfAbsent(uuid, SkullBlockEntity::fetchGameProfile);
    }
}

