/*
 * Decompiled with CFR 0.152.
 */
package dev.qther.ars_controle.mixin;

import com.hollingsworth.arsnouveau.api.ritual.AbstractRitual;
import com.hollingsworth.arsnouveau.common.block.tile.RitualBrazierTile;
import com.llamalad7.mixinextras.injector.ModifyReturnValue;
import dev.qther.ars_controle.item.PortableBrazierRelayItem;
import java.util.Map;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;

@Mixin(value={AbstractRitual.class})
public class AbstractRitualMixin {
    @Shadow
    public RitualBrazierTile tile;

    @ModifyReturnValue(method={"getWorld"}, at={@At(value="RETURN")})
    public Level getWorld(Level original) {
        if (original instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)original;
            Map<AbstractRitual, Player> rituals = PortableBrazierRelayItem.getRelayedRituals();
            Player player = rituals.get((AbstractRitual)this);
            if (player != null) {
                return player.level();
            }
        }
        return original;
    }

    @ModifyReturnValue(method={"getPos"}, at={@At(value="RETURN")})
    public BlockPos getPos(BlockPos original) {
        Level level = this.tile.getLevel();
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            Map<AbstractRitual, Player> rituals = PortableBrazierRelayItem.getRelayedRituals();
            Player player = rituals.get((AbstractRitual)this);
            if (player != null) {
                return player.blockPosition();
            }
        }
        return original;
    }
}

