/*
 * Decompiled with CFR 0.152.
 */
package dev.qther.ars_controle.datagen;

import com.google.gson.JsonElement;
import com.hollingsworth.arsnouveau.api.spell.AbstractSpellPart;
import com.hollingsworth.arsnouveau.common.crafting.recipes.EnchantingApparatusRecipe;
import com.hollingsworth.arsnouveau.common.crafting.recipes.GlyphRecipe;
import com.hollingsworth.arsnouveau.common.crafting.recipes.ImbuementRecipe;
import com.hollingsworth.arsnouveau.common.datagen.ApparatusRecipeBuilder;
import com.hollingsworth.arsnouveau.common.datagen.ApparatusRecipeProvider;
import com.hollingsworth.arsnouveau.common.datagen.GlyphRecipeProvider;
import com.hollingsworth.arsnouveau.common.datagen.ImbuementRecipeProvider;
import com.hollingsworth.arsnouveau.common.spell.augment.AugmentRandomize;
import com.hollingsworth.arsnouveau.setup.registry.BlockRegistry;
import com.hollingsworth.arsnouveau.setup.registry.ItemsRegistry;
import com.hollingsworth.arsnouveau.setup.registry.RegistryHelper;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import dev.qther.ars_controle.registry.ACRegistry;
import dev.qther.ars_controle.spell.effect.EffectPreciseDelay;
import dev.qther.ars_controle.spell.filter.FilterBinary;
import dev.qther.ars_controle.spell.filter.FilterRandom;
import dev.qther.ars_controle.spell.filter.FilterUnary;
import dev.qther.ars_controle.spell.filter.FilterYLevel;
import java.nio.file.Path;
import net.minecraft.data.CachedOutput;
import net.minecraft.data.DataGenerator;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;
import net.neoforged.neoforge.common.Tags;

public class ACArsProviders {
    static String root = "ars_controle";

    public static class ImbuementProvider
    extends ImbuementRecipeProvider {
        public ImbuementProvider(DataGenerator generatorIn) {
            super(generatorIn);
        }

        public void collectJsons(CachedOutput cache) {
            Path output = this.generator.getPackOutput().getOutputFolder();
            for (ImbuementRecipe g : this.recipes) {
                Path path = this.getRecipePath(output, g.id.getPath());
                this.saveStable(cache, (JsonElement)ImbuementRecipe.CODEC.encodeStart((DynamicOps)JsonOps.INSTANCE, (Object)g).getOrThrow(), path);
            }
        }

        protected Path getRecipePath(Path pathIn, String str) {
            return pathIn.resolve("data/" + root + "/recipe/" + str + ".json");
        }

        public String getName() {
            return "Ars Controle Imbuement";
        }
    }

    public static class EnchantingAppProvider
    extends ApparatusRecipeProvider {
        public EnchantingAppProvider(DataGenerator generatorIn) {
            super(generatorIn);
        }

        public void collectJsons(CachedOutput cache) {
            this.addRecipe(this.builder().withResult(ACRegistry.Items.WARPING_SPELL_PRISM).withReagent((ItemLike)BlockRegistry.SPELL_PRISM).withPedestalItem(4, Ingredient.of((TagKey)Tags.Items.ENDER_PEARLS)).withPedestalItem(4, Ingredient.of((ItemLike[])new ItemLike[]{Items.POPPED_CHORUS_FRUIT})).build());
            this.addRecipe(this.builder().withResult(ACRegistry.Items.SCRYERS_LINKAGE).withReagent((ItemLike)BlockRegistry.SCRYERS_CRYSTAL).withPedestalItem(4, Ingredient.of((TagKey)Tags.Items.ENDER_PEARLS)).withPedestalItem(4, Ingredient.of((ItemLike[])new ItemLike[]{Items.POPPED_CHORUS_FRUIT})).build());
            this.addRecipe(this.builder().withResult(ACRegistry.Items.TEMPORAL_STABILITY_SENSOR).withReagent((ItemLike)Items.CLOCK).withPedestalItem(1, Ingredient.of((ItemLike[])new ItemLike[]{Items.ENDER_EYE})).withPedestalItem(1, Ingredient.of((ItemLike[])new ItemLike[]{BlockRegistry.SOURCE_GEM_BLOCK})).build());
            this.addRecipe(this.builder().withResult(ACRegistry.Items.REMOTE).withReagent((ItemLike)ItemsRegistry.DOMINION_ROD).withPedestalItem(4, Ingredient.of((TagKey)Tags.Items.ENDER_PEARLS)).withPedestalItem(4, Ingredient.of((ItemLike[])new ItemLike[]{Items.POPPED_CHORUS_FRUIT})).build());
            this.addRecipe(this.builder().withResult(ACRegistry.Items.PORTABLE_BRAZIER_RELAY).withReagent((ItemLike)BlockRegistry.BRAZIER_RELAY).withPedestalItem(2, Ingredient.of((TagKey)Tags.Items.ENDER_PEARLS)).withPedestalItem(2, Ingredient.of((ItemLike[])new ItemLike[]{Items.POPPED_CHORUS_FRUIT})).withPedestalItem(2, Ingredient.of((ItemLike[])new ItemLike[]{ItemsRegistry.MANIPULATION_ESSENCE})).withPedestalItem(1, Ingredient.of((ItemLike[])new ItemLike[]{Items.NETHER_STAR})).withPedestalItem(1, Ingredient.of((ItemLike[])new ItemLike[]{ItemsRegistry.WILDEN_TRIBUTE})).build());
            Path output = this.generator.getPackOutput().getOutputFolder();
            for (ApparatusRecipeBuilder.RecipeWrapper g : this.recipes) {
                if (g == null) continue;
                Path path = EnchantingAppProvider.getRecipePath(output, g.id().getPath());
                this.saveStable(cache, (JsonElement)EnchantingApparatusRecipe.CODEC.encodeStart((DynamicOps)JsonOps.INSTANCE, (Object)g.recipe()).getOrThrow(), path);
            }
        }

        protected static Path getRecipePath(Path pathIn, String str) {
            return pathIn.resolve("data/" + root + "/recipe/" + str + ".json");
        }

        public String getName() {
            return "Ars Controle Apparatus";
        }
    }

    public static class GlyphProvider
    extends GlyphRecipeProvider {
        public GlyphProvider(DataGenerator generatorIn) {
            super(generatorIn);
        }

        public void collectJsons(CachedOutput cache) {
            Path output = this.generator.getPackOutput().getOutputFolder();
            this.recipes.add(this.get((AbstractSpellPart)EffectPreciseDelay.INSTANCE).withItem((ItemLike)ItemsRegistry.MANIPULATION_ESSENCE).withItem((ItemLike)Items.CLOCK).withItem((ItemLike)Items.COMPARATOR));
            this.recipes.add(this.get((AbstractSpellPart)FilterYLevel.ABOVE).withItem((ItemLike)ItemsRegistry.ALLOW_ITEM_SCROLL).withItem((ItemLike)Items.FEATHER));
            this.recipes.add(this.get((AbstractSpellPart)FilterYLevel.BELOW).withItem((ItemLike)ItemsRegistry.ALLOW_ITEM_SCROLL).withItem((ItemLike)Items.COBBLED_DEEPSLATE));
            this.recipes.add(this.get((AbstractSpellPart)FilterYLevel.LEVEL).withItem((ItemLike)ItemsRegistry.ALLOW_ITEM_SCROLL).withItem((ItemLike)Items.SHORT_GRASS));
            this.recipes.add(this.get((AbstractSpellPart)FilterBinary.OR).withItem((ItemLike)Items.COMPARATOR).withItem((ItemLike)Items.REDSTONE));
            this.recipes.add(this.get((AbstractSpellPart)FilterBinary.XOR).withItem((ItemLike)Items.COMPARATOR).withItem((ItemLike)Items.REDSTONE_TORCH));
            this.recipes.add(this.get((AbstractSpellPart)FilterBinary.XNOR).withItem((ItemLike)Items.COMPARATOR).withItem((ItemLike)Items.REDSTONE).withItem((ItemLike)Items.REDSTONE_TORCH));
            this.recipes.add(this.get((AbstractSpellPart)FilterUnary.NOT).withItem((ItemLike)ItemsRegistry.ALLOW_ITEM_SCROLL).withItem((ItemLike)Items.REDSTONE_TORCH));
            this.recipes.add(this.get((AbstractSpellPart)FilterRandom.INSTANCE).withItem((ItemLike)ItemsRegistry.ALLOW_ITEM_SCROLL).withItem((ItemLike)AugmentRandomize.INSTANCE.getGlyph()));
            for (GlyphRecipe recipe : this.recipes) {
                Path path = GlyphProvider.getScribeGlyphPath(output, recipe.output.getItem());
                this.saveStable(cache, (JsonElement)GlyphRecipe.CODEC.encodeStart((DynamicOps)JsonOps.INSTANCE, (Object)recipe).getOrThrow(), path);
            }
        }

        protected static Path getScribeGlyphPath(Path pathIn, Item glyph) {
            return pathIn.resolve("data/" + root + "/recipe/" + RegistryHelper.getRegistryName((Item)glyph).getPath() + ".json");
        }

        public String getName() {
            return "Ars Controle Glyph Recipes";
        }
    }
}

