/*
 * Decompiled with CFR 0.152.
 */
package dev.qther.ars_controle.block;

import com.hollingsworth.arsnouveau.api.block.IPrismaticBlock;
import com.hollingsworth.arsnouveau.api.event.SpellProjectileHitEvent;
import com.hollingsworth.arsnouveau.api.util.ANEventBus;
import com.hollingsworth.arsnouveau.api.util.BlockUtil;
import com.hollingsworth.arsnouveau.api.util.SourceUtil;
import com.hollingsworth.arsnouveau.common.advancement.ANCriteriaTriggers;
import com.hollingsworth.arsnouveau.common.block.ModBlock;
import com.hollingsworth.arsnouveau.common.entity.EntityProjectileSpell;
import com.hollingsworth.arsnouveau.common.util.PortUtil;
import dev.qther.ars_controle.ArsControle;
import dev.qther.ars_controle.block.tile.WarpingSpellPrismTile;
import dev.qther.ars_controle.config.ACServerConfig;
import dev.qther.ars_controle.packets.clientbound.PacketRenderBlockOutline;
import java.lang.runtime.SwitchBootstraps;
import java.util.Comparator;
import java.util.Iterator;
import net.minecraft.advancements.critereon.PlayerTrigger;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Position;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.server.level.TicketType;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import net.neoforged.bus.api.Event;
import net.neoforged.neoforge.common.NeoForge;
import net.neoforged.neoforge.event.level.BlockEvent;
import net.neoforged.neoforge.network.PacketDistributor;
import org.jetbrains.annotations.NotNull;

public class WarpingSpellPrismBlock
extends ModBlock
implements IPrismaticBlock,
EntityBlock {
    @NotNull
    protected InteractionResult useWithoutItem(@NotNull BlockState state, @NotNull Level level, @NotNull BlockPos pos, @NotNull Player player, @NotNull BlockHitResult _hr) {
        HitResult hitResult;
        if (level.isClientSide) {
            return InteractionResult.SUCCESS;
        }
        if (ANEventBus.post((Event)new BlockEvent.BreakEvent(level, pos, state, player))) {
            return InteractionResult.FAIL;
        }
        BlockEntity te = level.getBlockEntity(pos);
        if (te == null) {
            ArsControle.LOGGER.warn("No tile entity in warping spell prism.");
            return InteractionResult.FAIL;
        }
        if (!(te instanceof WarpingSpellPrismTile)) {
            ArsControle.LOGGER.warn("Wrong tile entity in warping spell prism.");
            return InteractionResult.FAIL;
        }
        WarpingSpellPrismTile tile = (WarpingSpellPrismTile)te;
        if (player.isShiftKeyDown()) {
            tile.setEntityUUID(player.getUUID());
            tile.setChanged();
            PortUtil.sendMessage((Entity)player, (Component)Component.translatable((String)"ars_controle.target.set.self"));
            return InteractionResult.SUCCESS;
        }
        HitResult hitResult2 = hitResult = tile.getHitResult();
        int n = 0;
        switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{EntityHitResult.class, BlockHitResult.class}, (Object)hitResult2, n)) {
            case -1: {
                PortUtil.sendMessage((Entity)player, (Component)Component.translatable((String)"ars_controle.target.get.none"));
                return InteractionResult.SUCCESS;
            }
            case 0: {
                EntityHitResult e = (EntityHitResult)hitResult2;
                Entity entity = e.getEntity();
                PortUtil.sendMessage((Entity)player, (Component)Component.translatable((String)"ars_controle.target.get.entity", (Object[])new Object[]{entity.getDisplayName(), entity.level().dimension().location().toString()}));
                return InteractionResult.SUCCESS;
            }
            case 1: {
                BlockHitResult b = (BlockHitResult)hitResult2;
                ServerLevel dim = tile.getTargetLevel();
                if (player instanceof ServerPlayer) {
                    ServerPlayer serverPlayer = (ServerPlayer)player;
                    PortUtil.sendMessage((Entity)player, (Component)Component.translatable((String)"ars_controle.target.get.block", (Object[])new Object[]{b.getBlockPos().toShortString(), dim == null ? "<invalid>" : dim.dimension().location().toString()}));
                    if (serverPlayer.level().equals(dim)) {
                        PacketDistributor.sendToPlayer((ServerPlayer)serverPlayer, (CustomPacketPayload)new PacketRenderBlockOutline(b.getBlockPos(), 200L), (CustomPacketPayload[])new CustomPacketPayload[0]);
                    }
                }
                return InteractionResult.SUCCESS;
            }
        }
        return InteractionResult.PASS;
    }

    public void onHit(ServerLevel world, BlockPos pos, @NotNull EntityProjectileSpell spell) {
        EntityProjectileSpell newSpell;
        if (spell.spellResolver == null) {
            spell.remove(Entity.RemovalReason.DISCARDED);
            return;
        }
        WarpingSpellPrismTile tile = (WarpingSpellPrismTile)world.getBlockEntity(pos);
        if (tile == null) {
            ArsControle.LOGGER.error("No tile entity in warping spell prism.");
            return;
        }
        HitResult hit = tile.getHitResult();
        if (hit == null) {
            world.sendParticles((ParticleOptions)ParticleTypes.ANGRY_VILLAGER, (double)pos.getX() + 0.5, (double)pos.getY() + 0.5, (double)pos.getZ() + 0.5, 1, 0.0, 0.0, 0.0, 0.0);
            spell.remove(Entity.RemovalReason.DISCARDED);
            return;
        }
        ServerLevel dim = tile.getTargetLevel();
        if (dim == null) {
            world.sendParticles((ParticleOptions)ParticleTypes.ANGRY_VILLAGER, (double)pos.getX() + 0.5, (double)pos.getY() + 0.5, (double)pos.getZ() + 0.5, 1, 0.0, 0.0, 0.0, 0.0);
            spell.remove(Entity.RemovalReason.DISCARDED);
            return;
        }
        BlockPos hitPos = BlockPos.containing((Position)hit.getLocation());
        int loadTime = (Integer)ACServerConfig.SERVER.WARPING_SPELL_PRISM_LOAD_TIME.get();
        if (loadTime > 0) {
            ChunkPos loadPos = new ChunkPos(hitPos);
            dim.getChunkSource().addRegionTicket(TicketType.create((String)"warping_spell_prism", Comparator.comparingLong(ChunkPos::toLong), (int)loadTime), loadPos, 3, (Object)loadPos, true);
        } else if (!dim.isLoaded(hitPos)) {
            world.sendParticles((ParticleOptions)ParticleTypes.ANGRY_VILLAGER, (double)pos.getX() + 0.5, (double)pos.getY() + 0.5, (double)pos.getZ() + 0.5, 1, 0.0, 0.0, 0.0, 0.0);
            spell.remove(Entity.RemovalReason.DISCARDED);
            return;
        }
        Level oldLevel = spell.level();
        if (hit instanceof BlockHitResult) {
            BlockHitResult b = (BlockHitResult)hit;
            if (oldLevel != dim && (newSpell = WarpingSpellPrismBlock.changeSpellLevel(dim, spell)) != null) {
                spell = newSpell;
            }
            hit = b.withDirection(spell.getDirection());
        }
        if (hit instanceof EntityHitResult) {
            Entity entity;
            EntityHitResult e = (EntityHitResult)hit;
            if (oldLevel != dim && (newSpell = WarpingSpellPrismBlock.changeSpellLevel(dim, spell)) != null) {
                spell = newSpell;
            }
            if (!(entity = e.getEntity()).isAlive()) {
                tile.setEntityUUID(null);
                world.sendParticles((ParticleOptions)ParticleTypes.ANGRY_VILLAGER, (double)pos.getX() + 0.5, (double)pos.getY() + 0.5, (double)pos.getZ() + 0.5, 1, 0.0, 0.0, 0.0, 0.0);
                spell.remove(Entity.RemovalReason.DISCARDED);
                return;
            }
            SpellProjectileHitEvent event = new SpellProjectileHitEvent(spell, hit);
            NeoForge.EVENT_BUS.post((Event)event);
            if (event.isCanceled()) {
                return;
            }
            spell.spellResolver.onResolveEffect(spell.level(), (HitResult)new EntityHitResult(entity, hit.getLocation()));
            spell.remove(Entity.RemovalReason.DISCARDED);
            return;
        }
        Vec3 oldPos = spell.position();
        Vec3 newPos = hit.getLocation();
        if (newPos.equals((Object)oldPos) && oldLevel == spell.level()) {
            return;
        }
        spell.setPos(newPos);
        int manaCost = tile.getSourceRequired(hit);
        if (manaCost > 0 && SourceUtil.takeSourceMultipleWithParticles((BlockPos)pos, (Level)world, (int)19, (int)manaCost) == null) {
            world.sendParticles((ParticleOptions)ParticleTypes.WITCH, (double)pos.getX() + 0.5, (double)(pos.getY() + 1), (double)pos.getZ() + 0.5, world.random.nextInt(4) + 1, 0.0, 0.0, 0.0, 0.0);
            spell.remove(Entity.RemovalReason.DISCARDED);
            return;
        }
        if (++spell.prismRedirect >= 3) {
            ANCriteriaTriggers.rewardNearbyPlayers((PlayerTrigger)((PlayerTrigger)ANCriteriaTriggers.PRISMATIC.get()), (ServerLevel)world, (BlockPos)pos, (int)10);
        }
        if (spell.level().getBlockCollisions((Entity)spell, spell.getBoundingBox()).iterator().hasNext()) {
            SpellProjectileHitEvent event = new SpellProjectileHitEvent(spell, hit);
            NeoForge.EVENT_BUS.post((Event)event);
            if (event.isCanceled()) {
                return;
            }
            spell.spellResolver.onResolveEffect(spell.level(), hit);
            spell.remove(Entity.RemovalReason.DISCARDED);
        } else {
            Iterator entities = spell.level().getEntities((Entity)spell, spell.getBoundingBox()).iterator();
            if (entities.hasNext()) {
                Entity e = (Entity)entities.next();
                SpellProjectileHitEvent event = new SpellProjectileHitEvent(spell, hit);
                NeoForge.EVENT_BUS.post((Event)event);
                if (event.isCanceled()) {
                    return;
                }
                spell.spellResolver.onResolveEffect(spell.level(), (HitResult)new EntityHitResult(e, spell.position()));
                spell.remove(Entity.RemovalReason.DISCARDED);
            } else {
                spell.setPos(spell.position().subtract(spell.getDeltaMovement()));
            }
        }
        BlockUtil.updateObservers((Level)world, (BlockPos)pos);
    }

    public BlockEntity newBlockEntity(@NotNull BlockPos pPos, @NotNull BlockState pState) {
        return new WarpingSpellPrismTile(pPos, pState);
    }

    public static EntityProjectileSpell changeSpellLevel(ServerLevel level, EntityProjectileSpell old) {
        EntityProjectileSpell spell = (EntityProjectileSpell)old.getType().create((Level)level);
        if (spell != null) {
            spell.restoreFrom((Entity)old);
            spell.spellResolver = old.spellResolver;
            spell.prismRedirect = old.prismRedirect;
            spell.age = old.age;
            spell.pierceLeft = old.pierceLeft;
            spell.numSensitive = old.numSensitive;
            spell.setDeltaMovement(old.getDeltaMovement());
            level.addDuringTeleport((Entity)spell);
            old.remove(Entity.RemovalReason.CHANGED_DIMENSION);
        }
        return spell;
    }
}

