/*
 * Decompiled with CFR 0.152.
 */
package dev.qther.ars_controle.block;

import com.hollingsworth.arsnouveau.common.block.ModBlock;
import com.hollingsworth.arsnouveau.common.block.PortalBlock;
import com.hollingsworth.arsnouveau.common.util.VoxelShapeUtils;
import dev.qther.ars_controle.block.tile.ScrollHolderTile;
import java.util.stream.Stream;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.ItemInteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.DirectionalBlock;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.BooleanOp;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.neoforged.neoforge.items.IItemHandler;
import org.jetbrains.annotations.NotNull;

public class ScrollHolderBlock
extends ModBlock
implements EntityBlock {
    public static final DirectionProperty FACING = DirectionalBlock.FACING;
    public static final BooleanProperty HAS_SCROLL = BooleanProperty.create((String)"has_scroll");
    public static final VoxelShape UP = Stream.of(Shapes.box((double)0.0, (double)0.875, (double)0.0, (double)1.0, (double)1.0, (double)1.0), Shapes.box((double)0.0, (double)0.0, (double)0.0, (double)1.0, (double)0.125, (double)0.375), Shapes.box((double)0.0, (double)0.0, (double)0.375, (double)0.375, (double)0.125, (double)0.625), Shapes.box((double)0.375, (double)0.0625, (double)0.375, (double)0.625, (double)0.1875, (double)0.625), Shapes.box((double)0.625, (double)0.0, (double)0.375, (double)1.0, (double)0.125, (double)0.625), Shapes.box((double)0.0, (double)0.0, (double)0.625, (double)1.0, (double)0.125, (double)1.0), Shapes.box((double)0.375, (double)0.8125, (double)0.375, (double)0.625, (double)0.875, (double)0.625), Shapes.box((double)0.0, (double)0.125, (double)0.0, (double)0.375, (double)0.875, (double)0.375), Shapes.box((double)0.625, (double)0.125, (double)0.0, (double)1.0, (double)0.875, (double)0.375), Shapes.box((double)0.0, (double)0.125, (double)0.625, (double)0.375, (double)0.875, (double)1.0), Shapes.box((double)0.625, (double)0.125, (double)0.625, (double)1.0, (double)0.875, (double)1.0)).reduce((v1, v2) -> Shapes.join((VoxelShape)v1, (VoxelShape)v2, (BooleanOp)BooleanOp.OR)).get();
    public static final VoxelShape DOWN = VoxelShapeUtils.rotate((VoxelShape)UP, (Direction)Direction.UP);
    public static final VoxelShape EAST = VoxelShapeUtils.rotate((VoxelShape)UP, (Direction)Direction.WEST);
    public static final VoxelShape WEST = VoxelShapeUtils.rotate((VoxelShape)UP, (Direction)Direction.EAST);
    public static final VoxelShape NORTH = VoxelShapeUtils.rotate((VoxelShape)UP, (Direction)Direction.SOUTH);
    public static final VoxelShape SOUTH = VoxelShapeUtils.rotate((VoxelShape)UP, (Direction)Direction.NORTH);

    public ScrollHolderBlock() {
        this.registerDefaultState((BlockState)((BlockState)((BlockState)this.stateDefinition.any()).setValue((Property)FACING, (Comparable)Direction.UP)).setValue((Property)HAS_SCROLL, (Comparable)Boolean.valueOf(false)));
    }

    public BlockEntity newBlockEntity(@NotNull BlockPos pPos, @NotNull BlockState pState) {
        return new ScrollHolderTile(pPos, pState);
    }

    public BlockState getStateForPlacement(BlockPlaceContext context) {
        return (BlockState)this.defaultBlockState().setValue((Property)FACING, (Comparable)context.getNearestLookingDirection().getOpposite());
    }

    @NotNull
    protected BlockState rotate(BlockState state, Rotation rotation) {
        return (BlockState)state.setValue((Property)FACING, (Comparable)rotation.rotate((Direction)state.getValue((Property)FACING)));
    }

    @NotNull
    protected BlockState mirror(BlockState state, Mirror mirror) {
        return state.rotate(mirror.getRotation((Direction)state.getValue((Property)FACING)));
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        builder.add(new Property[]{FACING, HAS_SCROLL});
    }

    protected void neighborChanged(@NotNull BlockState state, @NotNull Level level, @NotNull BlockPos pos, @NotNull Block neighborBlock, @NotNull BlockPos neighborPos, boolean movedByPiston) {
        BlockEntity blockEntity;
        super.neighborChanged(state, level, pos, neighborBlock, neighborPos, movedByPiston);
        Block newBlock = level.getBlockState(pos).getBlock();
        if (!(newBlock instanceof PortalBlock) && (blockEntity = level.getBlockEntity(pos)) instanceof ScrollHolderTile) {
            ScrollHolderTile tile = (ScrollHolderTile)blockEntity;
            tile.update();
        }
    }

    @NotNull
    protected ItemInteractionResult useItemOn(@NotNull ItemStack stack, @NotNull BlockState state, @NotNull Level level, @NotNull BlockPos pos, @NotNull Player player, @NotNull InteractionHand hand, @NotNull BlockHitResult hitResult) {
        if (!(level instanceof ServerLevel)) {
            return ItemInteractionResult.SUCCESS;
        }
        BlockEntity blockEntity = level.getBlockEntity(pos);
        if (blockEntity instanceof ScrollHolderTile) {
            ScrollHolderTile tile = (ScrollHolderTile)blockEntity;
            IItemHandler cap = tile.getItemHandler();
            boolean hasSpace = cap.getStackInSlot(0).isEmpty();
            if (cap.isItemValid(0, stack)) {
                cap.insertItem(0, stack, false);
                return ItemInteractionResult.SUCCESS;
            }
            if (!hasSpace) {
                ItemStack extracted = cap.extractItem(0, 1, false);
                if (!extracted.isEmpty()) {
                    player.addItem(extracted);
                }
                return ItemInteractionResult.SUCCESS;
            }
        }
        return super.useItemOn(stack, state, level, pos, player, hand, hitResult);
    }

    protected void onRemove(@NotNull BlockState state, @NotNull Level level, @NotNull BlockPos pos, @NotNull BlockState newState, boolean movedByPiston) {
        ScrollHolderTile tile;
        ItemStack stack;
        BlockEntity blockEntity;
        if (level instanceof ServerLevel && !newState.is(state.getBlock()) && (blockEntity = level.getBlockEntity(pos)) instanceof ScrollHolderTile && !(stack = (tile = (ScrollHolderTile)blockEntity).getStack()).isEmpty()) {
            Vec3 sp = pos.getCenter();
            level.addFreshEntity((Entity)new ItemEntity(level, sp.x, sp.y, sp.z, stack));
        }
        super.onRemove(state, level, pos, newState, movedByPiston);
    }

    protected boolean hasAnalogOutputSignal(@NotNull BlockState state) {
        return true;
    }

    protected int getAnalogOutputSignal(@NotNull BlockState state, @NotNull Level level, @NotNull BlockPos pos) {
        return (Boolean)state.getValue((Property)HAS_SCROLL) != false ? 15 : 0;
    }

    @NotNull
    public VoxelShape getShape(BlockState state, @NotNull BlockGetter worldIn, @NotNull BlockPos pos, @NotNull CollisionContext context) {
        Direction facing = (Direction)state.getValue((Property)BlockStateProperties.FACING);
        return switch (facing) {
            default -> throw new MatchException(null, null);
            case Direction.UP -> UP;
            case Direction.DOWN -> DOWN;
            case Direction.NORTH -> NORTH;
            case Direction.SOUTH -> SOUTH;
            case Direction.WEST -> WEST;
            case Direction.EAST -> EAST;
        };
    }
}

