/*
 * Decompiled with CFR 0.152.
 */
package wile.redstonepen.libmc;

import java.util.HashMap;
import java.util.Map;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.neoforged.neoforge.network.PacketDistributor;
import net.neoforged.neoforge.network.registration.PayloadRegistrar;
import wile.redstonepen.libmc.Auxiliaries;

public class Networking {
    public static void init(PayloadRegistrar registrar) {
        registrar.playBidirectional(UnifiedPayload.TYPE, UnifiedPayload.STREAM_CODEC, (unifed_payload, context) -> {
            Player patt0$temp = context.player();
            if (patt0$temp instanceof ServerPlayer) {
                ServerPlayer player = (ServerPlayer)patt0$temp;
                ServerLevel world = player.serverLevel();
                if (player == null) {
                    return;
                }
                CompoundTag payload = unifed_payload.data().nbt();
                player.server.execute(() -> {
                    switch (unifed_payload.data().id()) {
                        case "tnc2s": {
                            BlockPos pos = BlockPos.of((long)payload.getLong("pos"));
                            CompoundTag nbt = payload.getCompound("nbt");
                            BlockEntity te = world.getBlockEntity(pos);
                            if (!(te instanceof IPacketTileNotifyReceiver)) {
                                return;
                            }
                            ((IPacketTileNotifyReceiver)te).onClientPacketReceived((Player)player, nbt);
                            break;
                        }
                        case "csc2s": {
                            int container_id = payload.getInt("cid");
                            CompoundTag nbt = payload.getCompound("nbt");
                            AbstractContainerMenu patt0$temp = player.containerMenu;
                            if (!(patt0$temp instanceof INetworkSynchronisableContainer)) {
                                return;
                            }
                            INetworkSynchronisableContainer nsc = (INetworkSynchronisableContainer)patt0$temp;
                            if (player.containerMenu.containerId != container_id) {
                                return;
                            }
                            nsc.onClientPacketReceived(container_id, (Player)player, nbt);
                            break;
                        }
                        case "nnc2s": {
                            String hnd = payload.getString("hnd");
                            CompoundTag nbt = payload.getCompound("nbt");
                            if (hnd.isEmpty() || !PacketNbtNotifyClientToServer.handlers.containsKey(hnd)) {
                                return;
                            }
                            PacketNbtNotifyClientToServer.handlers.get(hnd).accept((Player)player, nbt);
                        }
                    }
                });
            } else {
                LocalPlayer player = (LocalPlayer)context.player();
                Level world = player.level();
                CompoundTag payload = unifed_payload.data().nbt();
                context.enqueueWork(() -> {
                    switch (unifed_payload.data().id()) {
                        case "tns2c": {
                            BlockPos pos = BlockPos.of((long)payload.getLong("pos"));
                            CompoundTag nbt = payload.getCompound("nbt");
                            BlockEntity te = world.getBlockEntity(pos);
                            if (!(te instanceof IPacketTileNotifyReceiver)) {
                                return;
                            }
                            IPacketTileNotifyReceiver nte = (IPacketTileNotifyReceiver)te;
                            nte.onServerPacketReceived(nbt);
                            break;
                        }
                        case "css2c": {
                            int container_id = payload.getInt("cid");
                            CompoundTag nbt = payload.getCompound("nbt");
                            AbstractContainerMenu patt0$temp = player.containerMenu;
                            if (!(patt0$temp instanceof INetworkSynchronisableContainer)) {
                                return;
                            }
                            INetworkSynchronisableContainer nsc = (INetworkSynchronisableContainer)patt0$temp;
                            if (player.containerMenu.containerId != container_id) {
                                return;
                            }
                            nsc.onServerPacketReceived(container_id, nbt);
                            break;
                        }
                        case "nns2c": {
                            String hnd = payload.getString("hnd");
                            CompoundTag nbt = payload.getCompound("nbt");
                            if (hnd.isEmpty() || !PacketNbtNotifyServerToClient.handlers.containsKey(hnd)) {
                                return;
                            }
                            PacketNbtNotifyServerToClient.handlers.get(hnd).accept(nbt);
                            break;
                        }
                        case "otms2c": {
                            Component m;
                            if (OverlayTextMessage.handler_ == null) {
                                return;
                            }
                            int delay = payload.getInt("delay");
                            if (delay <= 0) {
                                return;
                            }
                            String deserialized = payload.getString("msg");
                            try {
                                m = Auxiliaries.unserializeTextComponent(deserialized, (HolderLookup.Provider)world.registryAccess());
                            }
                            catch (Throwable e) {
                                m = Component.translatable((String)"[incorrect translation]");
                            }
                            Component message = m;
                            OverlayTextMessage.handler_.accept(message, delay);
                        }
                    }
                });
            }
        });
    }

    private static void sendToClient(ServerPlayer player, String packet_id, CompoundTag payload_nbt) {
        PacketDistributor.sendToPlayer((ServerPlayer)player, (CustomPacketPayload)new UnifiedPayload(new UnifiedPayload.UnifiedData(packet_id, payload_nbt)), (CustomPacketPayload[])new CustomPacketPayload[0]);
    }

    private static void sendToClients(ServerLevel world, String packet_id, CompoundTag payload_nbt) {
        UnifiedPayload payload = new UnifiedPayload(new UnifiedPayload.UnifiedData(packet_id, payload_nbt));
        for (ServerPlayer player : world.players()) {
            PacketDistributor.sendToPlayer((ServerPlayer)player, (CustomPacketPayload)payload, (CustomPacketPayload[])new CustomPacketPayload[0]);
        }
    }

    public record UnifiedPayload(UnifiedData data) implements CustomPacketPayload
    {
        public static final StreamCodec<FriendlyByteBuf, UnifiedPayload> STREAM_CODEC = CustomPacketPayload.codec(UnifiedPayload::write, UnifiedPayload::new);
        public static final CustomPacketPayload.Type<UnifiedPayload> TYPE = new CustomPacketPayload.Type(ResourceLocation.fromNamespaceAndPath((String)"redstonepen", (String)"unpnbt"));

        private UnifiedPayload(FriendlyByteBuf buf) {
            this(new UnifiedData(buf.readUtf(), buf.readNbt()));
        }

        public static CustomPacketPayload.Type<UnifiedPayload> getTYPE() {
            return TYPE;
        }

        private void write(FriendlyByteBuf buf) {
            this.data.write(buf);
        }

        public CustomPacketPayload.Type<UnifiedPayload> type() {
            return TYPE;
        }

        public record UnifiedData(String id, CompoundTag nbt) {
            public UnifiedData(FriendlyByteBuf buf) {
                this(buf.readUtf(), buf.readNbt());
            }

            public void write(FriendlyByteBuf buf) {
                buf.writeUtf(this.id);
                buf.writeNbt((Tag)this.nbt);
            }

            @Override
            public String toString() {
                return this.id + ": " + this.nbt.toString();
            }
        }
    }

    public static interface IPacketTileNotifyReceiver {
        default public void onServerPacketReceived(CompoundTag nbt) {
        }

        default public void onClientPacketReceived(Player player, CompoundTag nbt) {
        }
    }

    public static interface INetworkSynchronisableContainer {
        public void onServerPacketReceived(int var1, CompoundTag var2);

        public void onClientPacketReceived(int var1, Player var2, CompoundTag var3);
    }

    public static class PacketNbtNotifyServerToClient {
        protected static final String PACKET_ID = "nns2c";
        public static final Map<String, Consumer<CompoundTag>> handlers = new HashMap<String, Consumer<CompoundTag>>();

        public static void sendToPlayer(Player player, CompoundTag nbt) {
            if (nbt == null || !(player instanceof ServerPlayer)) {
                return;
            }
            ServerPlayer splayer = (ServerPlayer)player;
            Networking.sendToClient(splayer, PACKET_ID, nbt);
        }

        public static void sendToPlayers(Level world, String handler, CompoundTag nbt) {
            if (world != null) {
                for (Player player : world.players()) {
                    PacketNbtNotifyServerToClient.sendToPlayer(player, nbt);
                }
            }
        }
    }

    public static class OverlayTextMessage {
        protected static final String PACKET_ID = "otms2c";
        protected static BiConsumer<Component, Integer> handler_ = null;
        public static final int DISPLAY_TIME_MS = 3000;

        public static void setHandler(BiConsumer<Component, Integer> handler) {
            if (handler_ == null) {
                handler_ = handler;
            }
        }

        public static void sendToPlayer(ServerPlayer player, Component message) {
            OverlayTextMessage.sendToPlayer(player, message, 3000);
        }

        public static void sendToPlayer(ServerPlayer player, Component message, int delay) {
            if (Auxiliaries.isEmpty(message)) {
                return;
            }
            try {
                CompoundTag payload = new CompoundTag();
                payload.putInt("delay", delay);
                payload.putString("msg", Auxiliaries.serializeTextComponent(message, (HolderLookup.Provider)player.registryAccess()));
                Networking.sendToClient(player, PACKET_ID, payload);
            }
            catch (Throwable e) {
                Auxiliaries.logger().error("OverlayTextMessage.toBytes() failed: " + String.valueOf(e));
            }
        }
    }

    public static class PacketNbtNotifyClientToServer {
        protected static final String PACKET_ID = "nnc2s";
        public static final Map<String, BiConsumer<Player, CompoundTag>> handlers = new HashMap<String, BiConsumer<Player, CompoundTag>>();
    }

    public static class PacketContainerSyncServerToClient {
        protected static final String PACKET_ID = "css2c";

        public static void sendToPlayer(ServerPlayer player, int windowId, CompoundTag nbt) {
            if (nbt == null || player == null) {
                return;
            }
            CompoundTag payload = new CompoundTag();
            payload.putInt("cid", windowId);
            payload.put("nbt", (Tag)nbt);
            Networking.sendToClient(player, PACKET_ID, payload);
        }

        public static void sendToPlayer(ServerPlayer player, AbstractContainerMenu container, CompoundTag nbt) {
            if (container != null) {
                PacketContainerSyncServerToClient.sendToPlayer(player, container.containerId, nbt);
            }
        }

        public static <C extends AbstractContainerMenu> void sendToListeners(Level world, C container, CompoundTag nbt) {
            for (Player player : world.players()) {
                if (player.containerMenu.containerId != container.containerId) continue;
                PacketContainerSyncServerToClient.sendToPlayer((ServerPlayer)player, container.containerId, nbt);
            }
        }
    }

    public static class PacketContainerSyncClientToServer {
        protected static final String PACKET_ID = "csc2s";
    }

    public static class PacketTileNotifyServerToClient {
        protected static final String PACKET_ID = "tns2c";

        public static void sendToPlayer(ServerPlayer player, BlockEntity te, CompoundTag nbt) {
            if (te == null || nbt == null) {
                return;
            }
            CompoundTag payload = new CompoundTag();
            payload.putLong("pos", te.getBlockPos().asLong());
            payload.put("nbt", (Tag)nbt);
            Networking.sendToClient(player, PACKET_ID, payload);
        }

        public static void sendToPlayers(BlockEntity te, CompoundTag nbt) {
            Level level;
            if (te == null || !((level = te.getLevel()) instanceof ServerLevel)) {
                return;
            }
            ServerLevel sworld = (ServerLevel)level;
            CompoundTag payload = new CompoundTag();
            payload.putLong("pos", te.getBlockPos().asLong());
            payload.put("nbt", (Tag)nbt);
            Networking.sendToClients(sworld, PACKET_ID, payload);
        }
    }

    public static class PacketTileNotifyClientToServer {
        protected static final String PACKET_ID = "tnc2s";
    }
}

