/*
 * Decompiled with CFR 0.152.
 */
package wile.redstonepen.libmc;

import com.mojang.blaze3d.platform.InputConstants;
import java.io.BufferedReader;
import java.io.File;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import java.nio.file.Path;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.font.TextFieldHelper;
import net.minecraft.client.resources.language.I18n;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.Vec3i;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.core.component.DataComponents;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.ComponentUtils;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.Style;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.RandomSource;
import net.minecraft.util.StringUtil;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.component.CustomData;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.BooleanOp;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import net.neoforged.fml.ModList;
import net.neoforged.fml.loading.FMLLoader;
import net.neoforged.neoforge.common.util.FakePlayer;
import net.neoforged.neoforge.common.util.FakePlayerFactory;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Auxiliaries {
    private static final Logger logger = LoggerFactory.getLogger((String)"redstonepen");
    private static final String development_mode_control_file = ".redstonepen-dev";
    private static boolean development_mode = false;

    public static void init() {
        try {
            development_mode = new File(Auxiliaries.getGameDirectory().resolve(development_mode_control_file).toString()).isFile();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    public static String modid() {
        return "redstonepen";
    }

    public static Logger logger() {
        return logger;
    }

    public static Path getGameDirectory() {
        return FMLLoader.getGamePath();
    }

    public static boolean isModLoaded(String registry_name) {
        return ModList.get().isLoaded(registry_name);
    }

    public static boolean isDevelopmentMode() {
        return development_mode;
    }

    public static String getDevelopmentModeControlFile() {
        return development_mode_control_file;
    }

    @OnlyIn(value=Dist.CLIENT)
    public static boolean isShiftDown() {
        return InputConstants.isKeyDown((long)Minecraft.getInstance().getWindow().getWindow(), (int)340) || InputConstants.isKeyDown((long)Minecraft.getInstance().getWindow().getWindow(), (int)344);
    }

    @OnlyIn(value=Dist.CLIENT)
    public static boolean isCtrlDown() {
        return InputConstants.isKeyDown((long)Minecraft.getInstance().getWindow().getWindow(), (int)341) || InputConstants.isKeyDown((long)Minecraft.getInstance().getWindow().getWindow(), (int)345);
    }

    @OnlyIn(value=Dist.CLIENT)
    public static Optional<String> getClipboard() {
        return Optional.of(TextFieldHelper.getClipboardContents((Minecraft)Minecraft.getInstance()));
    }

    @OnlyIn(value=Dist.CLIENT)
    public static boolean setClipboard(String text) {
        TextFieldHelper.setClipboardContents((Minecraft)Minecraft.getInstance(), (String)text);
        return true;
    }

    public static void logInfo(String msg) {
        logger.info(msg);
    }

    public static void logWarn(String msg) {
        logger.warn(msg);
    }

    public static void logError(String msg) {
        logger.error(msg);
    }

    public static void logDebug(String msg) {
    }

    public static MutableComponent localizable(String modtrkey, Object ... args) {
        return Component.translatable((String)(modtrkey.startsWith("block.") || modtrkey.startsWith("item.") ? modtrkey : Auxiliaries.modid() + "." + modtrkey), (Object[])args);
    }

    public static MutableComponent localizable(String modtrkey, @Nullable ChatFormatting color, Object ... args) {
        MutableComponent tr = Component.translatable((String)(Auxiliaries.modid() + "." + modtrkey), (Object[])args);
        if (color != null) {
            tr.getStyle().applyFormat(color);
        }
        return tr;
    }

    public static MutableComponent localizable(String modtrkey) {
        return Auxiliaries.localizable(modtrkey, new Object[0]);
    }

    public static MutableComponent localizable_block_key(String blocksubkey) {
        return Component.translatable((String)("block." + Auxiliaries.modid() + "." + blocksubkey));
    }

    @OnlyIn(value=Dist.CLIENT)
    public static String localize(String translationKey, Object ... args) {
        MutableComponent tr = Component.translatable((String)translationKey, (Object[])args);
        tr.getStyle().applyFormat(ChatFormatting.RESET);
        return tr.getString().trim();
    }

    @OnlyIn(value=Dist.CLIENT)
    public static boolean hasTranslation(String key) {
        return I18n.exists((String)key);
    }

    @OnlyIn(value=Dist.CLIENT)
    public static List<Component> wrapText(Component text, int max_width_percent) {
        int max_width = (Minecraft.getInstance().getWindow().getGuiScaledWidth() - 10) * max_width_percent / 100;
        return Minecraft.getInstance().font.getSplitter().splitLines((FormattedText)text, max_width, Style.EMPTY).stream().map(ft -> Component.literal((String)ft.getString())).collect(Collectors.toList());
    }

    public static MutableComponent join(Collection<? extends Component> components, String separator) {
        return ComponentUtils.formatList(components, (Component)Component.literal((String)separator), Function.identity());
    }

    public static MutableComponent join(Component ... components) {
        MutableComponent tc = Component.empty();
        for (Component c : components) {
            tc.append(c);
        }
        return tc;
    }

    public static boolean isEmpty(Component component) {
        return component.getSiblings().isEmpty() && component.getString().isEmpty();
    }

    public static void playerChatMessage(Player player, String message) {
        player.displayClientMessage((Component)Component.translatable((String)message.trim()), true);
    }

    @Nullable
    public static Component unserializeTextComponent(String serialized, HolderLookup.Provider ra) {
        return Component.Serializer.fromJson((String)serialized, (HolderLookup.Provider)ra);
    }

    public static String serializeTextComponent(Component tc, HolderLookup.Provider ra) {
        return tc == null ? "" : Component.Serializer.toJson((Component)tc, (HolderLookup.Provider)ra);
    }

    public static ResourceLocation getResourceLocation(Item item) {
        return BuiltInRegistries.ITEM.getKey((Object)item);
    }

    public static ResourceLocation getResourceLocation(Block block) {
        return BuiltInRegistries.BLOCK.getKey((Object)block);
    }

    public static boolean hasItemStackNbt(ItemStack stack, String key) {
        CompoundTag nbt = ((CustomData)stack.getOrDefault(DataComponents.CUSTOM_DATA, (Object)CustomData.EMPTY)).getUnsafe();
        return nbt != null && nbt.contains(key, 10);
    }

    public static CompoundTag getItemStackNbt(ItemStack stack, String key) {
        CompoundTag nbt = ((CustomData)stack.getOrDefault(DataComponents.CUSTOM_DATA, (Object)CustomData.EMPTY)).getUnsafe();
        if (nbt == null) {
            return new CompoundTag();
        }
        Tag data = nbt.get(key);
        if (data == null || data.getId() != 10) {
            return new CompoundTag();
        }
        return (CompoundTag)data.copy();
    }

    public static void setItemStackNbt(ItemStack stack, String key, CompoundTag nbt) {
        if (key.isEmpty()) {
            return;
        }
        CustomData cd = (CustomData)stack.getOrDefault(DataComponents.CUSTOM_DATA, (Object)CustomData.of((CompoundTag)new CompoundTag()));
        CompoundTag cdt = cd.copyTag();
        if (nbt == null || nbt.isEmpty()) {
            cdt.remove(key);
        } else {
            cdt.put(key, (Tag)nbt);
        }
        CustomData.set((DataComponentType)DataComponents.CUSTOM_DATA, (ItemStack)stack, (CompoundTag)cdt);
    }

    @Nullable
    public static Component getItemLabel(ItemStack stack) {
        return (Component)stack.getComponents().getOrDefault(DataComponents.CUSTOM_NAME, (Object)Component.empty());
    }

    public static ItemStack setItemLabel(ItemStack stack, @Nullable Component name) {
        if (name == null || StringUtil.isBlank((String)name.getString())) {
            if (stack.has(DataComponents.CUSTOM_NAME)) {
                stack.remove(DataComponents.CUSTOM_NAME);
            }
        } else {
            stack.set(DataComponents.CUSTOM_NAME, (Object)name.copy());
        }
        return stack;
    }

    public static boolean isWaterLogged(BlockState state) {
        return state.hasProperty((Property)BlockStateProperties.WATERLOGGED) && (Boolean)state.getValue((Property)BlockStateProperties.WATERLOGGED) != false;
    }

    public static AABB getPixeledAABB(double x0, double y0, double z0, double x1, double y1, double z1) {
        return new AABB(x0 / 16.0, y0 / 16.0, z0 / 16.0, x1 / 16.0, y1 / 16.0, z1 / 16.0);
    }

    public static AABB getRotatedAABB(AABB bb, Direction new_facing) {
        return Auxiliaries.getRotatedAABB(bb, new_facing, false);
    }

    public static AABB[] getRotatedAABB(AABB[] bb, Direction new_facing) {
        return Auxiliaries.getRotatedAABB(bb, new_facing, false);
    }

    public static AABB getRotatedAABB(AABB bb, Direction new_facing, boolean horizontal_rotation) {
        if (!horizontal_rotation) {
            switch (new_facing.get3DDataValue()) {
                case 0: {
                    return new AABB(1.0 - bb.maxX, bb.minZ, bb.minY, 1.0 - bb.minX, bb.maxZ, bb.maxY);
                }
                case 1: {
                    return new AABB(1.0 - bb.maxX, 1.0 - bb.maxZ, 1.0 - bb.maxY, 1.0 - bb.minX, 1.0 - bb.minZ, 1.0 - bb.minY);
                }
                case 2: {
                    return new AABB(bb.minX, bb.minY, bb.minZ, bb.maxX, bb.maxY, bb.maxZ);
                }
                case 3: {
                    return new AABB(1.0 - bb.maxX, bb.minY, 1.0 - bb.maxZ, 1.0 - bb.minX, bb.maxY, 1.0 - bb.minZ);
                }
                case 4: {
                    return new AABB(bb.minZ, bb.minY, 1.0 - bb.maxX, bb.maxZ, bb.maxY, 1.0 - bb.minX);
                }
                case 5: {
                    return new AABB(1.0 - bb.maxZ, bb.minY, bb.minX, 1.0 - bb.minZ, bb.maxY, bb.maxX);
                }
            }
        } else {
            switch (new_facing.get3DDataValue()) {
                case 0: {
                    return new AABB(bb.minX, bb.minY, bb.minZ, bb.maxX, bb.maxY, bb.maxZ);
                }
                case 1: {
                    return new AABB(bb.minX, bb.minY, bb.minZ, bb.maxX, bb.maxY, bb.maxZ);
                }
                case 2: {
                    return new AABB(bb.minX, bb.minY, bb.minZ, bb.maxX, bb.maxY, bb.maxZ);
                }
                case 3: {
                    return new AABB(1.0 - bb.maxX, bb.minY, 1.0 - bb.maxZ, 1.0 - bb.minX, bb.maxY, 1.0 - bb.minZ);
                }
                case 4: {
                    return new AABB(bb.minZ, bb.minY, 1.0 - bb.maxX, bb.maxZ, bb.maxY, 1.0 - bb.minX);
                }
                case 5: {
                    return new AABB(1.0 - bb.maxZ, bb.minY, bb.minX, 1.0 - bb.minZ, bb.maxY, bb.maxX);
                }
            }
        }
        return bb;
    }

    public static AABB[] getRotatedAABB(AABB[] bbs, Direction new_facing, boolean horizontal_rotation) {
        AABB[] transformed = new AABB[bbs.length];
        for (int i = 0; i < bbs.length; ++i) {
            transformed[i] = Auxiliaries.getRotatedAABB(bbs[i], new_facing, horizontal_rotation);
        }
        return transformed;
    }

    public static AABB getYRotatedAABB(AABB bb, int clockwise_90deg_steps) {
        Direction[] direction_map = new Direction[]{Direction.NORTH, Direction.EAST, Direction.SOUTH, Direction.WEST};
        return Auxiliaries.getRotatedAABB(bb, direction_map[clockwise_90deg_steps + 4096 & 3], true);
    }

    public static AABB[] getYRotatedAABB(AABB[] bbs, int clockwise_90deg_steps) {
        AABB[] transformed = new AABB[bbs.length];
        for (int i = 0; i < bbs.length; ++i) {
            transformed[i] = Auxiliaries.getYRotatedAABB(bbs[i], clockwise_90deg_steps);
        }
        return transformed;
    }

    public static AABB getMirroredAABB(AABB bb, Direction.Axis axis) {
        return switch (axis) {
            default -> throw new MatchException(null, null);
            case Direction.Axis.X -> new AABB(1.0 - bb.maxX, bb.minY, bb.minZ, 1.0 - bb.minX, bb.maxY, bb.maxZ);
            case Direction.Axis.Y -> new AABB(bb.minX, 1.0 - bb.maxY, bb.minZ, bb.maxX, 1.0 - bb.minY, bb.maxZ);
            case Direction.Axis.Z -> new AABB(bb.minX, bb.minY, 1.0 - bb.maxZ, bb.maxX, bb.maxY, 1.0 - bb.minZ);
        };
    }

    public static AABB[] getMirroredAABB(AABB[] bbs, Direction.Axis axis) {
        AABB[] transformed = new AABB[bbs.length];
        for (int i = 0; i < bbs.length; ++i) {
            transformed[i] = Auxiliaries.getMirroredAABB(bbs[i], axis);
        }
        return transformed;
    }

    public static VoxelShape getUnionShape(AABB ... aabbs) {
        VoxelShape shape2 = Shapes.empty();
        for (AABB aabb : aabbs) {
            shape2 = Shapes.joinUnoptimized((VoxelShape)shape2, (VoxelShape)Shapes.create((AABB)aabb), (BooleanOp)BooleanOp.OR);
        }
        return shape2;
    }

    public static VoxelShape getUnionShape(AABB[] ... aabb_list) {
        VoxelShape shape2 = Shapes.empty();
        AABB[][] aABBArray = aabb_list;
        int n = aABBArray.length;
        for (int i = 0; i < n; ++i) {
            AABB[] aabbs;
            for (AABB aabb : aabbs = aABBArray[i]) {
                shape2 = Shapes.joinUnoptimized((VoxelShape)shape2, (VoxelShape)Shapes.create((AABB)aabb), (BooleanOp)BooleanOp.OR);
            }
        }
        return shape2;
    }

    public static AABB[] getMappedAABB(AABB[] bbs, Function<AABB, AABB> mapper) {
        AABB[] transformed = new AABB[bbs.length];
        for (int i = 0; i < bbs.length; ++i) {
            transformed[i] = mapper.apply(bbs[i]);
        }
        return transformed;
    }

    public static String loadResourceText(InputStream is) {
        try {
            if (is == null) {
                return "";
            }
            BufferedReader br = new BufferedReader(new InputStreamReader(is, StandardCharsets.UTF_8));
            return br.lines().collect(Collectors.joining("\n"));
        }
        catch (Throwable e) {
            return "";
        }
    }

    public static String loadResourceText(String path) {
        return Auxiliaries.loadResourceText(Auxiliaries.class.getResourceAsStream(path));
    }

    public static void logGitVersion() {
        try {
            String version = Auxiliaries.loadResourceText("/.gitversion-redstonepen").trim();
            Auxiliaries.logInfo("Redstone Pen" + (String)(version.isEmpty() ? " (dev build)" : " GIT id #" + version) + ".");
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    public static void particles(Level world, BlockPos pos, ParticleOptions type) {
        Auxiliaries.particles(world, Vec3.atCenterOf((Vec3i)pos).add(0.0, 0.4, 0.0), type, 1.0f);
    }

    public static void particles(Level world, Vec3 pos, ParticleOptions type, float velocity) {
        RandomSource rand = world.getRandom();
        if (!(world instanceof ServerLevel)) {
            return;
        }
        ServerLevel sl = (ServerLevel)world;
        sl.sendParticles(type, pos.x() + rand.nextGaussian() * 0.2, pos.y() + rand.nextGaussian() * 0.2, pos.z() + rand.nextGaussian() * 0.2, 1, rand.nextDouble() * 0.02, rand.nextDouble() * 0.02, rand.nextDouble() * 0.02, (double)velocity * 0.1);
    }

    public static Optional<FakePlayer> getFakePlayer(Level world) {
        if (world.isClientSide()) {
            return Optional.empty();
        }
        FakePlayer player = FakePlayerFactory.getMinecraft((ServerLevel)((ServerLevel)world));
        return player == null ? Optional.empty() : Optional.of(player);
    }

    public static final class BlockPosRange
    implements Iterable<BlockPos> {
        private final int x0;
        private final int x1;
        private final int y0;
        private final int y1;
        private final int z0;
        private final int z1;

        public BlockPosRange(int x0, int y0, int z0, int x1, int y1, int z1) {
            this.x0 = Math.min(x0, x1);
            this.x1 = Math.max(x0, x1);
            this.y0 = Math.min(y0, y1);
            this.y1 = Math.max(y0, y1);
            this.z0 = Math.min(z0, z1);
            this.z1 = Math.max(z0, z1);
        }

        public static BlockPosRange of(AABB range) {
            return new BlockPosRange((int)Math.floor(range.minX), (int)Math.floor(range.minY), (int)Math.floor(range.minZ), (int)Math.floor(range.maxX - 0.0625), (int)Math.floor(range.maxY - 0.0625), (int)Math.floor(range.maxZ - 0.0625));
        }

        public int getXSize() {
            return this.x1 - this.x0 + 1;
        }

        public int getYSize() {
            return this.y1 - this.y0 + 1;
        }

        public int getZSize() {
            return this.z1 - this.z0 + 1;
        }

        public int getArea() {
            return this.getXSize() * this.getZSize();
        }

        public int getHeight() {
            return this.getYSize();
        }

        public int getVolume() {
            return this.getXSize() * this.getYSize() * this.getZSize();
        }

        public BlockPos byXZYIndex(int xyz_index) {
            int xsz = this.getXSize();
            int ysz = this.getYSize();
            int zsz = this.getZSize();
            int y = (xyz_index %= xsz * ysz * zsz) / (xsz * zsz);
            int z = (xyz_index -= y * (xsz * zsz)) / xsz;
            int x = xyz_index -= z * xsz;
            return new BlockPos(this.x0 + x, this.y0 + y, this.z0 + z);
        }

        public BlockPos byXZIndex(int xz_index, int y_offset) {
            int xsz = this.getXSize();
            int zsz = this.getZSize();
            int z = (xz_index %= xsz * zsz) / xsz;
            int x = xz_index -= z * xsz;
            return new BlockPos(this.x0 + x, this.y0 + y_offset, this.z0 + z);
        }

        public BlockRangeIterator iterator() {
            return new BlockRangeIterator(this);
        }

        public Stream<BlockPos> stream() {
            return StreamSupport.stream(this.spliterator(), false);
        }

        public static final class BlockRangeIterator
        implements Iterator<BlockPos> {
            private final BlockPosRange range_;
            private int x;
            private int y;
            private int z;

            public BlockRangeIterator(BlockPosRange range) {
                this.range_ = range;
                this.x = range.x0;
                this.y = range.y0;
                this.z = range.z0;
            }

            @Override
            public boolean hasNext() {
                return this.z <= this.range_.z1;
            }

            @Override
            public BlockPos next() {
                if (!this.hasNext()) {
                    throw new NoSuchElementException();
                }
                BlockPos pos = new BlockPos(this.x, this.y, this.z);
                ++this.x;
                if (this.x > this.range_.x1) {
                    this.x = this.range_.x0;
                    ++this.y;
                    if (this.y > this.range_.y1) {
                        this.y = this.range_.y0;
                        ++this.z;
                    }
                }
                return pos;
            }
        }
    }

    public static final class Tooltip {
        @OnlyIn(value=Dist.CLIENT)
        public static boolean extendedTipCondition() {
            return Auxiliaries.isShiftDown() && !Auxiliaries.isCtrlDown();
        }

        @OnlyIn(value=Dist.CLIENT)
        public static boolean helpCondition() {
            return Auxiliaries.isShiftDown() && Auxiliaries.isCtrlDown();
        }

        @OnlyIn(value=Dist.CLIENT)
        public static boolean addInformation(@Nullable String advancedTooltipTranslationKey, @Nullable String helpTranslationKey, List<Component> tooltip, TooltipFlag flag, boolean addAdvancedTooltipHints) {
            boolean tip_available;
            boolean help_available = helpTranslationKey != null && Auxiliaries.hasTranslation(helpTranslationKey + ".help");
            boolean bl = tip_available = advancedTooltipTranslationKey != null && Auxiliaries.hasTranslation(helpTranslationKey + ".tip");
            if (!help_available && !tip_available) {
                return false;
            }
            MutableComponent tip_text = Component.empty();
            if (Tooltip.helpCondition()) {
                if (help_available) {
                    tip_text = Component.literal((String)Auxiliaries.localize(helpTranslationKey + ".help", new Object[0]));
                }
            } else if (Tooltip.extendedTipCondition()) {
                if (tip_available) {
                    tip_text = Component.literal((String)Auxiliaries.localize(advancedTooltipTranslationKey + ".tip", new Object[0]));
                }
            } else if (addAdvancedTooltipHints) {
                if (tip_available) {
                    tip_text = Component.literal((String)(Auxiliaries.localize(Auxiliaries.modid() + ".tooltip.hint.extended", new Object[0]) + (help_available ? " " : "")));
                }
                if (help_available) {
                    tip_text.append((Component)Component.literal((String)Auxiliaries.localize(Auxiliaries.modid() + ".tooltip.hint.help", new Object[0])));
                }
            }
            if (Auxiliaries.isEmpty((Component)tip_text)) {
                return false;
            }
            tooltip.addAll(Auxiliaries.wrapText((Component)tip_text, 50));
            return true;
        }

        @OnlyIn(value=Dist.CLIENT)
        public static boolean addInformation(ItemStack stack, Item.TooltipContext ctx, List<Component> tooltip, TooltipFlag flag, boolean addAdvancedTooltipHints) {
            return Tooltip.addInformation(stack.getDescriptionId(), stack.getDescriptionId(), tooltip, flag, addAdvancedTooltipHints);
        }
    }

    public static interface IExperimentalFeature {
    }
}

