/*
 * Decompiled with CFR 0.152.
 */
package wile.redstonepen.blocks;

import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.Nullable;
import wile.redstonepen.libmc.StandardBlocks;

public class BasicGauge {

    public static class BasicGaugeBlock
    extends StandardBlocks.Cutout {
        public static final IntegerProperty POWER = BlockStateProperties.POWER;

        public BasicGaugeBlock(long config, BlockBehaviour.Properties properties) {
            super(config, properties.isRedstoneConductor((w, p, s) -> false));
            this.registerDefaultState((BlockState)this.defaultBlockState().setValue((Property)POWER, (Comparable)Integer.valueOf(0)));
        }

        protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
            super.createBlockStateDefinition(builder);
            builder.add(new Property[]{POWER});
        }

        @Override
        public VoxelShape getShape(BlockState state, BlockGetter source, BlockPos pos, CollisionContext selectionContext) {
            return Shapes.block();
        }

        @Override
        public VoxelShape getCollisionShape(BlockState state, BlockGetter world, BlockPos pos, CollisionContext selectionContext) {
            return Shapes.block();
        }

        @Override
        @Nullable
        public BlockState getStateForPlacement(BlockPlaceContext context) {
            BlockState state = super.getStateForPlacement(context);
            if (state == null) {
                return null;
            }
            return (BlockState)state.setValue((Property)POWER, (Comparable)Integer.valueOf(context.getLevel().getBestNeighborSignal(context.getClickedPos())));
        }

        protected void neighborChanged(BlockState state, Level world, BlockPos pos, Block block, BlockPos fromPos, boolean isMoving) {
            if (world.isClientSide) {
                return;
            }
            int p = world.getBestNeighborSignal(pos);
            if (p == (Integer)state.getValue((Property)POWER)) {
                return;
            }
            world.setBlock(pos, (BlockState)state.setValue((Property)POWER, (Comparable)Integer.valueOf(p)), 2);
        }

        @Override
        public BlockState updateShape(BlockState state, Direction dir, BlockState fromState, LevelAccessor world_accessor, BlockPos pos, BlockPos fromPos) {
            if (!(world_accessor instanceof ServerLevel)) {
                return state;
            }
            ServerLevel world = (ServerLevel)world_accessor;
            return (BlockState)state.setValue((Property)POWER, (Comparable)Integer.valueOf(world.getBestNeighborSignal(pos)));
        }

        public boolean canConnectRedstone(BlockState state, BlockGetter world, BlockPos pos, @Nullable Direction side) {
            return true;
        }

        @Override
        public boolean shouldCheckWeakPower(BlockState state, LevelReader world, BlockPos pos, Direction side) {
            return false;
        }
    }
}

