/*
 * Decompiled with CFR 0.152.
 */
package cy.jdkdigital.utilitarian.module;

import com.mojang.serialization.Codec;
import cy.jdkdigital.utilitarian.Utilitarian;
import cy.jdkdigital.utilitarian.common.block.NoRaiderBlock;
import cy.jdkdigital.utilitarian.common.block.NoSolicitingBanner;
import cy.jdkdigital.utilitarian.common.block.NoSolicitingWallBanner;
import cy.jdkdigital.utilitarian.common.block.SolicitingCarpet;
import cy.jdkdigital.utilitarian.common.block.entity.NoSolicitingBannerBlockEntity;
import cy.jdkdigital.utilitarian.common.item.RestrainingOrder;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.function.Supplier;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.ai.village.poi.PoiType;
import net.minecraft.world.item.BannerItem;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.levelgen.structure.Structure;
import net.neoforged.neoforge.registries.DeferredHolder;

public class NoSolicitingModule {
    public static DeferredHolder<Block, Block> NO_SOLICITING_BANNER;
    public static DeferredHolder<Block, Block> NO_SOLICITING_WALL_BANNER;
    public static DeferredHolder<Block, Block> NO_RAIDER_BLOCK;
    public static Map<DyeColor, DeferredHolder<Block, Block>> SOLICITING_CARPET;
    public static Map<DyeColor, DeferredHolder<Block, Block>> TRAPPED_SOLICITING_CARPET;
    public static DeferredHolder<BlockEntityType<?>, BlockEntityType<NoSolicitingBannerBlockEntity>> NO_SOLICITING_BANNER_BLOCK_ENTITY;
    public static DeferredHolder<Item, Item> NO_SOLICITING_BANNER_ITEM;
    public static DeferredHolder<Item, Item> NO_RAIDER_BLOCK_ITEM;
    public static Map<DyeColor, DeferredHolder<Item, Item>> SOLICITING_CARPET_ITEM;
    public static Map<DyeColor, DeferredHolder<Item, Item>> TRAPPED_SOLICITING_CARPET_ITEM;
    public static DeferredHolder<Item, Item> RESTRAINING_ORDER;
    public static DeferredHolder<PoiType, PoiType> NO_SOLICITING_POI;
    public static DeferredHolder<PoiType, PoiType> SOLICITING_POI;
    public static DeferredHolder<PoiType, PoiType> NO_RAIDER_POI;
    public static TagKey<EntityType<?>> TRADER_BLACKLIST;
    public static TagKey<PoiType> NO_SOLICITING_POI_TAG;
    public static TagKey<PoiType> SOLICITING_POI_TAG;
    public static TagKey<Block> TRAPPED_SOLICITING_CARPETS;
    public static TagKey<EntityType<?>> RAIDER_BLACKLIST;
    public static TagKey<Structure> RAIDER_OUTPOSTS;
    public static final Supplier<DataComponentType<Boolean>> ACTIVE;

    public static void register() {
        NO_SOLICITING_BANNER = Utilitarian.BLOCKS.register("no_soliciting_banner", () -> new NoSolicitingBanner(DyeColor.WHITE, BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.WHITE_BANNER)));
        NO_SOLICITING_WALL_BANNER = Utilitarian.BLOCKS.register("no_soliciting_wall_banner", () -> new NoSolicitingWallBanner(DyeColor.WHITE, BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.WHITE_WALL_BANNER)));
        NO_SOLICITING_BANNER_BLOCK_ENTITY = Utilitarian.BLOCK_ENTITY.register("no_soliciting_banner", () -> BlockEntityType.Builder.of(NoSolicitingBannerBlockEntity::new, (Block[])new Block[]{(Block)NO_SOLICITING_BANNER.get(), (Block)NO_SOLICITING_WALL_BANNER.get()}).build(null));
        NO_SOLICITING_BANNER_ITEM = Utilitarian.ITEMS.register("no_soliciting_banner", () -> new BannerItem((Block)NO_SOLICITING_BANNER.get(), (Block)NO_SOLICITING_WALL_BANNER.get(), new Item.Properties()));
        NO_RAIDER_BLOCK = Utilitarian.BLOCKS.register("no_raider_block", () -> new NoRaiderBlock(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.WHITE_WOOL)));
        NO_RAIDER_BLOCK_ITEM = Utilitarian.ITEMS.register("no_raider_block", () -> new BlockItem((Block)NO_RAIDER_BLOCK.get(), new Item.Properties()));
        for (DyeColor color : DyeColor.values()) {
            SOLICITING_CARPET.put(color, (DeferredHolder<Block, Block>)Utilitarian.BLOCKS.register(color.getSerializedName() + "_soliciting_carpet", () -> new SolicitingCarpet(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.WHITE_CARPET))));
            TRAPPED_SOLICITING_CARPET.put(color, (DeferredHolder<Block, Block>)Utilitarian.BLOCKS.register(color.getSerializedName() + "_trapped_soliciting_carpet", () -> new SolicitingCarpet(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.WHITE_CARPET))));
            SOLICITING_CARPET_ITEM.put(color, (DeferredHolder<Item, Item>)Utilitarian.ITEMS.register(color.getSerializedName() + "_soliciting_carpet", () -> new BlockItem((Block)SOLICITING_CARPET.get(color).get(), new Item.Properties())));
            TRAPPED_SOLICITING_CARPET_ITEM.put(color, (DeferredHolder<Item, Item>)Utilitarian.ITEMS.register(color.getSerializedName() + "_trapped_soliciting_carpet", () -> new BlockItem((Block)TRAPPED_SOLICITING_CARPET.get(color).get(), new Item.Properties())));
        }
        RESTRAINING_ORDER = Utilitarian.ITEMS.register("restraining_order", () -> new RestrainingOrder(new Item.Properties().stacksTo(1)));
        NO_SOLICITING_POI = Utilitarian.POI_TYPES.register("no_soliciting", () -> {
            HashSet blockStates = new HashSet();
            blockStates.addAll(((Block)NO_SOLICITING_BANNER.get()).getStateDefinition().getPossibleStates());
            blockStates.addAll(((Block)NO_SOLICITING_WALL_BANNER.get()).getStateDefinition().getPossibleStates());
            return new PoiType(blockStates, 1, 1);
        });
        SOLICITING_POI = Utilitarian.POI_TYPES.register("soliciting", () -> {
            HashSet blockStates = new HashSet();
            for (DyeColor color : DyeColor.values()) {
                blockStates.addAll(((Block)SOLICITING_CARPET.get(color).get()).getStateDefinition().getPossibleStates());
                blockStates.addAll(((Block)TRAPPED_SOLICITING_CARPET.get(color).get()).getStateDefinition().getPossibleStates());
            }
            return new PoiType(blockStates, 1, 1);
        });
        NO_RAIDER_POI = Utilitarian.POI_TYPES.register("no_raider", () -> new PoiType(new HashSet(((Block)NO_RAIDER_BLOCK.get()).getStateDefinition().getPossibleStates()), 1, 1));
    }

    static {
        SOLICITING_CARPET = new HashMap<DyeColor, DeferredHolder<Block, Block>>();
        TRAPPED_SOLICITING_CARPET = new HashMap<DyeColor, DeferredHolder<Block, Block>>();
        SOLICITING_CARPET_ITEM = new HashMap<DyeColor, DeferredHolder<Item, Item>>();
        TRAPPED_SOLICITING_CARPET_ITEM = new HashMap<DyeColor, DeferredHolder<Item, Item>>();
        TRADER_BLACKLIST = TagKey.create((ResourceKey)Registries.ENTITY_TYPE, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"utilitarian", (String)"traders"));
        NO_SOLICITING_POI_TAG = TagKey.create((ResourceKey)Registries.POINT_OF_INTEREST_TYPE, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"utilitarian", (String)"no_soliciting"));
        SOLICITING_POI_TAG = TagKey.create((ResourceKey)Registries.POINT_OF_INTEREST_TYPE, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"utilitarian", (String)"soliciting"));
        TRAPPED_SOLICITING_CARPETS = TagKey.create((ResourceKey)Registries.BLOCK, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"utilitarian", (String)"trapped_soliciting_carpets"));
        RAIDER_BLACKLIST = TagKey.create((ResourceKey)Registries.ENTITY_TYPE, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"utilitarian", (String)"raiders"));
        RAIDER_OUTPOSTS = TagKey.create((ResourceKey)Registries.STRUCTURE, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"utilitarian", (String)"outposts"));
        ACTIVE = Utilitarian.DATA_COMPONENT_TYPES.register("active", () -> DataComponentType.builder().persistent((Codec)Codec.BOOL).networkSynchronized(ByteBufCodecs.BOOL).build());
    }
}

