/*
 * Decompiled with CFR 0.152.
 */
package cy.jdkdigital.utilitarian.common.block;

import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.RandomSource;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.RedstoneLampBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;

public class LapisLampBlock
extends RedstoneLampBlock {
    boolean isInverted = false;

    public LapisLampBlock(BlockBehaviour.Properties properties, boolean isInverted) {
        super(properties);
        this.isInverted = isInverted;
    }

    public void animateTick(BlockState state, Level level, BlockPos pos, RandomSource random) {
        super.animateTick(state, level, pos, random);
        if (this.isLit(state)) {
            level.getLightEngine().checkBlock(pos);
        }
    }

    public int getLightEmission(BlockState state, BlockGetter level, BlockPos pos) {
        if (!(level instanceof ServerLevel)) {
            return this.isLit(state) ? 15 : 0;
        }
        return 0;
    }

    public void appendHoverText(ItemStack stack, Item.TooltipContext context, List<Component> tooltipComponents, TooltipFlag tooltipFlag) {
        super.appendHoverText(stack, context, tooltipComponents, tooltipFlag);
        tooltipComponents.add((Component)Component.translatable((String)"block.utilitarian.lapis_lamp.tooltip").withStyle(ChatFormatting.ITALIC).withStyle(ChatFormatting.LIGHT_PURPLE));
        tooltipComponents.add((Component)Component.translatable((String)"block.utilitarian.lapis_lamp.tooltip2").withStyle(ChatFormatting.GREEN));
    }

    private boolean isLit(BlockState state) {
        return (Boolean)state.getValue((Property)BlockStateProperties.LIT) != false && !this.isInverted || (Boolean)state.getValue((Property)BlockStateProperties.LIT) == false && this.isInverted;
    }
}

