/*
 * Decompiled with CFR 0.152.
 */
package me.ramidzkh.mekae2.ae2;

import appeng.api.stacks.AEKey;
import appeng.api.stacks.AEKeyType;
import appeng.core.AELog;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.List;
import java.util.Objects;
import me.ramidzkh.mekae2.ae2.MekanismKeyType;
import mekanism.api.MekanismAPI;
import mekanism.api.chemical.Chemical;
import mekanism.api.chemical.ChemicalStack;
import mekanism.api.radiation.IRadiationManager;
import net.minecraft.core.BlockPos;
import net.minecraft.core.GlobalPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtOps;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.RegistryOps;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.Nullable;

public class MekanismKey
extends AEKey {
    public static final MapCodec<MekanismKey> MAP_CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)Codec.withAlternative((Codec)Chemical.CODEC, (Codec)new Codec<Chemical>(){

        public <T> DataResult<Pair<Chemical, T>> decode(DynamicOps<T> ops, T input) {
            return ops.getMap(input).flatMap(map -> ops.getStringValue(map.get("chemical_type")).flatMap(type -> MekanismAPI.CHEMICAL_REGISTRY.byNameCodec().decode(ops, map.get(type))));
        }

        public <T> DataResult<T> encode(Chemical input, DynamicOps<T> ops, T prefix) {
            return DataResult.error(() -> "should not encode");
        }
    }).fieldOf("id").forGetter(key -> key.getStack().getChemical())).apply((Applicative)instance, chemical -> MekanismKey.of(chemical.getStack(1L))));
    public static final Codec<MekanismKey> CODEC = MAP_CODEC.codec();
    private final ChemicalStack stack;

    private MekanismKey(ChemicalStack stack) {
        this.stack = stack;
    }

    @Nullable
    public static MekanismKey of(ChemicalStack stack) {
        if (stack.isEmpty()) {
            return null;
        }
        return new MekanismKey(stack.copy());
    }

    public ChemicalStack getStack() {
        return this.stack;
    }

    public ChemicalStack withAmount(long amount) {
        return this.stack.copyWithAmount(amount);
    }

    public AEKeyType getType() {
        return MekanismKeyType.TYPE;
    }

    public AEKey dropSecondary() {
        return this;
    }

    @Nullable
    public static MekanismKey fromTag(HolderLookup.Provider registries, CompoundTag tag) {
        RegistryOps ops = registries.createSerializationContext((DynamicOps)NbtOps.INSTANCE);
        try {
            return (MekanismKey)((Object)((Pair)CODEC.decode((DynamicOps)ops, (Object)tag).getOrThrow()).getFirst());
        }
        catch (Exception e) {
            AELog.debug((String)"Tried to load an invalid chemical key from NBT: %s", (Object[])new Object[]{tag, e});
            return null;
        }
    }

    public CompoundTag toTag(HolderLookup.Provider registries) {
        RegistryOps ops = registries.createSerializationContext((DynamicOps)NbtOps.INSTANCE);
        return (CompoundTag)CODEC.encodeStart((DynamicOps)ops, (Object)this).getOrThrow();
    }

    public Object getPrimaryKey() {
        return this.stack.getChemical();
    }

    public ResourceLocation getId() {
        return this.stack.getTypeRegistryName();
    }

    public void addDrops(long amount, List<ItemStack> drops, Level level, BlockPos pos) {
        IRadiationManager.INSTANCE.dumpRadiation(GlobalPos.of((ResourceKey)level.dimension(), (BlockPos)pos), this.withAmount(amount));
    }

    protected Component computeDisplayName() {
        return this.stack.getChemical().getTextComponent();
    }

    public boolean isTagged(TagKey<?> tag) {
        return this.stack.is(tag);
    }

    @Nullable
    public <T> T get(DataComponentType<T> type) {
        return null;
    }

    public boolean hasComponents() {
        return false;
    }

    public void writeToPacket(RegistryFriendlyByteBuf data) {
        ChemicalStack.STREAM_CODEC.encode((Object)data, (Object)this.stack);
    }

    public static MekanismKey fromPacket(RegistryFriendlyByteBuf data) {
        return new MekanismKey((ChemicalStack)ChemicalStack.STREAM_CODEC.decode((Object)data));
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        MekanismKey that = (MekanismKey)((Object)o);
        return Objects.equals(this.stack.getChemical(), that.stack.getChemical());
    }

    public int hashCode() {
        return Objects.hash(this.stack.getChemical());
    }

    public String toString() {
        return "MekanismKey{stack=" + String.valueOf(this.stack.getChemical()) + "}";
    }
}

