/*
 * Decompiled with CFR 0.152.
 */
package de.srendi.advancedperipherals.common.util.inventory;

import dan200.computercraft.api.lua.LuaException;
import dan200.computercraft.api.peripheral.IComputerAccess;
import dan200.computercraft.api.peripheral.IPeripheral;
import de.srendi.advancedperipherals.common.addons.computercraft.owner.IPeripheralOwner;
import de.srendi.advancedperipherals.common.util.CoordUtil;
import de.srendi.advancedperipherals.common.util.FingerprintUtil;
import de.srendi.advancedperipherals.common.util.inventory.ChemicalFilter;
import de.srendi.advancedperipherals.common.util.inventory.IStorageSystemChemicalHandler;
import java.util.Objects;
import mekanism.api.Action;
import mekanism.api.MekanismAPI;
import mekanism.api.chemical.Chemical;
import mekanism.api.chemical.ChemicalStack;
import mekanism.api.chemical.IChemicalHandler;
import mekanism.common.capabilities.Capabilities;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ChemicalUtil {
    public static long moveChemical(IChemicalHandler inventoryFrom, IChemicalHandler inventoryTo, ChemicalFilter filter) {
        if (inventoryFrom == null) {
            return 0L;
        }
        long amount = filter.getCount();
        long transferableAmount = 0L;
        if (inventoryFrom instanceof IStorageSystemChemicalHandler) {
            IStorageSystemChemicalHandler storageSystemHandler = (IStorageSystemChemicalHandler)inventoryFrom;
            ChemicalStack extracted = storageSystemHandler.extractChemical(filter, amount, Action.SIMULATE);
            if ((amount = Math.min(amount, extracted.getAmount())) > 0L) {
                int toSlot = filter.getToSlot();
                ChemicalStack remaining = toSlot >= 0 ? inventoryTo.insertChemical(toSlot, extracted, Action.EXECUTE) : inventoryTo.insertChemical(extracted, Action.EXECUTE);
                amount -= remaining.getAmount();
            }
            if (amount > 0L) {
                transferableAmount += storageSystemHandler.extractChemical(filter, amount, Action.EXECUTE).getAmount();
            }
            return transferableAmount;
        }
        if (inventoryTo instanceof IStorageSystemChemicalHandler) {
            IStorageSystemChemicalHandler storageSystemHandler = (IStorageSystemChemicalHandler)inventoryTo;
            int fromSlot = filter.getFromSlot();
            if (fromSlot >= 0) {
                transferableAmount = ChemicalUtil.importChemical(inventoryFrom, filter, storageSystemHandler, amount, fromSlot);
            } else {
                long imported;
                int tanks = inventoryFrom.getChemicalTanks();
                for (int i = 0; amount > 0L && i < tanks; amount -= imported, ++i) {
                    imported = ChemicalUtil.importChemical(inventoryFrom, filter, storageSystemHandler, amount, i);
                    transferableAmount += imported;
                }
            }
            return transferableAmount;
        }
        return transferableAmount;
    }

    private static long importChemical(IChemicalHandler inventoryFrom, ChemicalFilter filter, IStorageSystemChemicalHandler storageSystemHandler, long amount, int tank) {
        ChemicalStack extracted;
        long transferableAmount = 0L;
        ChemicalStack chemicalInTank = inventoryFrom.getChemicalInTank(tank);
        if (filter.test(chemicalInTank) && !(extracted = inventoryFrom.extractChemical(tank, amount, Action.SIMULATE)).isEmpty()) {
            long remaining = storageSystemHandler.insertChemical(extracted, Action.EXECUTE).getAmount();
            long extracting = extracted.getAmount() - remaining;
            if (extracting > 0L) {
                transferableAmount += inventoryFrom.extractChemical(tank, extracting, Action.EXECUTE).getAmount();
            }
        }
        return transferableAmount;
    }

    public static IChemicalHandler extractHandler(@Nullable Object object, @Nullable Level level, @Nullable BlockPos pos, @Nullable Direction direction) {
        if (object instanceof IChemicalHandler) {
            IChemicalHandler itemHandler = (IChemicalHandler)object;
            return itemHandler;
        }
        if (object instanceof BlockEntity) {
            BlockEntity blockEntity = (BlockEntity)object;
            if (level == null && pos == null) {
                pos = blockEntity.getBlockPos();
                level = blockEntity.getLevel();
            }
        }
        if (level != null && pos != null) {
            return (IChemicalHandler)level.getCapability(Capabilities.CHEMICAL.block(), pos, (Object)(direction != null ? direction : Direction.NORTH));
        }
        return null;
    }

    @Nullable
    public static IChemicalHandler getHandlerFromDirection(@NotNull String direction, @NotNull IPeripheralOwner owner) throws LuaException {
        Level level = owner.getLevel();
        Objects.requireNonNull(level);
        Direction relativeDirection = CoordUtil.getDirection(owner.getOrientation(), direction);
        if (relativeDirection == null) {
            return null;
        }
        BlockEntity target = level.getBlockEntity(owner.getPos().relative(relativeDirection));
        if (target == null) {
            return null;
        }
        return ChemicalUtil.extractHandler(target, level, owner.getPos().relative(relativeDirection), relativeDirection);
    }

    @Nullable
    public static IChemicalHandler getHandlerFromName(@NotNull IComputerAccess access, String name) throws LuaException {
        IPeripheral location = access.getAvailablePeripheral(name);
        if (location == null) {
            return null;
        }
        IChemicalHandler handler = ChemicalUtil.extractHandler(location.getTarget(), null, null, null);
        if (handler == null) {
            throw new LuaException("Target '" + name + "' is not a chemical handler");
        }
        return handler;
    }

    public static ChemicalStack toChemicalStack(Chemical chemical, long amount) {
        return new ChemicalStack(MekanismAPI.CHEMICAL_REGISTRY.wrapAsHolder((Object)chemical), amount);
    }

    public static String getFingerprint(@NotNull ChemicalStack stack) {
        FingerprintUtil.FingerprintKey fingerprintKey = new FingerprintUtil.FingerprintKey(ChemicalUtil.getRegistryKey(stack), null, null);
        return FingerprintUtil.hash(fingerprintKey);
    }

    public static ResourceLocation getRegistryKey(Chemical chemical) {
        return MekanismAPI.CHEMICAL_REGISTRY.getKey((Object)chemical);
    }

    public static ResourceLocation getRegistryKey(ChemicalStack chemicalStack) {
        return MekanismAPI.CHEMICAL_REGISTRY.getKey((Object)chemicalStack.getChemical());
    }
}

