/*
 * Decompiled with CFR 0.152.
 */
package de.srendi.advancedperipherals.common.util;

import com.mojang.brigadier.exceptions.CommandSyntaxException;
import de.srendi.advancedperipherals.AdvancedPeripherals;
import de.srendi.advancedperipherals.common.configuration.APConfig;
import java.util.Map;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.ByteTag;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.DoubleTag;
import net.minecraft.nbt.IntTag;
import net.minecraft.nbt.StringTag;
import net.minecraft.nbt.Tag;
import net.minecraft.nbt.TagParser;
import net.minecraft.world.level.ChunkPos;
import org.apache.logging.log4j.Level;

public class NBTUtil {
    public static Tag toDirectNBT(Object object) {
        if (object == null) {
            return null;
        }
        if (object instanceof Boolean) {
            Boolean bool = (Boolean)object;
            return ByteTag.valueOf((byte)((byte)(bool != false ? 1 : 0)));
        }
        if (object instanceof Integer) {
            Integer integer = (Integer)object;
            return IntTag.valueOf((int)integer);
        }
        if (object instanceof Number) {
            Number number = (Number)object;
            return DoubleTag.valueOf((double)number.doubleValue());
        }
        if (object instanceof String) {
            return StringTag.valueOf((String)object.toString());
        }
        if (object instanceof Map) {
            Map map = (Map)object;
            CompoundTag nbt = new CompoundTag();
            for (Map.Entry item : map.entrySet()) {
                Tag value = NBTUtil.toDirectNBT(item.getValue());
                if (item.getKey() == null || value == null) continue;
                nbt.put(item.getKey().toString(), value);
            }
            return nbt;
        }
        return null;
    }

    public static CompoundTag fromText(String json) {
        try {
            return json == null ? null : TagParser.parseTag((String)json);
        }
        catch (CommandSyntaxException ex) {
            AdvancedPeripherals.debug("Could not parse json data to NBT", Level.ERROR);
            if (((Boolean)APConfig.GENERAL_CONFIG.enableDebugMode.get()).booleanValue()) {
                ex.printStackTrace();
            }
            return null;
        }
    }

    public static CompoundTag toNBT(BlockPos pos) {
        CompoundTag data = new CompoundTag();
        data.putInt("x", pos.getX());
        data.putInt("y", pos.getY());
        data.putInt("z", pos.getZ());
        return data;
    }

    public static BlockPos blockPosFromNBT(CompoundTag nbt) {
        return new BlockPos(nbt.getInt("x"), nbt.getInt("y"), nbt.getInt("z"));
    }

    public static CompoundTag toNBT(ChunkPos pos) {
        CompoundTag data = new CompoundTag();
        data.putInt("x", pos.x);
        data.putInt("z", pos.z);
        return data;
    }

    public static ChunkPos chunkPosFromNBT(CompoundTag nbt) {
        return new ChunkPos(nbt.getInt("x"), nbt.getInt("z"));
    }
}

