/*
 * Decompiled with CFR 0.152.
 */
package de.srendi.advancedperipherals.common.util;

import dan200.computercraft.api.pocket.IPocketAccess;
import dan200.computercraft.api.turtle.ITurtleAccess;
import dan200.computercraft.api.turtle.TurtleSide;
import de.srendi.advancedperipherals.common.addons.computercraft.owner.IPeripheralOwner;
import de.srendi.advancedperipherals.common.setup.DataComponents;
import de.srendi.advancedperipherals.lib.peripherals.IPeripheralTileEntity;
import java.util.Optional;
import net.minecraft.core.component.DataComponentMap;
import net.minecraft.core.component.DataComponentPatch;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.core.component.PatchedDataComponentMap;
import net.minecraft.nbt.CompoundTag;
import org.jetbrains.annotations.NotNull;

public class DataStorageUtil {
    public static DataComponentPatch getDataStorage(@NotNull ITurtleAccess access, @NotNull TurtleSide side) {
        return access.getUpgradeData(side);
    }

    public static void putDataStorage(@NotNull ITurtleAccess access, @NotNull TurtleSide side, DataComponentPatch dataComponent) {
        access.setUpgradeData(side, dataComponent);
    }

    public static CompoundTag getDataStorage(@NotNull IPeripheralTileEntity tileEntity) {
        return tileEntity.getPeripheralSettings();
    }

    public static DataComponentPatch getDataStorage(@NotNull IPocketAccess pocket) {
        return pocket.getUpgradeData();
    }

    public static void putDataStorage(@NotNull IPocketAccess pocket, DataComponentPatch dataComponent) {
        pocket.setUpgradeData(dataComponent);
    }

    public static class RotationCharge {
        public static final int ROTATION_STEPS = 36;

        public static int get(@NotNull ITurtleAccess access, @NotNull TurtleSide side) {
            Optional rotationCharge = DataStorageUtil.getDataStorage(access, side).get((DataComponentType)DataComponents.ROTATION_CHARGE_SETTING.get());
            return rotationCharge != null && rotationCharge.isPresent() ? (Integer)rotationCharge.get() : 0;
        }

        public static boolean consume(@NotNull ITurtleAccess access, @NotNull TurtleSide side) {
            PatchedDataComponentMap patch = PatchedDataComponentMap.fromPatch((DataComponentMap)DataComponentMap.EMPTY, (DataComponentPatch)DataStorageUtil.getDataStorage(access, side));
            int currentCharge = RotationCharge.get(access, side);
            if (currentCharge > 0) {
                patch.set((DataComponentType)DataComponents.ROTATION_CHARGE_SETTING.get(), (Object)Math.max(0, RotationCharge.get(access, side) - 1));
                DataStorageUtil.putDataStorage(access, side, patch.asPatch());
                return true;
            }
            return false;
        }

        public static void addCycles(IPeripheralOwner owner, int count) {
            PatchedDataComponentMap patch = PatchedDataComponentMap.fromPatch((DataComponentMap)DataComponentMap.EMPTY, (DataComponentPatch)owner.getDataStorage());
            Integer currentCharge = (Integer)patch.get((DataComponentType)DataComponents.ROTATION_CHARGE_SETTING.get());
            if (currentCharge == null || currentCharge < 0) {
                currentCharge = 0;
            }
            patch.set((DataComponentType)DataComponents.ROTATION_CHARGE_SETTING.get(), (Object)(currentCharge + count * 36));
            owner.putDataStorage(patch.asPatch());
        }
    }
}

