/*
 * Decompiled with CFR 0.152.
 */
package de.srendi.advancedperipherals.common.setup;

import com.mojang.serialization.Codec;
import de.srendi.advancedperipherals.common.setup.Registration;
import java.util.UUID;
import java.util.function.UnaryOperator;
import net.minecraft.core.Registry;
import net.minecraft.core.UUIDUtil;
import net.minecraft.core.component.DataComponentPatch;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.ComponentSerialization;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.resources.ResourceKey;
import net.minecraft.util.ExtraCodecs;
import net.neoforged.neoforge.registries.DeferredHolder;

public class DataComponents {
    public static final DeferredHolder<DataComponentType<?>, DataComponentType<DataComponentPatch>> TURTLE_UPGRADE_STORED_DATA = DataComponents.registerDataComponent("stored_data");
    public static final DeferredHolder<DataComponentType<?>, DataComponentType<DataComponentPatch>> ABILITY_COOLDOWN = DataComponents.registerDataComponent("cooldowns");
    public static final DeferredHolder<DataComponentType<?>, DataComponentType<UUID>> OWNER = DataComponents.registerUUID("owner_id");
    public static final DeferredHolder<DataComponentType<?>, DataComponentType<UUID>> CHUNKY_ID = DataComponents.registerUUID("chunky_id");
    public static final DeferredHolder<DataComponentType<?>, DataComponentType<Integer>> ROTATION_CHARGE_SETTING = DataComponents.registerInt("rotation_charge_setting");
    public static final DeferredHolder<DataComponentType<?>, DataComponentType<Integer>> FUEL_CONSUMPTION_RATE = DataComponents.registerInt("fuel_consumption_rate");
    public static final DeferredHolder<DataComponentType<?>, DataComponentType<CompoundTag>> ENTITY_TRANSFER = DataComponents.registerNBT("entity_transfer");
    public static final DeferredHolder<DataComponentType<?>, DataComponentType<String>> WORLD_DATA_MARK = DataComponents.registerString("world_data_mark");
    public static final DeferredHolder<DataComponentType<?>, DataComponentType<CompoundTag>> POINT_DATA_MARK = DataComponents.registerNBT("point_data_mark");
    public static final DeferredHolder<DataComponentType<?>, DataComponentType<CompoundTag>> CONSUMED_ENTITY_COMPOUND = DataComponents.registerNBT("consumed_entity_compound");
    public static final DeferredHolder<DataComponentType<?>, DataComponentType<Long>> SIMPLE_FREE_OPERATION = DataComponents.registerLong("free_operation_cooldown");
    public static final DeferredHolder<DataComponentType<?>, DataComponentType<Long>> SINGLE_OPERATION = DataComponents.registerLong("single_operation");
    public static final DeferredHolder<DataComponentType<?>, DataComponentType<Long>> SPHERE_OPERATION = DataComponents.registerLong("sphere_operation");

    public static void register() {
    }

    private static <TYPE> DeferredHolder<DataComponentType<?>, DataComponentType<TYPE>> simple(String name, UnaryOperator<DataComponentType.Builder<TYPE>> operator) {
        return Registration.DATA_COMPONENT_TYPES.register(name, () -> ((DataComponentType.Builder)operator.apply(DataComponentType.builder())).build());
    }

    private static DeferredHolder<DataComponentType<?>, DataComponentType<Boolean>> registerBoolean(String name) {
        return DataComponents.simple(name, builder -> builder.persistent((Codec)Codec.BOOL).networkSynchronized(ByteBufCodecs.BOOL));
    }

    private static DeferredHolder<DataComponentType<?>, DataComponentType<String>> registerString(String name) {
        return DataComponents.simple(name, builder -> builder.persistent((Codec)Codec.STRING).networkSynchronized(ByteBufCodecs.STRING_UTF8));
    }

    private static DeferredHolder<DataComponentType<?>, DataComponentType<DataComponentPatch>> registerDataComponent(String name) {
        return DataComponents.simple(name, builder -> builder.persistent(DataComponentPatch.CODEC).networkSynchronized(DataComponentPatch.STREAM_CODEC));
    }

    private static DeferredHolder<DataComponentType<?>, DataComponentType<Integer>> registerNonNegativeInt(String name) {
        return DataComponents.simple(name, builder -> builder.persistent(ExtraCodecs.POSITIVE_INT).networkSynchronized(ByteBufCodecs.VAR_INT));
    }

    private static DeferredHolder<DataComponentType<?>, DataComponentType<Integer>> registerInt(String name) {
        return DataComponents.simple(name, builder -> builder.persistent((Codec)Codec.INT).networkSynchronized(ByteBufCodecs.VAR_INT));
    }

    private static DeferredHolder<DataComponentType<?>, DataComponentType<Long>> registerLong(String name) {
        return DataComponents.simple(name, builder -> builder.persistent((Codec)Codec.LONG).networkSynchronized(ByteBufCodecs.VAR_LONG));
    }

    private static DeferredHolder<DataComponentType<?>, DataComponentType<UUID>> registerUUID(String name) {
        return DataComponents.simple(name, builder -> builder.persistent(UUIDUtil.CODEC).networkSynchronized(UUIDUtil.STREAM_CODEC));
    }

    private static DeferredHolder<DataComponentType<?>, DataComponentType<CompoundTag>> registerNBT(String name) {
        return DataComponents.simple(name, builder -> builder.persistent(CompoundTag.CODEC));
    }

    private static DeferredHolder<DataComponentType<?>, DataComponentType<Component>> registerComponent(String name) {
        return DataComponents.simple(name, builder -> builder.persistent(ComponentSerialization.FLAT_CODEC).networkSynchronized(ComponentSerialization.STREAM_CODEC).cacheEncoding());
    }

    private static <TYPE> DeferredHolder<DataComponentType<?>, DataComponentType<ResourceKey<TYPE>>> registerResourceKey(String name, ResourceKey<? extends Registry<TYPE>> registryKey) {
        return DataComponents.simple(name, builder -> builder.persistent(ResourceKey.codec((ResourceKey)registryKey)).networkSynchronized(ResourceKey.streamCodec((ResourceKey)registryKey)));
    }
}

