/*
 * Decompiled with CFR 0.152.
 */
package cy.jdkdigital.productivemetalworks.datagen;

import cy.jdkdigital.productivemetalworks.datagen.BlockModelProvider;
import cy.jdkdigital.productivemetalworks.datagen.BlockTagProvider;
import cy.jdkdigital.productivemetalworks.datagen.DataMapProvider;
import cy.jdkdigital.productivemetalworks.datagen.FluidTagProvider;
import cy.jdkdigital.productivemetalworks.datagen.FusionBlockModelProvider;
import cy.jdkdigital.productivemetalworks.datagen.FusionTextureMetadataProvider;
import cy.jdkdigital.productivemetalworks.datagen.GuideBookProvider;
import cy.jdkdigital.productivemetalworks.datagen.ItemModelProvider;
import cy.jdkdigital.productivemetalworks.datagen.ItemTagProvider;
import cy.jdkdigital.productivemetalworks.datagen.LanguageProvider;
import cy.jdkdigital.productivemetalworks.datagen.LootDataProvider;
import cy.jdkdigital.productivemetalworks.datagen.LootModifierProvider;
import cy.jdkdigital.productivemetalworks.datagen.RecipeProvider;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import net.minecraft.data.DataGenerator;
import net.minecraft.data.DataProvider;
import net.minecraft.data.PackOutput;
import net.minecraft.data.loot.LootTableProvider;
import net.minecraft.world.level.storage.loot.parameters.LootContextParamSets;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.ModList;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.common.data.ExistingFileHelper;
import net.neoforged.neoforge.data.event.GatherDataEvent;

@EventBusSubscriber(modid="productivemetalworks", bus=EventBusSubscriber.Bus.MOD)
public class MetalworksDataProvider {
    @SubscribeEvent
    public static void gatherData(GatherDataEvent event) {
        if (event.getModContainer().getModId().equals("productivemetalworks")) {
            Data.gatherData(event);
        }
    }

    static class Data {
        Data() {
        }

        private static void gatherData(GatherDataEvent event) {
            DataGenerator gen = event.getGenerator();
            PackOutput output = event.getGenerator().getPackOutput();
            CompletableFuture provider = event.getLookupProvider();
            ExistingFileHelper helper = event.getExistingFileHelper();
            gen.addProvider(event.includeClient(), (DataProvider)new LanguageProvider(output, "en_us"));
            gen.addProvider(event.includeClient(), (DataProvider)new BlockModelProvider(output));
            gen.addProvider(event.includeClient(), (DataProvider)new ItemModelProvider(output, helper));
            gen.addProvider(event.includeServer(), (DataProvider)new LootDataProvider(output, List.of(new LootTableProvider.SubProviderEntry(LootDataProvider.LootProvider::new, LootContextParamSets.BLOCK)), provider));
            gen.addProvider(event.includeServer(), (DataProvider)new RecipeProvider(output, provider));
            BlockTagProvider blockTags = new BlockTagProvider(output, provider, helper);
            gen.addProvider(event.includeServer(), (DataProvider)blockTags);
            gen.addProvider(event.includeServer(), (DataProvider)new ItemTagProvider(output, provider, blockTags.contentsGetter(), helper));
            gen.addProvider(event.includeServer(), (DataProvider)new FluidTagProvider(output, provider, helper));
            gen.addProvider(event.includeServer(), (DataProvider)new LootModifierProvider(output, provider));
            gen.addProvider(event.includeServer(), (DataProvider)new DataMapProvider(output, provider));
            if (ModList.get().isLoaded("patchouli")) {
                gen.addProvider(true, (DataProvider)new GuideBookProvider(output, "en_us", provider));
            }
            if (ModList.get().isLoaded("fusion")) {
                gen.addProvider(event.includeClient(), (DataProvider)new FusionBlockModelProvider(output));
                gen.addProvider(event.includeClient(), (DataProvider)new FusionTextureMetadataProvider(output));
            }
        }
    }
}

