/*
 * Decompiled with CFR 0.152.
 */
package cy.jdkdigital.productivemetalworks.common.block.entity;

import com.mojang.datafixers.util.Pair;
import cy.jdkdigital.productivelib.common.block.entity.FluidTankBlockEntity;
import cy.jdkdigital.productivelib.common.block.entity.IMultiBlockControllerBlockEntity;
import cy.jdkdigital.productivelib.common.block.entity.IUpgradeableBlockEntity;
import cy.jdkdigital.productivelib.common.block.entity.InventoryHandlerHelper;
import cy.jdkdigital.productivelib.exception.InvalidStructureException;
import cy.jdkdigital.productivelib.registry.LibItems;
import cy.jdkdigital.productivelib.util.MultiBlockDetector;
import cy.jdkdigital.productivelib.util.MultiFluidTank;
import cy.jdkdigital.productivemetalworks.Config;
import cy.jdkdigital.productivemetalworks.common.block.FoundryControllerBlock;
import cy.jdkdigital.productivemetalworks.common.block.IHeatingCoilBlock;
import cy.jdkdigital.productivemetalworks.common.block.entity.FoundryCapacitorBlockEntity;
import cy.jdkdigital.productivemetalworks.common.block.entity.FoundryTankBlockEntity;
import cy.jdkdigital.productivemetalworks.common.datamap.EntityMeltingMap;
import cy.jdkdigital.productivemetalworks.common.datamap.FuelMap;
import cy.jdkdigital.productivemetalworks.common.menu.FoundryControllerContainer;
import cy.jdkdigital.productivemetalworks.recipe.FluidAlloyingRecipe;
import cy.jdkdigital.productivemetalworks.recipe.ItemMeltingRecipe;
import cy.jdkdigital.productivemetalworks.registry.MetalworksRegistrator;
import cy.jdkdigital.productivemetalworks.registry.ModTags;
import cy.jdkdigital.productivemetalworks.util.CoilType;
import cy.jdkdigital.productivemetalworks.util.IFoundryFuel;
import cy.jdkdigital.productivemetalworks.util.RecipeHelper;
import cy.jdkdigital.productivemetalworks.util.TickingSlotInventoryHandler;
import java.util.List;
import java.util.Objects;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.ticks.TickPriority;
import net.neoforged.neoforge.fluids.FluidStack;
import net.neoforged.neoforge.fluids.capability.IFluidHandler;
import net.neoforged.neoforge.fluids.crafting.SizedFluidIngredient;
import net.neoforged.neoforge.items.IItemHandler;
import net.neoforged.neoforge.items.IItemHandlerModifiable;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class FoundryControllerBlockEntity
extends FluidTankBlockEntity
implements IUpgradeableBlockEntity,
IMultiBlockControllerBlockEntity,
MenuProvider {
    private MultiBlockDetector.MultiBlockData foundryData;
    private int tickCounter = 0;
    private float leftoverTick = 0.0f;
    private CoilType coilType = CoilType.UNKNOWN;
    public FluidStack fuel = FluidStack.EMPTY;
    public MultiFluidTank fluidHandler = new MultiFluidTank(20, 90000){

        protected void onContentsChanged(boolean hasChangedFluid) {
            Level level;
            super.onContentsChanged(hasChangedFluid);
            if (hasChangedFluid && (level = FoundryControllerBlockEntity.this.level) instanceof ServerLevel) {
                ServerLevel serverLevel = (ServerLevel)level;
                FoundryControllerBlockEntity.this.sync((Level)serverLevel);
            }
            FoundryControllerBlockEntity.this.setChanged();
        }
    };
    protected TickingSlotInventoryHandler itemHandler = new TickingSlotInventoryHandler(1024, (BlockEntity)this){

        @Override
        protected int getTimeInSlot(ItemStack stack) {
            BlockEntity blockEntity;
            if (!stack.isEmpty() && (blockEntity = this.blockEntity) instanceof FoundryControllerBlockEntity) {
                RecipeHolder<ItemMeltingRecipe> recipe;
                Level pLevel;
                FuelMap fuelData;
                Level level;
                IMelterProcessor melter;
                FoundryControllerBlockEntity fbe = (FoundryControllerBlockEntity)blockEntity;
                switch (fbe.coilType) {
                    default: {
                        throw new MatchException(null, null);
                    }
                    case UNKNOWN: {
                        IMelterProcessor iMelterProcessor = null;
                        break;
                    }
                    case FLUID: {
                        IMelterProcessor iMelterProcessor = new LiquidMelter();
                        break;
                    }
                    case ENERGY: {
                        IMelterProcessor iMelterProcessor = melter = new EnergyMelter();
                    }
                }
                if (melter != null && (level = this.blockEntity.getLevel()) instanceof Level && (fuelData = melter.getFoundryFuel(pLevel = level, fbe).getFuelData()) != null && (recipe = RecipeHelper.getItemMeltingRecipe(pLevel, stack, fuelData)) != null) {
                    return ((ItemMeltingRecipe)recipe.value()).result.stream().map(FluidStack::getAmount).reduce(Integer::sum).orElse(0);
                }
            }
            return 0;
        }

        public int getSlotLimit(int slot) {
            return 1;
        }

        public boolean isInputSlotItem(int slot, ItemStack item) {
            return true;
        }

        public boolean isInputSlot(int slot) {
            return true;
        }

        public boolean isItemValid(int slot, @NotNull ItemStack stack) {
            return true;
        }

        public int[] getOutputSlots() {
            return new int[0];
        }

        protected void onContentsChanged(int slot) {
            Level level = FoundryControllerBlockEntity.this.level;
            if (level instanceof ServerLevel) {
                ServerLevel serverLevel = (ServerLevel)level;
                FoundryControllerBlockEntity.this.sync((Level)serverLevel);
            }
        }
    };
    protected IItemHandlerModifiable upgradeHandler = new InventoryHandlerHelper.UpgradeHandler(4, (BlockEntity)this, List.of((Item)LibItems.UPGRADE_TIME.get(), (Item)LibItems.UPGRADE_TIME_2.get(), (Item)LibItems.UPGRADE_STABILITY.get()));

    public CoilType getCoilType() {
        return this.coilType;
    }

    public FoundryControllerBlockEntity(BlockPos pos, BlockState state) {
        super((BlockEntityType)MetalworksRegistrator.FOUNDRY_CONTROLLER_BLOCK_ENTITY.get(), pos, state);
    }

    public IItemHandlerModifiable getUpgradeHandler() {
        return this.upgradeHandler;
    }

    protected void burnItemsAtSpeed(float burnSpeed) {
        int burnTicks = Math.round(burnSpeed + this.leftoverTick);
        this.leftoverTick = burnSpeed + this.leftoverTick - (float)burnTicks;
        this.itemHandler.tick(burnTicks);
    }

    public static void serverTick(Level level, BlockPos pos, BlockState state, FoundryControllerBlockEntity blockEntity) {
        if (blockEntity.getMultiblockData() != null) {
            FluidTankBlockEntity.tick((Level)level, (BlockPos)pos, (BlockState)state, (FluidTankBlockEntity)blockEntity);
            MultiBlockDetector.MultiBlockData mb = blockEntity.getMultiblockData();
            if (blockEntity.tickCounter % 20 == 0 && (Config.foundryCollectItems || Config.foundryDamageEntities)) {
                BlockPos c1 = ((BlockPos)mb.topCorners().getFirst()).below(mb.height());
                BlockPos c2 = ((BlockPos)mb.topCorners().getSecond()).below(mb.height() - 2);
                level.getEntities(null, new AABB((double)c1.getX(), (double)c1.getY(), (double)c1.getZ(), (double)c2.getX(), (double)c2.getY(), (double)c2.getZ())).forEach(entity -> {
                    ItemEntity item;
                    if (Config.foundryCollectItems && entity instanceof ItemEntity && !(item = (ItemEntity)entity).isRemoved()) {
                        ItemStack groundStack = item.getItem();
                        for (int slot = 0; slot < blockEntity.itemHandler.getSlots(); ++slot) {
                            if (!blockEntity.itemHandler.getItem(slot).isEmpty()) continue;
                            ItemStack clonedStack = groundStack.copy();
                            clonedStack.setCount(1);
                            blockEntity.itemHandler.setStackInSlot(slot, clonedStack);
                            groundStack.shrink(1);
                        }
                    }
                    if (Config.foundryDamageEntities && entity instanceof LivingEntity) {
                        LivingEntity livingEntity = (LivingEntity)entity;
                        if (blockEntity.getFluidHandler().totalFluidAmount() > 0 || blockEntity.getFuel().getAmount() > 0) {
                            livingEntity.hurt(level.damageSources().hotFloor(), 2.0f);
                            EntityMeltingMap meltingFluid = (EntityMeltingMap)livingEntity.getType().builtInRegistryHolder().getData(MetalworksRegistrator.ENTITY_MELTING_MAP);
                            if (meltingFluid != null) {
                                blockEntity.fluidHandler.fill(meltingFluid.fluid(), IFluidHandler.FluidAction.EXECUTE);
                            }
                        }
                    }
                });
            }
            switch (blockEntity.coilType) {
                case FLUID: {
                    IMelterProcessor mp = new LiquidMelter();
                    mp.tick(level, pos, state, blockEntity);
                    break;
                }
                case ENERGY: {
                    IMelterProcessor mp = new EnergyMelter();
                    mp.tick(level, pos, state, blockEntity);
                }
            }
        }
        if (++blockEntity.tickCounter % 200 == 0) {
            blockEntity.tickCounter = 0;
            try {
                blockEntity.setMultiBlockData(FoundryControllerBlock.detectMultiblock(level, pos));
            }
            catch (InvalidStructureException e) {
                blockEntity.setMultiBlockData(null);
            }
        }
    }

    public static void clientTick(Level level, BlockPos blockPos, BlockState blockState, FoundryControllerBlockEntity blockEntity) {
        FuelMap fuelData;
        IMelterProcessor melter;
        switch (blockEntity.coilType) {
            default: {
                throw new MatchException(null, null);
            }
            case UNKNOWN: {
                IMelterProcessor iMelterProcessor = null;
                break;
            }
            case FLUID: {
                IMelterProcessor iMelterProcessor = new LiquidMelter();
                break;
            }
            case ENERGY: {
                IMelterProcessor iMelterProcessor = melter = new EnergyMelter();
            }
        }
        if (melter != null && (fuelData = melter.getFoundryFuel(level, blockEntity).getFuelData()) != null) {
            int speedModifier = blockEntity.getSpeedModifier();
            float burnSpeed = fuelData.speed() * (float)speedModifier;
            blockEntity.burnItemsAtSpeed(burnSpeed);
        }
    }

    public int getSpeedModifier() {
        return 1 + this.getUpgradeCount((Item)LibItems.UPGRADE_TIME.get()) + 2 * this.getUpgradeCount((Item)LibItems.UPGRADE_TIME_2.get());
    }

    public void tickFluidTank(Level level, BlockPos blockPos, BlockState blockState, FluidTankBlockEntity fluidTankBlockEntity) {
        FoundryControllerBlockEntity foundry;
        if (fluidTankBlockEntity instanceof FoundryControllerBlockEntity && (foundry = (FoundryControllerBlockEntity)fluidTankBlockEntity).getUpgradeCount((Item)LibItems.UPGRADE_STABILITY.get()) == 0) {
            List<RecipeHolder<FluidAlloyingRecipe>> recipeProcessList = RecipeHelper.getAlloyRecipes(level, this.fluidHandler);
            recipeProcessList.forEach(fluidAlloyingRecipe -> {
                int speed = ((FluidAlloyingRecipe)fluidAlloyingRecipe.value()).speed;
                boolean canDrainFullSpeed = ((FluidAlloyingRecipe)fluidAlloyingRecipe.value()).fluids.stream().map(f -> new SizedFluidIngredient(f.ingredient(), f.amount() * speed)).noneMatch(fluid -> this.fluidHandler.drain(fluid, IFluidHandler.FluidAction.SIMULATE).isEmpty());
                if (canDrainFullSpeed && this.fluidHandler.fill(new FluidStack(((FluidAlloyingRecipe)fluidAlloyingRecipe.value()).result.getFluid(), ((FluidAlloyingRecipe)fluidAlloyingRecipe.value()).result.getAmount() * speed), IFluidHandler.FluidAction.SIMULATE) > 0) {
                    ((FluidAlloyingRecipe)fluidAlloyingRecipe.value()).fluids.forEach(fluid -> this.fluidHandler.drain(fluid, IFluidHandler.FluidAction.EXECUTE));
                    this.fluidHandler.fill(((FluidAlloyingRecipe)fluidAlloyingRecipe.value()).result, IFluidHandler.FluidAction.EXECUTE);
                } else {
                    boolean canDrain = ((FluidAlloyingRecipe)fluidAlloyingRecipe.value()).fluids.stream().noneMatch(fluid -> this.fluidHandler.drain(fluid, IFluidHandler.FluidAction.SIMULATE).isEmpty());
                    if (canDrain && this.fluidHandler.fill(((FluidAlloyingRecipe)fluidAlloyingRecipe.value()).result, IFluidHandler.FluidAction.SIMULATE) > 0) {
                        ((FluidAlloyingRecipe)fluidAlloyingRecipe.value()).fluids.forEach(fluid -> this.fluidHandler.drain(fluid, IFluidHandler.FluidAction.EXECUTE));
                        this.fluidHandler.fill(((FluidAlloyingRecipe)fluidAlloyingRecipe.value()).result, IFluidHandler.FluidAction.EXECUTE);
                    }
                }
            });
        }
    }

    public int tankTickRate() {
        return 1;
    }

    public IItemHandler getItemHandler() {
        return this.itemHandler;
    }

    public MultiFluidTank getFluidHandler() {
        return this.fluidHandler;
    }

    @Nullable
    public AbstractContainerMenu createMenu(int i, Inventory inventory, Player player) {
        return new FoundryControllerContainer(i, inventory, this);
    }

    public void savePacketNBT(CompoundTag tag, HolderLookup.Provider provider) {
        super.savePacketNBT(tag, provider);
        if (this.getMultiblockData() != null) {
            tag.put("multiData", this.getMultiblockData().serializeNBT(provider));
        }
        tag.putString("coilType", this.coilType.name());
    }

    public void loadPacketNBT(CompoundTag tag, HolderLookup.Provider provider) {
        super.loadPacketNBT(tag, provider);
        if (tag.contains("multiData")) {
            MultiBlockDetector.MultiBlockData data = new MultiBlockDetector.MultiBlockData(null, null, List.of(), 0, 0);
            data.deserializeNBT(provider, Objects.requireNonNull(tag.get("multiData")));
            this.setMultiBlockData(data);
        }
        if (tag.contains("coilType")) {
            this.coilType = CoilType.valueOf(tag.getString("coilType"));
        }
    }

    public FluidStack getFuel() {
        MultiBlockDetector.MultiBlockData mb = this.getMultiblockData();
        if (this.level == null || mb == null) {
            return FluidStack.EMPTY;
        }
        FluidStack fluidFuel = FluidStack.EMPTY;
        for (BlockPos pos : mb.peripherals()) {
            FoundryTankBlockEntity tank;
            FluidStack fluid;
            BlockEntity blockEntity = this.level.getBlockEntity(pos);
            if (!(blockEntity instanceof FoundryTankBlockEntity) || (fluid = (tank = (FoundryTankBlockEntity)blockEntity).getFluidHandler().getFluidInTank(0)).isEmpty()) continue;
            if (fluidFuel.isEmpty()) {
                fluidFuel = fluid.copy();
                continue;
            }
            if (!fluidFuel.is(fluid.getFluid())) continue;
            fluidFuel.grow(fluid.getAmount());
        }
        return fluidFuel;
    }

    public int getPower() {
        MultiBlockDetector.MultiBlockData mb = this.getMultiblockData();
        if (this.level == null || mb == null) {
            return 0;
        }
        int power = 0;
        for (BlockPos pos : mb.peripherals()) {
            BlockEntity blockEntity = this.level.getBlockEntity(pos);
            if (!(blockEntity instanceof FoundryCapacitorBlockEntity)) continue;
            FoundryCapacitorBlockEntity capacitor = (FoundryCapacitorBlockEntity)blockEntity;
            power += capacitor.energyHandler.getEnergyStored();
        }
        return power;
    }

    public int getPowerMax() {
        MultiBlockDetector.MultiBlockData mb = this.getMultiblockData();
        if (this.level == null || mb == null) {
            return 0;
        }
        int power = 0;
        for (BlockPos pos : mb.peripherals()) {
            BlockEntity blockEntity = this.level.getBlockEntity(pos);
            if (!(blockEntity instanceof FoundryCapacitorBlockEntity)) continue;
            FoundryCapacitorBlockEntity capacitor = (FoundryCapacitorBlockEntity)blockEntity;
            power += capacitor.energyHandler.getMaxEnergyStored();
        }
        return power;
    }

    void addRecipeResult(List<FluidStack> result) {
        for (FluidStack fluidStack : result) {
            if (this.fluidHandler.fill(fluidStack, IFluidHandler.FluidAction.SIMULATE) != fluidStack.getAmount()) continue;
            this.fluidHandler.fill(fluidStack, IFluidHandler.FluidAction.EXECUTE);
        }
    }

    public void setMultiBlockData(MultiBlockDetector.MultiBlockData multiBlockData) {
        ServerLevel serverLevel;
        Level level = this.level;
        if (level instanceof ServerLevel) {
            serverLevel = (ServerLevel)level;
            if (multiBlockData != null) {
                this.fluidHandler.setCapacity(multiBlockData.volume() * Config.foundryFluidCapacityPerBlockVolume);
                this.itemHandler.setSize(multiBlockData.volume());
                if (!((Boolean)this.getBlockState().getValue((Property)BlockStateProperties.ATTACHED)).booleanValue()) {
                    serverLevel.setBlockAndUpdate(this.getBlockPos(), (BlockState)this.getBlockState().setValue((Property)BlockStateProperties.ATTACHED, (Comparable)Boolean.valueOf(true)));
                }
                Direction controllerFacing = (Direction)serverLevel.getBlockState(multiBlockData.controllerPos()).getValue((Property)BlockStateProperties.HORIZONTAL_FACING);
                BlockPos c1 = ((BlockPos)multiBlockData.topCorners().getFirst()).relative(controllerFacing.getOpposite()).relative(controllerFacing.getCounterClockWise()).below(multiBlockData.height());
                BlockPos c2 = ((BlockPos)multiBlockData.topCorners().getSecond()).relative(controllerFacing).relative(controllerFacing.getClockWise()).below(multiBlockData.height());
                this.coilType = CoilType.UNKNOWN;
                BlockPos.betweenClosed((BlockPos)c1, (BlockPos)c2).forEach(blockPos -> {
                    Block patt0$temp;
                    BlockState state = serverLevel.getBlockState(blockPos);
                    if (state.is(ModTags.Blocks.HEATING_COILS) && !((Boolean)state.getValue((Property)BlockStateProperties.ATTACHED)).booleanValue()) {
                        serverLevel.setBlockAndUpdate(blockPos, (BlockState)state.setValue((Property)BlockStateProperties.ATTACHED, (Comparable)Boolean.valueOf(true)));
                    }
                    if ((patt0$temp = state.getBlock()) instanceof IHeatingCoilBlock) {
                        IHeatingCoilBlock heatingCoilBlock = (IHeatingCoilBlock)patt0$temp;
                        this.coilType = heatingCoilBlock.getCoilType();
                    }
                });
                this.sync(this.level);
            } else if (((Boolean)this.getBlockState().getValue((Property)BlockStateProperties.ATTACHED)).booleanValue()) {
                serverLevel.setBlockAndUpdate(this.getBlockPos(), (BlockState)this.getBlockState().setValue((Property)BlockStateProperties.ATTACHED, (Comparable)Boolean.valueOf(false)));
            }
        } else {
            this.fluidHandler.setCapacity(multiBlockData.volume() * Config.foundryFluidCapacityPerBlockVolume);
            this.itemHandler.setSize(multiBlockData.volume());
        }
        level = this.level;
        if (level instanceof ServerLevel) {
            serverLevel = (ServerLevel)level;
            if (this.foundryData != multiBlockData || multiBlockData != null) {
                this.sync((Level)serverLevel);
            }
        }
        this.foundryData = multiBlockData;
        this.setChanged();
    }

    public MultiBlockDetector.MultiBlockData getMultiblockData() {
        return this.foundryData;
    }

    public void sync(Level level) {
        level.sendBlockUpdated(this.getBlockPos(), this.getBlockState(), this.getBlockState(), 2);
        MultiBlockDetector.MultiBlockData mb = this.getMultiblockData();
        if (mb != null) {
            mb.peripherals().forEach(pos -> {
                BlockState peripheralBlockState = level.getBlockState(pos);
                if (peripheralBlockState.is(ModTags.Blocks.FOUNDRY_DRAINS)) {
                    for (Direction direction : Direction.values()) {
                        BlockState relBlockState = level.getBlockState(pos.relative(direction));
                        if (!relBlockState.is(Blocks.COMPARATOR) || level.getBlockTicks().willTickThisTick(pos.relative(direction), (Object)relBlockState.getBlock())) continue;
                        level.scheduleTick(pos.relative(direction), relBlockState.getBlock(), 2, TickPriority.NORMAL);
                    }
                }
            });
        }
    }

    public void moveTankFirst(int tank) {
        if (tank > 0 && tank < this.fluidHandler.getTanks()) {
            this.fluidHandler.moveTankToTop(tank);
            this.sync(this.level);
        }
    }

    public static class LiquidMelter
    implements IMelterProcessor {
        @Override
        public void tick(Level level, BlockPos pos, BlockState state, FoundryControllerBlockEntity blockEntity) {
            MultiBlockDetector.MultiBlockData mb = blockEntity.getMultiblockData();
            FluidStack fuelStack = blockEntity.getFuel();
            if (fuelStack.isEmpty()) {
                return;
            }
            FluidFuel fuel = new FluidFuel(fuelStack);
            if (fuel.getFuelData() == null) {
                return;
            }
            FluidFuel consumedFuel = new FluidFuel(new FluidStack(fuelStack.getFluid(), 0));
            boolean hasChanged = this.meltItems(level, blockEntity, consumedFuel, fuel);
            if (hasChanged) {
                for (BlockPos blockPos : mb.peripherals()) {
                    BlockEntity blockEntity2;
                    if (consumedFuel.isEmpty() || !((blockEntity2 = level.getBlockEntity(blockPos)) instanceof FoundryTankBlockEntity)) continue;
                    FoundryTankBlockEntity tankBlockEntity = (FoundryTankBlockEntity)blockEntity2;
                    FluidStack drainedFluid = tankBlockEntity.getFluidHandler().drain(new FluidStack(fuelStack.getFluid(), consumedFuel.getAmount()), IFluidHandler.FluidAction.EXECUTE);
                    consumedFuel.shrink(drainedFluid.getAmount());
                }
                blockEntity.sync(level);
            }
        }

        @Override
        public IFoundryFuel getFoundryFuel(Level level, FoundryControllerBlockEntity blockEntity) {
            return new FluidFuel(blockEntity.getFuel());
        }
    }

    public static interface IMelterProcessor {
        public void tick(Level var1, BlockPos var2, BlockState var3, FoundryControllerBlockEntity var4);

        public IFoundryFuel getFoundryFuel(Level var1, FoundryControllerBlockEntity var2);

        default public boolean meltItems(Level level, FoundryControllerBlockEntity blockEntity, IFoundryFuel consumedFuel, IFoundryFuel availableFuel) {
            FuelMap fuelData = availableFuel.getFuelData();
            if (fuelData == null) {
                return false;
            }
            int speedModifier = blockEntity.getSpeedModifier();
            float burnSpeed = fuelData.speed() * (float)speedModifier;
            blockEntity.burnItemsAtSpeed(burnSpeed);
            boolean hasChanged = false;
            for (int slot = 0; slot < blockEntity.itemHandler.size(); ++slot) {
                int totalProducedFluid;
                int requiredFuel;
                RecipeHolder<ItemMeltingRecipe> recipe;
                ItemStack item;
                Pair<Integer, Integer> ticker = blockEntity.itemHandler.getTicker(slot);
                if ((Integer)ticker.getSecond() <= 0 || (Integer)ticker.getFirst() > 0 || (item = blockEntity.getItemHandler().getStackInSlot(slot)).isEmpty() || (recipe = RecipeHelper.getItemMeltingRecipe(level, item, fuelData)) == null || (requiredFuel = (int)((float)(totalProducedFluid = ((ItemMeltingRecipe)recipe.value()).result.stream().map(FluidStack::getAmount).reduce(Integer::sum).orElse(0).intValue()) * fuelData.consumption() * (float)speedModifier)) + consumedFuel.getAmount() > availableFuel.getAmount() || totalProducedFluid > blockEntity.fluidHandler.getCapacity() - blockEntity.fluidHandler.totalFluidAmount()) continue;
                consumedFuel.grow(requiredFuel);
                blockEntity.itemHandler.extractItem(slot, 1, false, false);
                hasChanged = true;
                blockEntity.addRecipeResult(((ItemMeltingRecipe)recipe.value()).result);
            }
            return hasChanged;
        }
    }

    public static class EnergyMelter
    implements IMelterProcessor {
        @Override
        public void tick(Level level, BlockPos pos, BlockState state, FoundryControllerBlockEntity blockEntity) {
            MultiBlockDetector.MultiBlockData mb = blockEntity.getMultiblockData();
            int power = blockEntity.getPower();
            if (power == 0) {
                return;
            }
            BlockPos coilPos = new BlockPos((((BlockPos)blockEntity.getMultiblockData().topCorners().getFirst()).getX() + ((BlockPos)blockEntity.getMultiblockData().topCorners().getSecond()).getX()) / 2, ((BlockPos)blockEntity.getMultiblockData().topCorners().getFirst()).getY() - blockEntity.getMultiblockData().height(), (((BlockPos)blockEntity.getMultiblockData().topCorners().getFirst()).getZ() + ((BlockPos)blockEntity.getMultiblockData().topCorners().getSecond()).getZ()) / 2);
            PowerFuel powerFuel = new PowerFuel(power, level.getBlockState(coilPos).getBlock());
            if (powerFuel.getFuelData() == null) {
                return;
            }
            PowerFuel consumedFuel = new PowerFuel(0, powerFuel.getFuelData());
            boolean hasChanged = this.meltItems(level, blockEntity, consumedFuel, powerFuel);
            if (hasChanged) {
                for (BlockPos blockPos : mb.peripherals()) {
                    BlockEntity blockEntity2;
                    if (consumedFuel.isEmpty() || !((blockEntity2 = level.getBlockEntity(blockPos)) instanceof FoundryCapacitorBlockEntity)) continue;
                    FoundryCapacitorBlockEntity capacitorBlockEntity = (FoundryCapacitorBlockEntity)blockEntity2;
                    int drainedPower = capacitorBlockEntity.energyHandler.extractEnergy(consumedFuel.getAmount(), false);
                    consumedFuel.shrink(drainedPower);
                }
                blockEntity.sync(level);
            }
        }

        @Override
        public IFoundryFuel getFoundryFuel(Level level, FoundryControllerBlockEntity blockEntity) {
            MultiBlockDetector.MultiBlockData mb = blockEntity.getMultiblockData();
            if (mb != null) {
                BlockPos coilPos = new BlockPos((((BlockPos)blockEntity.getMultiblockData().topCorners().getFirst()).getX() + ((BlockPos)blockEntity.getMultiblockData().topCorners().getSecond()).getX()) / 2, ((BlockPos)blockEntity.getMultiblockData().topCorners().getFirst()).getY() - blockEntity.getMultiblockData().height(), (((BlockPos)blockEntity.getMultiblockData().topCorners().getFirst()).getZ() + ((BlockPos)blockEntity.getMultiblockData().topCorners().getSecond()).getZ()) / 2);
                return new PowerFuel(blockEntity.getPower(), level.getBlockState(coilPos).getBlock());
            }
            return new PowerFuel(blockEntity.getPower(), (Block)MetalworksRegistrator.POWERED_HEATING_COIL.get());
        }
    }

    static class PowerFuel
    implements IFoundryFuel {
        private int power;
        private FuelMap fuelData;

        public PowerFuel(int power, Block coilBlock) {
            this.power = power;
            this.fuelData = (FuelMap)coilBlock.builtInRegistryHolder().getData(MetalworksRegistrator.POWER_COIL_MAP);
        }

        public PowerFuel(int power, FuelMap fuelData) {
            this.power = power;
            this.fuelData = fuelData;
        }

        @Override
        public FuelMap getFuelData() {
            return this.fuelData;
        }

        @Override
        public int getAmount() {
            return this.power;
        }

        @Override
        public void grow(int amount) {
            this.power += amount;
        }

        @Override
        public void shrink(int amount) {
            this.power -= amount;
        }

        @Override
        public boolean isEmpty() {
            return this.power == 0;
        }
    }

    static class FluidFuel
    implements IFoundryFuel {
        private final FluidStack fluidStack;
        private FuelMap fuelData;

        public FluidFuel(FluidStack fluidStack) {
            this.fluidStack = fluidStack;
            this.fuelData = (FuelMap)fluidStack.getFluid().builtInRegistryHolder().getData(MetalworksRegistrator.FUEL_MAP);
        }

        @Override
        public FuelMap getFuelData() {
            return this.fuelData;
        }

        @Override
        public int getAmount() {
            return this.fluidStack.getAmount();
        }

        @Override
        public void grow(int amount) {
            this.fluidStack.grow(amount);
        }

        @Override
        public void shrink(int amount) {
            this.fluidStack.shrink(amount);
        }

        @Override
        public boolean isEmpty() {
            return this.fluidStack.isEmpty();
        }
    }
}

