/*
 * Decompiled with CFR 0.152.
 */
package es.degrassi.mmreborn.common.util;

import es.degrassi.mmreborn.common.entity.MachineControllerEntity;
import es.degrassi.mmreborn.common.entity.base.EnergyHatchEntity;
import es.degrassi.mmreborn.common.entity.base.ExperienceHatchEntity;
import es.degrassi.mmreborn.common.entity.base.FluidTankEntity;
import es.degrassi.mmreborn.common.entity.base.TileInventory;
import es.degrassi.mmreborn.common.util.HybridTank;
import java.lang.runtime.SwitchBootstraps;
import java.util.Objects;
import javax.annotation.Nullable;
import net.minecraft.util.Mth;
import net.minecraft.world.level.block.entity.BlockEntity;

public class RedstoneHelper {
    public static int getRedstoneLevel(@Nullable BlockEntity sync) {
        if (sync == null) {
            return 0;
        }
        BlockEntity blockEntity = sync;
        Objects.requireNonNull(blockEntity);
        BlockEntity blockEntity2 = blockEntity;
        int n = 0;
        return switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{MachineControllerEntity.class, TileInventory.class, FluidTankEntity.class, EnergyHatchEntity.class, ExperienceHatchEntity.class}, (Object)blockEntity2, n)) {
            case 0 -> {
                MachineControllerEntity entity = (MachineControllerEntity)blockEntity2;
                if (entity.getStatus().isCrafting()) {
                    yield 15;
                }
                if (!entity.getStatus().isMissingStructure()) {
                    yield 1;
                }
                yield 0;
            }
            case 1 -> {
                TileInventory entity = (TileInventory)blockEntity2;
                yield entity.getInventory().calcRedstoneFromInventory();
            }
            case 2 -> {
                FluidTankEntity ft = (FluidTankEntity)blockEntity2;
                HybridTank tank = ft.getTank();
                float cap = tank.getCapacity();
                float cur = tank.getFluidAmount();
                yield Mth.clamp((int)Math.round(15.0f * (cur / cap)), (int)0, (int)15);
            }
            case 3 -> {
                EnergyHatchEntity entity = (EnergyHatchEntity)blockEntity2;
                float cap = entity.getMaxEnergy();
                float cur = entity.getCurrentEnergy();
                yield Mth.clamp((int)Math.round(15.0f * (cur / cap)), (int)0, (int)15);
            }
            case 4 -> {
                ExperienceHatchEntity entity = (ExperienceHatchEntity)blockEntity2;
                float cap = entity.getTank().getExperienceCapacity();
                float cur = entity.getTank().getExperience();
                yield Mth.clamp((int)Math.round(15.0f * (cur / cap)), (int)0, (int)15);
            }
            default -> 0;
        };
    }

    public static int getReceivingRedstone(@Nullable BlockEntity sync) {
        if (sync == null || sync.getLevel() == null) {
            return 0;
        }
        BlockEntity blockEntity = sync;
        Objects.requireNonNull(blockEntity);
        BlockEntity blockEntity2 = blockEntity;
        int n = 0;
        return switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{MachineControllerEntity.class, TileInventory.class, FluidTankEntity.class, EnergyHatchEntity.class, ExperienceHatchEntity.class}, (Object)blockEntity2, n)) {
            case 0 -> {
                MachineControllerEntity entity = (MachineControllerEntity)blockEntity2;
                yield entity.getLevel().getBestNeighborSignal(entity.getBlockPos());
            }
            case 1 -> {
                TileInventory entity = (TileInventory)blockEntity2;
                yield entity.getLevel().getBestNeighborSignal(entity.getBlockPos());
            }
            case 2 -> {
                FluidTankEntity entity = (FluidTankEntity)blockEntity2;
                yield entity.getLevel().getBestNeighborSignal(entity.getBlockPos());
            }
            case 3 -> {
                EnergyHatchEntity entity = (EnergyHatchEntity)blockEntity2;
                yield entity.getLevel().getBestNeighborSignal(entity.getBlockPos());
            }
            case 4 -> {
                ExperienceHatchEntity entity = (ExperienceHatchEntity)blockEntity2;
                yield entity.getLevel().getBestNeighborSignal(entity.getBlockPos());
            }
            default -> 0;
        };
    }
}

