/*
 * Decompiled with CFR 0.152.
 */
package es.degrassi.mmreborn.common.network.client;

import es.degrassi.mmreborn.ModularMachineryReborn;
import es.degrassi.mmreborn.api.Structure;
import es.degrassi.mmreborn.common.machine.DynamicMachine;
import net.minecraft.core.BlockPos;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.neoforged.neoforge.network.handling.IPayloadContext;

public record CPlaceStructurePacket(ResourceLocation machine, BlockPos controllerPos, boolean withModifiers) implements CustomPacketPayload
{
    public static final CustomPacketPayload.Type<CPlaceStructurePacket> TYPE = new CustomPacketPayload.Type(ModularMachineryReborn.rl("place_structure"));
    public static final StreamCodec<RegistryFriendlyByteBuf, CPlaceStructurePacket> CODEC = new StreamCodec<RegistryFriendlyByteBuf, CPlaceStructurePacket>(){

        public CPlaceStructurePacket decode(RegistryFriendlyByteBuf buf) {
            return new CPlaceStructurePacket(buf.readResourceLocation(), buf.readBlockPos(), buf.readBoolean());
        }

        public void encode(RegistryFriendlyByteBuf buffer, CPlaceStructurePacket value) {
            buffer.writeResourceLocation(value.machine);
            buffer.writeBlockPos(value.controllerPos);
            buffer.writeBoolean(value.withModifiers);
        }
    };

    public CustomPacketPayload.Type<CPlaceStructurePacket> type() {
        return TYPE;
    }

    public static void handle(CPlaceStructurePacket packet, IPayloadContext context) {
        Player player = context.player();
        if (player instanceof ServerPlayer) {
            ServerPlayer player2 = (ServerPlayer)player;
            context.enqueueWork(() -> {
                DynamicMachine machine = (DynamicMachine)ModularMachineryReborn.MACHINES.get((Object)packet.machine);
                if (machine == null || machine == DynamicMachine.DUMMY) {
                    return;
                }
                Structure.place(machine, packet.controllerPos, player2.level(), player2.isCreative(), player2, packet.withModifiers);
            });
        }
    }
}

