/*
 * Decompiled with CFR 0.152.
 */
package es.degrassi.mmreborn.common.integration.kubejs.requirement;

import es.degrassi.mmreborn.api.crafting.requirement.RecipeRequirement;
import es.degrassi.mmreborn.common.crafting.requirement.PositionedRequirement;
import es.degrassi.mmreborn.common.crafting.requirement.RequirementItem;
import es.degrassi.mmreborn.common.integration.kubejs.MachineRecipeBuilderJS;
import es.degrassi.mmreborn.common.integration.kubejs.RecipeJSBuilder;
import es.degrassi.mmreborn.common.machine.IOType;
import net.neoforged.neoforge.common.crafting.SizedIngredient;

public interface ItemRequirementJS
extends RecipeJSBuilder {
    default public MachineRecipeBuilderJS requireItem(SizedIngredient stack) {
        return this.requireItem(stack, 0, 0);
    }

    default public MachineRecipeBuilderJS produceItem(SizedIngredient stack) {
        return this.produceItem(stack, 0, 0);
    }

    default public MachineRecipeBuilderJS requireItem(SizedIngredient stack, float chance) {
        return this.requireItem(stack, chance, 0, 0);
    }

    default public MachineRecipeBuilderJS produceItem(SizedIngredient stack, float chance) {
        return this.produceItem(stack, chance, 0, 0);
    }

    default public MachineRecipeBuilderJS requireItem(SizedIngredient stack, int x, int y) {
        return this.requireItem(stack, 1.0f, x, y);
    }

    default public MachineRecipeBuilderJS produceItem(SizedIngredient stack, int x, int y) {
        return this.produceItem(stack, 1.0f, x, y);
    }

    default public MachineRecipeBuilderJS requireItem(SizedIngredient stack, float chance, int x, int y) {
        if (stack.getItems().length == 0) {
            return this.error("Invalid empty ingredient in item input requirement", new Object[0]);
        }
        if (chance < 0.0f) {
            return this.error("Chance can not bellow 0", new Object[0]);
        }
        if (chance > 1.0f) {
            return this.error("Chance can not be greater than 1", new Object[0]);
        }
        RequirementItem requirement = new RequirementItem(IOType.INPUT, stack, new PositionedRequirement(x, y));
        return this.addRequirement(new RecipeRequirement(requirement, chance));
    }

    default public MachineRecipeBuilderJS produceItem(SizedIngredient stack, float chance, int x, int y) {
        if (stack.getItems().length == 0) {
            return this.error("Invalid empty item in item output requirement", new Object[0]);
        }
        if (stack.getItems().length > 1) {
            return this.error("Item Requirement cant use tags or multiple outputs", new Object[0]);
        }
        if (chance < 0.0f) {
            return this.error("Chance can not bellow 0", new Object[0]);
        }
        if (chance > 1.0f) {
            return this.error("Chance can not be greater than 1", new Object[0]);
        }
        RequirementItem requirement = new RequirementItem(IOType.OUTPUT, stack, new PositionedRequirement(x, y));
        return this.addRequirement(new RecipeRequirement(requirement, chance));
    }
}

