/*
 * Decompiled with CFR 0.152.
 */
package es.degrassi.mmreborn.common.integration.kubejs.function;

import dev.latvian.mods.kubejs.level.BlockContainerJS;
import dev.latvian.mods.rhino.Wrapper;
import es.degrassi.mmreborn.common.entity.MachineControllerEntity;
import es.degrassi.mmreborn.common.machine.IOType;
import es.degrassi.mmreborn.common.machine.component.ChunkloadComponent;
import es.degrassi.mmreborn.common.machine.component.EnergyComponent;
import es.degrassi.mmreborn.common.machine.component.FluidComponent;
import es.degrassi.mmreborn.common.machine.component.ItemComponent;
import es.degrassi.mmreborn.common.registration.ComponentRegistration;
import es.degrassi.mmreborn.common.util.Chunkloader;
import es.degrassi.mmreborn.common.util.IEnergyHandler;
import es.degrassi.mmreborn.common.util.IOInventory;
import es.degrassi.mmreborn.common.util.ItemSlot;
import es.degrassi.mmreborn.common.util.TaskDelayer;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Predicate;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.neoforged.neoforge.fluids.FluidStack;
import net.neoforged.neoforge.fluids.capability.IFluidHandler;

public class MachineControllerJS {
    private final MachineControllerEntity internal;

    protected MachineControllerJS(MachineControllerEntity internal) {
        this.internal = internal;
    }

    public static MachineControllerJS of(Object o) {
        BlockEntity be;
        if (o instanceof Wrapper) {
            Wrapper w = (Wrapper)o;
            o = w.unwrap();
        }
        if (o instanceof BlockEntity && (be = (BlockEntity)o) instanceof MachineControllerEntity) {
            MachineControllerEntity mce = (MachineControllerEntity)be;
            return new MachineControllerJS(mce);
        }
        if (o instanceof BlockContainerJS) {
            BlockContainerJS bc = (BlockContainerJS)o;
            return MachineControllerJS.of(bc.getEntity());
        }
        return null;
    }

    public String getId() {
        return this.internal.getId().toString();
    }

    public void setId(String id) {
        ResourceLocation loc = ResourceLocation.tryParse((String)id);
        if (loc == null) {
            throw new IllegalArgumentException("Invalid machine ID: " + id);
        }
        TaskDelayer.enqueue(0, () -> {
            this.internal.getProcessor().reset();
            this.internal.setMachine(loc);
        });
    }

    public boolean getPaused() {
        return this.internal.isPaused();
    }

    public void setPaused(boolean paused) {
        this.internal.setPaused(paused);
    }

    public long getEnergyStored(IOType mode) {
        return this.internal.getComponentManager().getFoundComponentsList().stream().filter(c -> c instanceof EnergyComponent).map(c -> (EnergyComponent)c).filter(c -> c.getIOType().equals((Object)mode)).mapToLong(c -> c.getContainerProvider().getCurrentEnergy()).sum();
    }

    public long addEnergy(long energy) {
        AtomicLong energyAtomic = new AtomicLong(energy);
        AtomicLong inserted = new AtomicLong(0L);
        this.internal.getComponentManager().getFoundComponentsList().stream().filter(c -> c instanceof EnergyComponent).map(c -> (EnergyComponent)c).filter(c -> !c.getIOType().isInput()).forEach(c -> {
            if (energyAtomic.get() <= 0L) {
                return;
            }
            IEnergyHandler handler = c.getContainerProvider();
            boolean prevInsert = handler.canReceive();
            handler.setCanInsert(true);
            int received = handler.receiveEnergy((int)energyAtomic.get(), false);
            energyAtomic.addAndGet(-received);
            inserted.addAndGet(received);
            handler.setCanInsert(prevInsert);
        });
        return inserted.get();
    }

    public long removeEnergy(long energy) {
        AtomicLong energyAtomic = new AtomicLong(energy);
        AtomicLong extracted = new AtomicLong(0L);
        this.internal.getComponentManager().getFoundComponentsList().stream().filter(c -> c instanceof EnergyComponent).map(c -> (EnergyComponent)c).filter(c -> c.getIOType().isInput()).forEach(c -> {
            if (energyAtomic.get() <= 0L) {
                return;
            }
            IEnergyHandler handler = c.getContainerProvider();
            boolean prevExtract = handler.canExtract();
            handler.setCanExtract(true);
            int drained = handler.extractEnergy((int)energyAtomic.get(), false);
            energyAtomic.addAndGet(-drained);
            extracted.addAndGet(drained);
            handler.setCanExtract(prevExtract);
        });
        return extracted.get();
    }

    public List<FluidStack> getFluidsStored(IOType mode) {
        return this.internal.getComponentManager().getFoundComponentsList().stream().filter(c -> c instanceof FluidComponent).map(c -> (FluidComponent)c).filter(c -> c.getIOType().equals((Object)mode)).map(c -> c.getContainerProvider().getFluid()).toList();
    }

    public int getFluidCapacity(IOType mode) {
        return this.internal.getComponentManager().getFoundComponentsList().stream().filter(c -> c instanceof FluidComponent).map(c -> (FluidComponent)c).filter(c -> c.getIOType().equals((Object)mode)).mapToInt(c -> c.getContainerProvider().getCapacity()).sum();
    }

    public int getFluidCapacity(FluidStack fluid, IOType mode) {
        return this.internal.getComponentManager().getFoundComponentsList().stream().filter(c -> c instanceof FluidComponent).map(c -> (FluidComponent)c).filter(c -> c.getIOType().equals((Object)mode)).filter(c -> FluidStack.isSameFluidSameComponents((FluidStack)c.getContainerProvider().getFluid(), (FluidStack)fluid)).mapToInt(c -> c.getContainerProvider().getCapacity()).sum();
    }

    public int addFluid(FluidStack stack) {
        AtomicReference<FluidStack> fluid = new AtomicReference<FluidStack>(stack);
        AtomicInteger filled = new AtomicInteger(0);
        this.internal.getComponentManager().getFoundComponentsList().stream().filter(c -> c instanceof FluidComponent).map(c -> (FluidComponent)c).filter(c -> !c.getIOType().isInput()).filter(c -> c.getContainerProvider().isEmpty() || FluidStack.isSameFluidSameComponents((FluidStack)c.getContainerProvider().getFluid(), (FluidStack)stack)).forEach(c -> {
            if (((FluidStack)fluid.get()).isEmpty()) {
                return;
            }
            if (((FluidStack)fluid.get()).getAmount() <= 0) {
                return;
            }
            int inserted = c.getContainerProvider().fill((FluidStack)fluid.get(), IFluidHandler.FluidAction.EXECUTE);
            ((FluidStack)fluid.get()).shrink(inserted);
            filled.getAndAdd(inserted);
        });
        return filled.get();
    }

    public FluidStack removeFluid(FluidStack stack) {
        AtomicReference<FluidStack> fluid = new AtomicReference<FluidStack>(stack);
        AtomicReference<FluidStack> extracted = new AtomicReference<FluidStack>(FluidStack.EMPTY);
        this.internal.getComponentManager().getFoundComponentsList().stream().filter(c -> c instanceof FluidComponent).map(c -> (FluidComponent)c).filter(c -> c.getIOType().isInput()).filter(c -> FluidStack.isSameFluidSameComponents((FluidStack)c.getContainerProvider().getFluid(), (FluidStack)stack)).forEach(c -> {
            if (((FluidStack)fluid.get()).isEmpty()) {
                return;
            }
            if (c.getContainerProvider().isEmpty()) {
                return;
            }
            FluidStack drained = c.getContainerProvider().drain((FluidStack)fluid.get(), IFluidHandler.FluidAction.EXECUTE);
            ((FluidStack)fluid.get()).shrink(drained.getAmount());
            if (((FluidStack)extracted.get()).isEmpty()) {
                extracted.set(drained);
            } else {
                ((FluidStack)extracted.get()).grow(drained.getAmount());
            }
        });
        return extracted.get();
    }

    public List<ItemStack> getItemsStored(IOType mode) {
        return this.internal.getComponentManager().getFoundComponentsList().stream().filter(c -> c instanceof ItemComponent).map(c -> (ItemComponent)c).filter(c -> c.getIOType().equals((Object)mode)).map(ItemComponent::getContainerProvider).map(IOInventory::getInventory).map(c -> c.stream().map(ItemSlot::getItemStack).toList()).flatMap(Collection::stream).toList();
    }

    public ItemStack addItem(ItemStack stack) {
        AtomicReference<ItemStack> item = new AtomicReference<ItemStack>(stack);
        AtomicReference<ItemStack> inserted = new AtomicReference<ItemStack>(ItemStack.EMPTY);
        this.internal.getComponentManager().getFoundComponentsList().stream().filter(c -> c instanceof ItemComponent).map(c -> (ItemComponent)c).filter(c -> !c.getIOType().isInput()).forEach(c -> {
            if (((ItemStack)item.get()).isEmpty()) {
                return;
            }
            if (c.getSpaceForItem((ItemStack)item.get()) <= 0) {
                return;
            }
            AtomicInteger toAdd = new AtomicInteger(stack.getCount());
            c.getContainerProvider().getOutputs().stream().filter(component -> c.getContainerProvider().canPlaceOutput((ItemSlot)component, stack)).forEach(component -> {
                int maxInsert = toAdd.get() - component.insertItemBypassLimit(stack, true).getCount();
                toAdd.addAndGet(-maxInsert);
                ItemStack remaining = component.insertItemBypassLimit(stack.copyWithCount(maxInsert), false);
                item.set(remaining);
            });
        });
        return inserted.get();
    }

    public ItemStack removeItem(ItemStack stack) {
        AtomicReference<ItemStack> item = new AtomicReference<ItemStack>(stack);
        AtomicReference<ItemStack> extracted = new AtomicReference<ItemStack>(ItemStack.EMPTY);
        this.internal.getComponentManager().getFoundComponentsList().stream().filter(c -> c instanceof ItemComponent).map(c -> (ItemComponent)c).filter(c -> c.getIOType().isInput()).forEach(c -> {
            if (((ItemStack)item.get()).isEmpty()) {
                return;
            }
            if (c.getItemAmount((ItemStack)item.get()) <= 0) {
                return;
            }
            AtomicInteger toRemove = new AtomicInteger(((ItemStack)item.get()).getCount());
            AtomicInteger removed = new AtomicInteger(0);
            Predicate<ItemSlot> slotPredicate = component -> true;
            c.getContainerProvider().getInputs().stream().filter(component -> ItemStack.isSameItemSameComponents((ItemStack)component.getItemStack(), (ItemStack)stack) && slotPredicate.test((ItemSlot)component)).forEach(component -> {
                int maxExtract = Math.min(component.getItemStack().getCount(), toRemove.get());
                toRemove.addAndGet(-maxExtract);
                component.getItemStack().shrink(maxExtract);
                removed.getAndAdd(maxExtract);
                if (((ItemStack)extracted.get()).isEmpty()) {
                    extracted.set(((ItemStack)item.get()).copyWithCount(maxExtract));
                } else {
                    ((ItemStack)extracted.get()).grow(maxExtract);
                }
            });
            ((ItemStack)item.get()).shrink(removed.get());
        });
        return extracted.get();
    }

    public void enableChunkload(int radius) {
        this.internal.getComponentManager().getComponent(ComponentRegistration.COMPONENT_CHUNKLOAD.get(), IOType.OUTPUT).map(c -> (ChunkloadComponent)c).map(ChunkloadComponent::getContainerProvider).ifPresent(component -> component.setActive((ServerLevel)this.internal.getLevel(), radius));
    }

    public void disableChunkload() {
        this.internal.getComponentManager().getComponent(ComponentRegistration.COMPONENT_CHUNKLOAD.get(), IOType.OUTPUT).map(c -> (ChunkloadComponent)c).map(ChunkloadComponent::getContainerProvider).ifPresent(component -> component.setInactive((ServerLevel)this.internal.getLevel()));
    }

    public boolean isChunkloadEnabled() {
        return this.internal.getComponentManager().getComponent(ComponentRegistration.COMPONENT_CHUNKLOAD.get(), IOType.OUTPUT).map(c -> (ChunkloadComponent)c).map(ChunkloadComponent::getContainerProvider).map(Chunkloader::isActive).orElse(false);
    }

    public int getChunkloadRadius() {
        return this.internal.getComponentManager().getComponent(ComponentRegistration.COMPONENT_CHUNKLOAD.get(), IOType.OUTPUT).map(c -> (ChunkloadComponent)c).map(ChunkloadComponent::getContainerProvider).map(Chunkloader::getRadius).orElse(0);
    }
}

