/*
 * Decompiled with CFR 0.152.
 */
package es.degrassi.mmreborn.common.crafting.requirement.emi;

import dev.emi.emi.EmiPort;
import dev.emi.emi.api.recipe.EmiRecipe;
import dev.emi.emi.api.recipe.EmiResolutionRecipe;
import dev.emi.emi.api.stack.EmiIngredient;
import dev.emi.emi.config.EmiConfig;
import dev.emi.emi.config.HelpLevel;
import dev.emi.emi.runtime.EmiFavorites;
import dev.emi.emi.screen.tooltip.EmiTooltip;
import dev.emi.emi.screen.tooltip.RecipeCostTooltipComponent;
import es.degrassi.mmreborn.common.crafting.requirement.emi.RecipeHolder;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.client.gui.screens.inventory.tooltip.ClientTooltipComponent;
import net.minecraft.network.chat.Component;
import net.minecraft.util.FormattedCharSequence;

public interface SlotTooltip
extends RecipeHolder {
    default public void addSlotTooltip(List<ClientTooltipComponent> list) {
        EmiRecipe recipe;
        if (this.getStack().getChance() != 1.0f) {
            list.add(EmiTooltip.chance((String)(this.getRecipe() != null ? "produce" : "consume"), (float)this.getStack().getChance()));
        }
        if ((recipe = this.getRecipe()) != null) {
            RecipeCostTooltipComponent rctc;
            if (recipe.getId() != null && EmiConfig.showRecipeIds) {
                list.add(ClientTooltipComponent.create((FormattedCharSequence)EmiPort.ordered((Component)EmiPort.literal((String)recipe.getId().toString(), (ChatFormatting)ChatFormatting.GRAY))));
            }
            if (this.canResolve() && EmiConfig.helpLevel.has(HelpLevel.NORMAL)) {
                if (EmiConfig.viewRecipes.isBound()) {
                    list.add(ClientTooltipComponent.create((FormattedCharSequence)EmiPort.ordered((Component)EmiPort.translatable((String)"emi.resolve.resolve", (Object[])new Object[]{EmiConfig.viewRecipes.getBindText()}))));
                }
                if (EmiConfig.defaultStack.isBound()) {
                    list.add(ClientTooltipComponent.create((FormattedCharSequence)EmiPort.ordered((Component)EmiPort.translatable((String)"emi.resolve.default", (Object[])new Object[]{EmiConfig.defaultStack.getBindText()}))));
                }
            } else if (EmiConfig.favorite.isBound() && EmiConfig.helpLevel.has(HelpLevel.NORMAL) && EmiFavorites.canFavorite((EmiIngredient)this.getStack(), (EmiRecipe)this.getRecipe())) {
                list.add(ClientTooltipComponent.create((FormattedCharSequence)EmiPort.ordered((Component)EmiPort.translatable((String)"emi.favorite_recipe", (Object[])new Object[]{EmiConfig.favorite.getBindText()}))));
            }
            if (EmiConfig.showCostPerBatch && recipe.supportsRecipeTree() && !(recipe instanceof EmiResolutionRecipe) && (rctc = new RecipeCostTooltipComponent(recipe)).shouldDisplay()) {
                list.add((ClientTooltipComponent)rctc);
            }
        }
    }
}

