/*
 * Decompiled with CFR 0.152.
 */
package es.degrassi.mmreborn.common.block;

import es.degrassi.mmreborn.client.container.ItemBusContainer;
import es.degrassi.mmreborn.common.block.BlockMachineComponent;
import es.degrassi.mmreborn.common.block.prop.ItemBusSize;
import es.degrassi.mmreborn.common.entity.ItemInputBusEntity;
import es.degrassi.mmreborn.common.entity.base.TileInventory;
import es.degrassi.mmreborn.common.item.InputBusItem;
import es.degrassi.mmreborn.common.registration.ItemRegistration;
import es.degrassi.mmreborn.common.util.IOInventory;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.ItemInteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.BlockHitResult;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class BlockInputBus
extends BlockMachineComponent {
    private final ItemBusSize size;

    public BlockInputBus(ItemBusSize size) {
        super(BlockBehaviour.Properties.of().dynamicShape().noOcclusion().strength(2.0f, 10.0f).sound(SoundType.METAL));
        this.size = size;
    }

    @Override
    @NotNull
    protected List<ItemStack> getDrops(@NotNull BlockState state, // Could not load outer class - annotation placement on inner may be incorrect
     @NotNull LootParams.Builder builder) {
        List<ItemStack> drops = super.getDrops(state, builder);
        switch (this.size) {
            case TINY: {
                drops.add(((InputBusItem)ItemRegistration.ITEM_INPUT_BUS_TINY.get()).getDefaultInstance());
                break;
            }
            case SMALL: {
                drops.add(((InputBusItem)ItemRegistration.ITEM_INPUT_BUS_SMALL.get()).getDefaultInstance());
                break;
            }
            case NORMAL: {
                drops.add(((InputBusItem)ItemRegistration.ITEM_INPUT_BUS_NORMAL.get()).getDefaultInstance());
                break;
            }
            case REINFORCED: {
                drops.add(((InputBusItem)ItemRegistration.ITEM_INPUT_BUS_REINFORCED.get()).getDefaultInstance());
                break;
            }
            case BIG: {
                drops.add(((InputBusItem)ItemRegistration.ITEM_INPUT_BUS_BIG.get()).getDefaultInstance());
                break;
            }
            case HUGE: {
                drops.add(((InputBusItem)ItemRegistration.ITEM_INPUT_BUS_HUGE.get()).getDefaultInstance());
                break;
            }
            case LUDICROUS: {
                drops.add(((InputBusItem)ItemRegistration.ITEM_INPUT_BUS_LUDICROUS.get()).getDefaultInstance());
            }
        }
        return drops;
    }

    public void playerDestroy(Level level, Player player, BlockPos pos, BlockState state, @Nullable BlockEntity blockEntity, ItemStack tool) {
        BlockEntity te = level.getBlockEntity(pos);
        if (te instanceof TileInventory) {
            TileInventory entity = (TileInventory)te;
            IOInventory inv = entity.getInventory();
            for (int i = 0; i < inv.getSlots(); ++i) {
                ItemStack stack = inv.getStackInSlot(i);
                if (stack.isEmpty()) continue;
                BlockInputBus.popResource((Level)level, (BlockPos)pos, (ItemStack)stack);
                inv.setStackInSlot(i, ItemStack.EMPTY);
            }
        }
        super.playerDestroy(level, player, pos, state, blockEntity, tool);
    }

    public BlockState playerWillDestroy(Level level, BlockPos pos, BlockState state, Player player) {
        if (player.getAbilities().instabuild && level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            BlockEntity blockEntity = level.getBlockEntity(pos);
            if (blockEntity instanceof TileInventory) {
                TileInventory entity = (TileInventory)blockEntity;
                IOInventory inv = entity.getInventory();
                for (int i = 0; i < inv.getSlots(); ++i) {
                    ItemStack stack = inv.getStackInSlot(i);
                    if (stack.isEmpty()) continue;
                    BlockInputBus.popResource((Level)level, (BlockPos)pos, (ItemStack)stack);
                    inv.setStackInSlot(i, ItemStack.EMPTY);
                }
            }
        }
        return super.playerWillDestroy(level, pos, state, player);
    }

    public void appendHoverText(ItemStack pStack, Item.TooltipContext pContext, List<Component> tooltip, TooltipFlag pTooltipFlag) {
        super.appendHoverText(pStack, pContext, tooltip, pTooltipFlag);
        tooltip.add((Component)(this.size.getSlotCount() == 1 ? Component.translatable((String)"tooltip.itembus.slot") : Component.translatable((String)"tooltip.itembus.slots", (Object[])new Object[]{this.size.getSlotCount()})));
    }

    protected ItemInteractionResult useItemOn(ItemStack stack, BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hitResult) {
        BlockEntity te = level.getBlockEntity(pos);
        if (te instanceof ItemInputBusEntity) {
            ItemInputBusEntity entity = (ItemInputBusEntity)te;
            if (player instanceof ServerPlayer) {
                ServerPlayer serverPlayer = (ServerPlayer)player;
                ItemBusContainer.open(serverPlayer, entity);
            }
            return ItemInteractionResult.sidedSuccess((boolean)level.isClientSide);
        }
        return super.useItemOn(stack, state, level, pos, player, hand, hitResult);
    }

    @Override
    @Nullable
    public BlockEntity newBlockEntity(@NotNull BlockPos blockPos, @NotNull BlockState blockState) {
        return new ItemInputBusEntity(blockPos, blockState, this.size);
    }
}

