/*
 * Decompiled with CFR 0.152.
 */
package es.degrassi.mmreborn.client.integration.emi;

import com.google.common.collect.Lists;
import dev.emi.emi.api.stack.EmiIngredient;
import dev.emi.emi.api.stack.EmiStack;
import es.degrassi.mmreborn.api.TagUtil;
import es.degrassi.mmreborn.api.crafting.requirement.RecipeRequirement;
import es.degrassi.mmreborn.api.integration.emi.RegisterEmiComponentEvent;
import es.degrassi.mmreborn.api.integration.emi.RegisterEmiRequirementToIngredientEvent;
import es.degrassi.mmreborn.api.integration.emi.RegisterEmiRequirementToStackEvent;
import es.degrassi.mmreborn.common.crafting.requirement.RequirementFluid;
import es.degrassi.mmreborn.common.crafting.requirement.RequirementItem;
import es.degrassi.mmreborn.common.crafting.requirement.RequirementLootTable;
import es.degrassi.mmreborn.common.crafting.requirement.emi.EmiBiomeComponent;
import es.degrassi.mmreborn.common.crafting.requirement.emi.EmiChunkloadComponent;
import es.degrassi.mmreborn.common.crafting.requirement.emi.EmiDimensionComponent;
import es.degrassi.mmreborn.common.crafting.requirement.emi.EmiEnergyComponent;
import es.degrassi.mmreborn.common.crafting.requirement.emi.EmiExperienceComponent;
import es.degrassi.mmreborn.common.crafting.requirement.emi.EmiFluidComponent;
import es.degrassi.mmreborn.common.crafting.requirement.emi.EmiHeightComponent;
import es.degrassi.mmreborn.common.crafting.requirement.emi.EmiItemComponent;
import es.degrassi.mmreborn.common.crafting.requirement.emi.EmiLootTableComponent;
import es.degrassi.mmreborn.common.crafting.requirement.emi.EmiTimeComponent;
import es.degrassi.mmreborn.common.crafting.requirement.emi.EmiWeatherComponent;
import es.degrassi.mmreborn.common.integration.emi.EmiComponentRegistry;
import es.degrassi.mmreborn.common.integration.emi.EmiIngredientRegistry;
import es.degrassi.mmreborn.common.integration.emi.EmiStackRegistry;
import es.degrassi.mmreborn.common.machine.component.ItemComponent;
import es.degrassi.mmreborn.common.registration.RequirementTypeRegistration;
import es.degrassi.mmreborn.common.util.LootTableHelper;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.material.Fluid;
import net.neoforged.bus.api.IEventBus;
import net.neoforged.bus.api.SubscribeEvent;

public class MMREmiClientIntegration {
    public MMREmiClientIntegration(IEventBus bus) {
        bus.register((Object)this);
        EmiComponentRegistry.init();
        EmiStackRegistry.init();
        EmiIngredientRegistry.init();
    }

    @SubscribeEvent
    public void registerEmiComponents(RegisterEmiComponentEvent event) {
        event.register(RequirementTypeRegistration.ENERGY.get(), EmiEnergyComponent::new);
        event.register(RequirementTypeRegistration.EXPERIENCE.get(), EmiExperienceComponent::new);
        event.register(RequirementTypeRegistration.ITEM.get(), EmiItemComponent::new);
        event.register(RequirementTypeRegistration.FLUID.get(), EmiFluidComponent::new);
        event.register(RequirementTypeRegistration.BIOME.get(), EmiBiomeComponent::new);
        event.register(RequirementTypeRegistration.TIME.get(), EmiTimeComponent::new);
        event.register(RequirementTypeRegistration.HEIGHT.get(), EmiHeightComponent::new);
        event.register(RequirementTypeRegistration.CHUNKLOAD.get(), EmiChunkloadComponent::new);
        event.register(RequirementTypeRegistration.DIMENSION.get(), EmiDimensionComponent::new);
        event.register(RequirementTypeRegistration.WEATHER.get(), EmiWeatherComponent::new);
        event.register(RequirementTypeRegistration.LOOT_TABLE.get(), EmiLootTableComponent::new);
    }

    @SubscribeEvent
    public void registerEmiStacks(RegisterEmiRequirementToStackEvent event) {
        event.register(RequirementTypeRegistration.ITEM.get(), this::emiStackFromItemRequirement);
        event.register(RequirementTypeRegistration.FLUID.get(), requirement -> List.of(EmiStack.of((Fluid)((RequirementFluid)requirement.requirement()).required.asFluidStack().getFluid(), (long)((RequirementFluid)requirement.requirement()).amount)));
        event.register(RequirementTypeRegistration.LOOT_TABLE.get(), requirement -> LootTableHelper.getLootsForTable(((RequirementLootTable)requirement.requirement()).getLootTable()).stream().map(LootTableHelper.LootData::stack).map(EmiStack::of).toList());
    }

    @SubscribeEvent
    public void registerEmiIngredients(RegisterEmiRequirementToIngredientEvent event) {
        event.register(RequirementTypeRegistration.ITEM.get(), this::emiIngredientFromItemRequirement);
    }

    private EmiIngredient emiIngredientFromItemRequirement(RecipeRequirement<ItemComponent, RequirementItem> requirement) {
        return EmiIngredient.of((Ingredient)requirement.requirement().ingredient.ingredient(), (long)requirement.requirement().ingredient.count());
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private List<EmiStack> emiStackFromItemRequirement(RecipeRequirement<ItemComponent, RequirementItem> requirement) {
        ArrayList stacks = Lists.newArrayList();
        Ingredient.Value[] valueArray = requirement.requirement().getIngredient().ingredient().values;
        int n = valueArray.length;
        int n2 = 0;
        while (n2 < n) {
            Ingredient.Value value = valueArray[n2];
            if (value instanceof Ingredient.TagValue) {
                Ingredient.TagValue tagValue = (Ingredient.TagValue)value;
                try {
                    object = tagValue.tag();
                    TagKey tag = object;
                    object = TagUtil.getItems((TagKey<Item>)tag).toList().iterator();
                }
                catch (Throwable throwable) {
                    throw new MatchException(throwable.toString(), throwable);
                }
                while (object.hasNext()) {
                    Item stack = (Item)object.next();
                    stacks.add(EmiStack.of((ItemLike)stack, (long)requirement.requirement().ingredient.count()));
                }
            } else if (value instanceof Ingredient.ItemValue) {
                Ingredient.ItemValue itemValue = (Ingredient.ItemValue)value;
                {
                    object = itemValue.item();
                    TagKey item = object;
                    stacks.add(EmiStack.of((ItemStack)item, (long)requirement.requirement().ingredient.count()));
                }
            }
            ++n2;
        }
        return stacks;
    }
}

