/*
 * Decompiled with CFR 0.152.
 */
package es.degrassi.mmreborn.api;

import com.google.common.base.Suppliers;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.mojang.datafixers.util.Either;
import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.JsonOps;
import es.degrassi.mmreborn.api.IIngredient;
import es.degrassi.mmreborn.api.PartialBlockState;
import es.degrassi.mmreborn.api.TagUtil;
import es.degrassi.mmreborn.api.codec.NamedCodec;
import es.degrassi.mmreborn.common.util.Utils;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import lombok.Generated;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.StringTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.state.BlockBehaviour;

public class BlockIngredient
implements IIngredient<PartialBlockState> {
    public static final BlockIngredient AIR = new BlockIngredient(PartialBlockState.AIR);
    public static final BlockIngredient ANY = new BlockIngredient(PartialBlockState.ANY);
    public static final BlockIngredient MACHINE = new BlockIngredient(PartialBlockState.MACHINE);
    public static final NamedCodec<BlockIngredient> TAG_CODEC = NamedCodec.STRING.comapFlatMap(string -> {
        try {
            return DataResult.success((Object)BlockIngredient.create(string));
        }
        catch (IllegalArgumentException e) {
            return DataResult.error(e::getMessage);
        }
    }, BlockIngredient::getString, "BlockIngredient with tag");
    public static final NamedCodec<BlockIngredient> CODEC = NamedCodec.either(PartialBlockState.CODEC, TAG_CODEC, "Block Ingredient").listOf().flatComapMap(list -> {
        ArrayList ings = Lists.newArrayList();
        list.forEach(either -> ings.add((BlockIngredient)either.map(BlockIngredient::new, Function.identity())));
        AtomicReference<Object> ing = new AtomicReference<Object>(null);
        ings.iterator().forEachRemaining(i -> {
            if (ing.get() == null) {
                ing.set(i);
                return;
            }
            ing.set(((BlockIngredient)ing.get()).merge((BlockIngredient)i));
        });
        return ing.get();
    }, ing -> {
        ArrayList list = Lists.newArrayList();
        list.add(Either.right((Object)ing));
        return DataResult.success((Object)list);
    }, "Block Ingredient");
    private final Supplier<List<PartialBlockState>> partialBlockStates;
    private final boolean isTag;
    private List<TagKey<Block>> tags = Lists.newArrayList();

    public BlockIngredient(List<TagKey<Block>> tags, List<PartialBlockState> states) {
        ArrayList statesCopy = Lists.newArrayList(states);
        boolean bl = this.isTag = !tags.isEmpty();
        if (this.isTag) {
            this.tags.addAll(tags);
            tags.forEach(tag -> statesCopy.addAll(TagUtil.getBlocks((TagKey<Block>)tag).map(PartialBlockState::new).toList()));
        }
        this.partialBlockStates = Suppliers.memoize(() -> ImmutableList.copyOf((Collection)statesCopy));
    }

    public BlockIngredient(PartialBlockState partialBlockState) {
        this(Collections.emptyList(), Collections.singletonList(partialBlockState));
    }

    public static BlockIngredient create(String s) throws IllegalArgumentException {
        if (s.startsWith("[")) {
            s = s.endsWith("]") ? s.substring(1, s.length() - 1) : s.substring(1);
        }
        String[] arr = s.split(", ");
        ArrayList tags = Lists.newArrayList();
        ArrayList states = Lists.newArrayList();
        Arrays.asList(arr).forEach(string -> {
            if (string.startsWith("#")) {
                if (!Utils.isResourceNameValid(string = string.substring(1))) {
                    throw new IllegalArgumentException(String.format("Invalid tag id : %s", string));
                }
                tags.add(TagKey.create((ResourceKey)Registries.BLOCK, (ResourceLocation)ResourceLocation.parse((String)string)));
            } else {
                try {
                    DataResult result = PartialBlockState.CODEC.decode(JsonOps.INSTANCE, JsonOps.INSTANCE.createString(string)).map(Pair::getFirst);
                    states.add((PartialBlockState)result.getOrThrow());
                }
                catch (Exception exception) {
                    throw new IllegalArgumentException(String.format("Invalid block id: %s", string));
                }
            }
        });
        if (tags.isEmpty() && states.isEmpty()) {
            throw new IllegalArgumentException("Invalid tags or states provided, expected min size of 1");
        }
        return new BlockIngredient(tags, states);
    }

    public BlockIngredient copy() {
        return new BlockIngredient(this.tags.stream().map(TagKey::location).map(tag -> TagKey.create((ResourceKey)BuiltInRegistries.BLOCK.key(), (ResourceLocation)tag)).toList(), this.partialBlockStates.get().stream().map(PartialBlockState::copy).toList());
    }

    @Override
    public List<PartialBlockState> getAll() {
        return this.partialBlockStates.get();
    }

    @Override
    public boolean test(PartialBlockState partialBlockState) {
        return this.partialBlockStates.get().stream().anyMatch(state -> state.getBlockState() == partialBlockState.getBlockState());
    }

    public List<ItemStack> getStacks(int amount) {
        List<ItemStack> stacks = this.getTagStacks(amount);
        stacks.addAll(this.getNonTagStacks(amount));
        return stacks.stream().collect(Collectors.groupingBy(ItemStack::getItem, Collectors.summingInt(ItemStack::getCount))).entrySet().stream().map(entry -> new ItemStack((ItemLike)entry.getKey(), ((Integer)entry.getValue()).intValue())).toList();
    }

    public List<ItemStack> getNonTagStacks(int amount) {
        return this.uniqueStates().map(PartialBlockState::getBlockState).map(BlockBehaviour.BlockStateBase::getBlock).map(Block::asItem).map(Item::getDefaultInstance).map(stack -> stack.copyWithCount(amount)).toList();
    }

    public List<ItemStack> getTagStacks(int amount) {
        return Lists.newArrayList(this.getTags().stream().flatMap(TagUtil::getBlocks).map(Block::asItem).map(Item::getDefaultInstance).map(stack -> stack.copyWithCount(amount)).iterator());
    }

    public Stream<PartialBlockState> uniqueStates() {
        return this.getAll().stream().filter(state -> this.tags.stream().noneMatch(tag -> state.getBlockState().is(tag)));
    }

    public List<Component> getNames() {
        ArrayList ingredients = Lists.newArrayList();
        ingredients.addAll(this.tags.stream().map(TagKey::location).map(ResourceLocation::toString).map(s -> "#" + s).map(Component::literal).toList());
        ingredients.addAll(this.uniqueStates().map(PartialBlockState::getName).toList());
        return ingredients;
    }

    public boolean isNotAir() {
        return !this.equals(AIR) && this.getAll().stream().noneMatch(state -> state.equals(PartialBlockState.AIR));
    }

    public boolean isNotAny() {
        return !this.equals(ANY) && this.getAll().stream().noneMatch(state -> state.equals(PartialBlockState.ANY));
    }

    public boolean isNotMachine() {
        return !this.equals(MACHINE) && this.getAll().stream().noneMatch(state -> state.equals(PartialBlockState.MACHINE));
    }

    public MutableComponent getNamesUnified() {
        MutableComponent name = Component.empty();
        MutableComponent last = Component.empty();
        Iterator<Component> iterator = this.getNames().iterator();
        if (this.getNames().size() > 1) {
            name.append("[");
            last.append("]");
        }
        while (iterator.hasNext()) {
            Component current = iterator.next();
            name.append(current);
            if (!iterator.hasNext()) continue;
            name.append(", ");
        }
        name.append((Component)last);
        return name;
    }

    public String getString() {
        ArrayList ingredients = Lists.newArrayList();
        ingredients.addAll(this.tags.stream().map(TagKey::location).map(ResourceLocation::toString).map(s -> "#" + s).toList());
        ingredients.addAll(this.uniqueStates().map(PartialBlockState::toString).toList());
        if (ingredients.size() == 1) {
            return (String)ingredients.get(0);
        }
        return ((Object)ingredients).toString();
    }

    public String toString() {
        return this.asJson().toString();
    }

    public BlockIngredient copyWithRotation(Rotation rotation) {
        return new BlockIngredient(this.tags, this.getAll().stream().map(state -> state.copyWithRotation(rotation)).toList());
    }

    public BlockIngredient merge(BlockIngredient other) {
        if (other == null) {
            return AIR.merge(this);
        }
        ArrayList ingredients = Lists.newArrayList();
        ingredients.addAll(this.getAll());
        ingredients.addAll(other.getAll());
        ArrayList tags = Lists.newArrayList();
        tags.addAll(this.tags);
        tags.addAll(other.tags);
        return new BlockIngredient(tags, ingredients);
    }

    @Override
    public JsonObject asJson() {
        JsonObject json = new JsonObject();
        json.addProperty("isTag", Boolean.valueOf(this.isTag));
        json.addProperty("tags", this.tags.toString());
        JsonArray array = new JsonArray();
        this.getAll().forEach(state -> array.add(state.toString()));
        json.add("states", (JsonElement)array);
        return json;
    }

    public CompoundTag asTag() {
        CompoundTag tag = new CompoundTag();
        tag.putBoolean("isTag", this.isTag);
        ListTag tagList = new ListTag();
        this.tags.forEach(t -> tagList.add((Object)StringTag.valueOf((String)t.toString())));
        tag.put("tags", (Tag)tagList);
        ListTag states = new ListTag();
        this.getAll().forEach(state -> states.add((Object)StringTag.valueOf((String)state.toString())));
        tag.put("states", (Tag)states);
        return tag;
    }

    public static BlockIngredient of(Object o) {
        return (BlockIngredient)o;
    }

    public boolean equals(Object o) {
        if (!(o instanceof BlockIngredient)) {
            return false;
        }
        BlockIngredient that = (BlockIngredient)o;
        return this.isTag == that.isTag && Objects.equals(this.partialBlockStates, that.partialBlockStates) && Objects.equals(this.tags, that.tags);
    }

    public int hashCode() {
        return Objects.hash(this.partialBlockStates, this.isTag, this.tags);
    }

    @Generated
    public boolean isTag() {
        return this.isTag;
    }

    @Generated
    public List<TagKey<Block>> getTags() {
        return this.tags;
    }

    @Generated
    public void setTags(List<TagKey<Block>> tags) {
        this.tags = tags;
    }
}

