/*
 * Decompiled with CFR 0.152.
 */
package com.iafenvoy.iceandfire.screen.handler;

import com.iafenvoy.iceandfire.registry.IafScreenHandlers;
import net.minecraft.world.Container;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;

public class PodiumScreenHandler
extends AbstractContainerMenu {
    public final Container podium;

    public PodiumScreenHandler(int i, Inventory playerInventory) {
        this(i, (Container)new SimpleContainer(1), playerInventory);
    }

    public PodiumScreenHandler(int id, Container furnaceInventory, Inventory playerInventory) {
        super((MenuType)IafScreenHandlers.PODIUM_SCREEN.get(), id);
        int i;
        this.podium = furnaceInventory;
        furnaceInventory.startOpen(playerInventory.player);
        int b0 = 51;
        this.addSlot(new Slot(furnaceInventory, 0, 80, 20));
        for (i = 0; i < 3; ++i) {
            for (int j = 0; j < 9; ++j) {
                this.addSlot(new Slot((Container)playerInventory, j + i * 9 + 9, 8 + j * 18, i * 18 + b0));
            }
        }
        for (i = 0; i < 9; ++i) {
            this.addSlot(new Slot((Container)playerInventory, i, 8 + i * 18, 58 + b0));
        }
    }

    public boolean stillValid(Player playerIn) {
        return this.podium.stillValid(playerIn);
    }

    public ItemStack quickMoveStack(Player playerIn, int index) {
        ItemStack itemstack = ItemStack.EMPTY;
        Slot slot = (Slot)this.slots.get(index);
        if (slot.hasItem()) {
            ItemStack itemstack1 = slot.getItem();
            itemstack = itemstack1.copy();
            if (index < this.podium.getContainerSize() ? !this.moveItemStackTo(itemstack1, this.podium.getContainerSize(), this.slots.size(), true) : !this.moveItemStackTo(itemstack1, 0, this.podium.getContainerSize(), false)) {
                return ItemStack.EMPTY;
            }
            if (itemstack1.isEmpty()) {
                slot.set(ItemStack.EMPTY);
            } else {
                slot.setChanged();
            }
        }
        return itemstack;
    }

    public void removed(Player playerIn) {
        super.removed(playerIn);
        this.podium.stopOpen(playerIn);
    }
}

