/*
 * Decompiled with CFR 0.152.
 */
package com.iafenvoy.iceandfire.render.entity.layer;

import com.iafenvoy.iceandfire.IceAndFire;
import com.iafenvoy.iceandfire.data.DragonColor;
import com.iafenvoy.iceandfire.entity.EntityDragonBase;
import com.iafenvoy.iceandfire.entity.EntityIceDragon;
import com.iafenvoy.iceandfire.entity.EntityLightningDragon;
import com.iafenvoy.uranus.client.model.AdvancedModelBox;
import com.iafenvoy.uranus.client.model.TabulaModel;
import com.iafenvoy.uranus.client.model.util.TabulaModelHandlerHelper;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.MobRenderer;
import net.minecraft.client.renderer.entity.layers.RenderLayer;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.resources.ResourceLocation;

public class LayerDragonEyes
extends RenderLayer<EntityDragonBase, TabulaModel<EntityDragonBase>> {
    private TabulaModel<EntityDragonBase> fireHead;
    private TabulaModel<EntityDragonBase> iceHead;
    private TabulaModel<EntityDragonBase> lightningHead;

    public LayerDragonEyes(MobRenderer<EntityDragonBase, TabulaModel<EntityDragonBase>> renderIn) {
        super(renderIn);
        try {
            this.fireHead = this.onlyKeepCubes((TabulaModel<EntityDragonBase>)TabulaModelHandlerHelper.getModel((ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"iceandfire", (String)"firedragon/firedragon_ground"), null), Collections.singletonList("HeadFront"));
            this.iceHead = this.onlyKeepCubes((TabulaModel<EntityDragonBase>)TabulaModelHandlerHelper.getModel((ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"iceandfire", (String)"icedragon/icedragon_ground"), null), Collections.singletonList("HeadFront"));
            this.lightningHead = this.onlyKeepCubes((TabulaModel<EntityDragonBase>)TabulaModelHandlerHelper.getModel((ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"iceandfire", (String)"lightningdragon/lightningdragon_ground"), null), Collections.singletonList("HeadFront"));
        }
        catch (Exception e) {
            IceAndFire.LOGGER.error((Object)e);
        }
    }

    public void render(PoseStack matrixStackIn, MultiBufferSource bufferIn, int packedLightIn, EntityDragonBase dragon, float limbSwing, float limbSwingAmount, float partialTicks, float ageInTicks, float netHeadYaw, float headPitch) {
        if (dragon.shouldRenderEyes()) {
            RenderType eyes = RenderType.eyes((ResourceLocation)DragonColor.getById(dragon.getVariant()).getEyesTexture(dragon.getDragonStage()));
            VertexConsumer ivertexbuilder = bufferIn.getBuffer(eyes);
            if (dragon instanceof EntityLightningDragon && this.lightningHead != null) {
                this.copyPositions(this.lightningHead, (TabulaModel<EntityDragonBase>)((TabulaModel)this.getParentModel()));
                this.lightningHead.renderToBuffer(matrixStackIn, ivertexbuilder, packedLightIn, OverlayTexture.NO_OVERLAY, -1);
            } else if (dragon instanceof EntityIceDragon && this.iceHead != null) {
                this.copyPositions(this.iceHead, (TabulaModel<EntityDragonBase>)((TabulaModel)this.getParentModel()));
                this.iceHead.renderToBuffer(matrixStackIn, ivertexbuilder, packedLightIn, OverlayTexture.NO_OVERLAY, -1);
            } else if (this.fireHead != null) {
                this.copyPositions(this.fireHead, (TabulaModel<EntityDragonBase>)((TabulaModel)this.getParentModel()));
                this.fireHead.renderToBuffer(matrixStackIn, ivertexbuilder, packedLightIn, OverlayTexture.NO_OVERLAY, -1);
            } else {
                ((TabulaModel)this.getParentModel()).renderToBuffer(matrixStackIn, ivertexbuilder, packedLightIn, OverlayTexture.NO_OVERLAY, -1);
            }
        }
    }

    protected ResourceLocation getTexture(EntityDragonBase entityIn) {
        return null;
    }

    private TabulaModel<EntityDragonBase> onlyKeepCubes(TabulaModel<EntityDragonBase> model, List<String> strings) {
        ArrayList<AdvancedModelBox> keepCubes = new ArrayList<AdvancedModelBox>();
        for (String str : strings) {
            AdvancedModelBox cube = model.getCube(str);
            keepCubes.add(cube);
            while (cube.getParent() != null) {
                keepCubes.add(cube.getParent());
                cube = cube.getParent();
            }
        }
        this.removeChildren(model, keepCubes);
        model.getCubes().values().removeIf(advancedModelBox -> !keepCubes.contains(advancedModelBox));
        return model;
    }

    private void removeChildren(TabulaModel<EntityDragonBase> model, List<AdvancedModelBox> keepCubes) {
        model.getRootBox().forEach(modelRenderer -> {
            modelRenderer.childModels.removeIf(child -> !keepCubes.contains(child));
            modelRenderer.childModels.forEach(childModel -> this.removeChildren((AdvancedModelBox)childModel, keepCubes));
        });
    }

    private void removeChildren(AdvancedModelBox modelBox, List<AdvancedModelBox> keepCubes) {
        modelBox.childModels.removeIf(modelRenderer -> !keepCubes.contains(modelRenderer));
        modelBox.childModels.forEach(modelRenderer -> this.removeChildren((AdvancedModelBox)modelRenderer, keepCubes));
    }

    public boolean isAngleEqual(AdvancedModelBox original, AdvancedModelBox pose) {
        return pose != null && pose.rotateAngleX == original.rotateAngleX && pose.rotateAngleY == original.rotateAngleY && pose.rotateAngleZ == original.rotateAngleZ;
    }

    public boolean isPositionEqual(AdvancedModelBox original, AdvancedModelBox pose) {
        return pose.rotationPointX == original.rotationPointX && pose.rotationPointY == original.rotationPointY && pose.rotationPointZ == original.rotationPointZ;
    }

    public void copyPositions(TabulaModel<EntityDragonBase> model, TabulaModel<EntityDragonBase> modelTo) {
        for (AdvancedModelBox cube : model.getCubes().values()) {
            AdvancedModelBox modelToCube;
            if (!this.isAngleEqual(cube, modelToCube = modelTo.getCube(cube.boxName))) {
                cube.rotateAngleX = modelToCube.rotateAngleX;
                cube.rotateAngleY = modelToCube.rotateAngleY;
                cube.rotateAngleZ = modelToCube.rotateAngleZ;
            }
            if (this.isPositionEqual(cube, modelToCube)) continue;
            cube.rotationPointX = modelToCube.rotationPointX;
            cube.rotationPointY = modelToCube.rotationPointY;
            cube.rotationPointZ = modelToCube.rotationPointZ;
        }
    }
}

