/*
 * Decompiled with CFR 0.152.
 */
package com.iafenvoy.iceandfire.registry;

import com.iafenvoy.iceandfire.config.IafCommonConfig;
import com.iafenvoy.iceandfire.entity.EntityAmphithere;
import com.iafenvoy.iceandfire.entity.EntityAmphithereArrow;
import com.iafenvoy.iceandfire.entity.EntityChainTie;
import com.iafenvoy.iceandfire.entity.EntityCockatrice;
import com.iafenvoy.iceandfire.entity.EntityCockatriceEgg;
import com.iafenvoy.iceandfire.entity.EntityCyclops;
import com.iafenvoy.iceandfire.entity.EntityCyclopsEye;
import com.iafenvoy.iceandfire.entity.EntityDeathWorm;
import com.iafenvoy.iceandfire.entity.EntityDeathWormEgg;
import com.iafenvoy.iceandfire.entity.EntityDragonArrow;
import com.iafenvoy.iceandfire.entity.EntityDragonBase;
import com.iafenvoy.iceandfire.entity.EntityDragonEgg;
import com.iafenvoy.iceandfire.entity.EntityDragonFireCharge;
import com.iafenvoy.iceandfire.entity.EntityDragonIceCharge;
import com.iafenvoy.iceandfire.entity.EntityDragonLightningCharge;
import com.iafenvoy.iceandfire.entity.EntityDragonPart;
import com.iafenvoy.iceandfire.entity.EntityDragonSkull;
import com.iafenvoy.iceandfire.entity.EntityDreadBeast;
import com.iafenvoy.iceandfire.entity.EntityDreadGhoul;
import com.iafenvoy.iceandfire.entity.EntityDreadHorse;
import com.iafenvoy.iceandfire.entity.EntityDreadKnight;
import com.iafenvoy.iceandfire.entity.EntityDreadLich;
import com.iafenvoy.iceandfire.entity.EntityDreadLichSkull;
import com.iafenvoy.iceandfire.entity.EntityDreadScuttler;
import com.iafenvoy.iceandfire.entity.EntityDreadThrall;
import com.iafenvoy.iceandfire.entity.EntityFireDragon;
import com.iafenvoy.iceandfire.entity.EntityGhost;
import com.iafenvoy.iceandfire.entity.EntityGhostSword;
import com.iafenvoy.iceandfire.entity.EntityGorgon;
import com.iafenvoy.iceandfire.entity.EntityHippocampus;
import com.iafenvoy.iceandfire.entity.EntityHippogryph;
import com.iafenvoy.iceandfire.entity.EntityHippogryphEgg;
import com.iafenvoy.iceandfire.entity.EntityHydra;
import com.iafenvoy.iceandfire.entity.EntityHydraArrow;
import com.iafenvoy.iceandfire.entity.EntityHydraBreath;
import com.iafenvoy.iceandfire.entity.EntityHydraHead;
import com.iafenvoy.iceandfire.entity.EntityIceDragon;
import com.iafenvoy.iceandfire.entity.EntityLightningDragon;
import com.iafenvoy.iceandfire.entity.EntityMobSkull;
import com.iafenvoy.iceandfire.entity.EntityPixie;
import com.iafenvoy.iceandfire.entity.EntityPixieCharge;
import com.iafenvoy.iceandfire.entity.EntitySeaSerpent;
import com.iafenvoy.iceandfire.entity.EntitySeaSerpentArrow;
import com.iafenvoy.iceandfire.entity.EntitySeaSerpentBubbles;
import com.iafenvoy.iceandfire.entity.EntitySiren;
import com.iafenvoy.iceandfire.entity.EntitySlowPart;
import com.iafenvoy.iceandfire.entity.EntityStoneStatue;
import com.iafenvoy.iceandfire.entity.EntityStymphalianArrow;
import com.iafenvoy.iceandfire.entity.EntityStymphalianBird;
import com.iafenvoy.iceandfire.entity.EntityStymphalianFeather;
import com.iafenvoy.iceandfire.entity.EntityTideTrident;
import com.iafenvoy.iceandfire.entity.EntityTroll;
import com.iafenvoy.iceandfire.registry.tag.IafBiomeTags;
import dev.architectury.platform.Platform;
import dev.architectury.registry.level.biome.BiomeModifications;
import dev.architectury.registry.level.entity.EntityAttributeRegistry;
import dev.architectury.registry.registries.DeferredRegister;
import dev.architectury.registry.registries.RegistrySupplier;
import java.util.function.Supplier;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobCategory;
import net.minecraft.world.entity.SpawnPlacementType;
import net.minecraft.world.entity.SpawnPlacementTypes;
import net.minecraft.world.entity.SpawnPlacements;
import net.minecraft.world.level.biome.MobSpawnSettings;
import net.minecraft.world.level.levelgen.Heightmap;

public final class IafEntities {
    public static final DeferredRegister<EntityType<?>> REGISTRY = DeferredRegister.create((String)"iceandfire", (ResourceKey)Registries.ENTITY_TYPE);
    public static final RegistrySupplier<EntityType<EntityDragonPart>> DRAGON_MULTIPART = IafEntities.build("dragon_multipart", EntityDragonPart::new, MobCategory.MISC, true, 0.5f, 0.5f);
    public static final RegistrySupplier<EntityType<EntitySlowPart>> SLOW_MULTIPART = IafEntities.build("multipart", EntitySlowPart::new, MobCategory.MISC, true, 0.5f, 0.5f);
    public static final RegistrySupplier<EntityType<EntityHydraHead>> HYDRA_MULTIPART = IafEntities.build("hydra_multipart", EntityHydraHead::new, MobCategory.MISC, true, 0.5f, 0.5f);
    public static final RegistrySupplier<EntityType<EntityCyclopsEye>> CYCLOPS_MULTIPART = IafEntities.build("cylcops_multipart", EntityCyclopsEye::new, MobCategory.MISC, true, 0.5f, 0.5f);
    public static final RegistrySupplier<EntityType<EntityDragonEgg>> DRAGON_EGG = IafEntities.build("dragon_egg", EntityDragonEgg::new, MobCategory.MISC, true, 0.45f, 0.55f);
    public static final RegistrySupplier<EntityType<EntityDragonArrow>> DRAGON_ARROW = IafEntities.build("dragon_arrow", EntityDragonArrow::new, MobCategory.MISC, false, 0.5f, 0.5f);
    public static final RegistrySupplier<EntityType<EntityDragonSkull>> DRAGON_SKULL = IafEntities.build("dragon_skull", EntityDragonSkull::new, MobCategory.MISC, false, 0.9f, 0.65f);
    public static final RegistrySupplier<EntityType<EntityFireDragon>> FIRE_DRAGON = IafEntities.build("fire_dragon", EntityFireDragon::new, MobCategory.CREATURE, true, 0.78f, 1.2f, 256);
    public static final RegistrySupplier<EntityType<EntityIceDragon>> ICE_DRAGON = IafEntities.build("ice_dragon", EntityIceDragon::new, MobCategory.CREATURE, false, 0.78f, 1.2f, 256);
    public static final RegistrySupplier<EntityType<EntityLightningDragon>> LIGHTNING_DRAGON = IafEntities.build("lightning_dragon", EntityLightningDragon::new, MobCategory.CREATURE, false, 0.78f, 1.2f, 256);
    public static final RegistrySupplier<EntityType<EntityDragonFireCharge>> FIRE_DRAGON_CHARGE = IafEntities.build("fire_dragon_charge", EntityDragonFireCharge::new, MobCategory.MISC, false, 0.9f, 0.9f);
    public static final RegistrySupplier<EntityType<EntityDragonIceCharge>> ICE_DRAGON_CHARGE = IafEntities.build("ice_dragon_charge", EntityDragonIceCharge::new, MobCategory.MISC, false, 0.9f, 0.9f);
    public static final RegistrySupplier<EntityType<EntityDragonLightningCharge>> LIGHTNING_DRAGON_CHARGE = IafEntities.build("lightning_dragon_charge", EntityDragonLightningCharge::new, MobCategory.MISC, false, 0.9f, 0.9f);
    public static final RegistrySupplier<EntityType<EntityHippogryphEgg>> HIPPOGRYPH_EGG = IafEntities.build("hippogryph_egg", EntityHippogryphEgg::new, MobCategory.MISC, false, 0.5f, 0.5f);
    public static final RegistrySupplier<EntityType<EntityHippogryph>> HIPPOGRYPH = IafEntities.build("hippogryph", EntityHippogryph::new, MobCategory.CREATURE, false, 1.7f, 1.6f, 128);
    public static final RegistrySupplier<EntityType<EntityStoneStatue>> STONE_STATUE = IafEntities.build("stone_statue", EntityStoneStatue::new, MobCategory.CREATURE, false, 0.5f, 0.5f);
    public static final RegistrySupplier<EntityType<EntityGorgon>> GORGON = IafEntities.build("gorgon", EntityGorgon::new, MobCategory.CREATURE, false, 0.8f, 1.99f);
    public static final RegistrySupplier<EntityType<EntityPixie>> PIXIE = IafEntities.build("pixie", EntityPixie::new, MobCategory.CREATURE, false, 0.4f, 0.8f);
    public static final RegistrySupplier<EntityType<EntityCyclops>> CYCLOPS = IafEntities.build("cyclops", EntityCyclops::new, MobCategory.CREATURE, false, 1.95f, 7.4f);
    public static final RegistrySupplier<EntityType<EntitySiren>> SIREN = IafEntities.build("siren", EntitySiren::new, MobCategory.CREATURE, false, 1.6f, 0.9f);
    public static final RegistrySupplier<EntityType<EntityHippocampus>> HIPPOCAMPUS = IafEntities.build("hippocampus", EntityHippocampus::new, MobCategory.WATER_CREATURE, false, 1.95f, 0.95f);
    public static final RegistrySupplier<EntityType<EntityDeathWorm>> DEATH_WORM = IafEntities.build("deathworm", EntityDeathWorm::new, MobCategory.CREATURE, false, 0.8f, 0.8f, 128);
    public static final RegistrySupplier<EntityType<EntityDeathWormEgg>> DEATH_WORM_EGG = IafEntities.build("deathworm_egg", EntityDeathWormEgg::new, MobCategory.MISC, false, 0.5f, 0.5f);
    public static final RegistrySupplier<EntityType<EntityCockatrice>> COCKATRICE = IafEntities.build("cockatrice", EntityCockatrice::new, MobCategory.CREATURE, false, 1.1f, 1.0f);
    public static final RegistrySupplier<EntityType<EntityCockatriceEgg>> COCKATRICE_EGG = IafEntities.build("cockatrice_egg", EntityCockatriceEgg::new, MobCategory.MISC, false, 0.5f, 0.5f);
    public static final RegistrySupplier<EntityType<EntityStymphalianBird>> STYMPHALIAN_BIRD = IafEntities.build("stymphalian_bird", EntityStymphalianBird::new, MobCategory.CREATURE, false, 1.3f, 1.2f, 128);
    public static final RegistrySupplier<EntityType<EntityStymphalianFeather>> STYMPHALIAN_FEATHER = IafEntities.build("stymphalian_feather", EntityStymphalianFeather::new, MobCategory.MISC, false, 0.5f, 0.5f);
    public static final RegistrySupplier<EntityType<EntityStymphalianArrow>> STYMPHALIAN_ARROW = IafEntities.build("stymphalian_arrow", EntityStymphalianArrow::new, MobCategory.MISC, false, 0.5f, 0.5f);
    public static final RegistrySupplier<EntityType<EntityTroll>> TROLL = IafEntities.build("troll", EntityTroll::new, MobCategory.MONSTER, false, 1.2f, 3.5f);
    public static final RegistrySupplier<EntityType<EntityAmphithere>> AMPHITHERE = IafEntities.build("amphithere", EntityAmphithere::new, MobCategory.CREATURE, false, 2.5f, 1.25f, 128);
    public static final RegistrySupplier<EntityType<EntityAmphithereArrow>> AMPHITHERE_ARROW = IafEntities.build("amphithere_arrow", EntityAmphithereArrow::new, MobCategory.MISC, false, 0.5f, 0.5f);
    public static final RegistrySupplier<EntityType<EntitySeaSerpent>> SEA_SERPENT = IafEntities.build("sea_serpent", EntitySeaSerpent::new, MobCategory.CREATURE, false, 0.5f, 0.5f, 256);
    public static final RegistrySupplier<EntityType<EntitySeaSerpentBubbles>> SEA_SERPENT_BUBBLES = IafEntities.build("sea_serpent_bubbles", EntitySeaSerpentBubbles::new, MobCategory.MISC, false, 0.9f, 0.9f);
    public static final RegistrySupplier<EntityType<EntitySeaSerpentArrow>> SEA_SERPENT_ARROW = IafEntities.build("sea_serpent_arrow", EntitySeaSerpentArrow::new, MobCategory.MISC, false, 0.5f, 0.5f);
    public static final RegistrySupplier<EntityType<EntityChainTie>> CHAIN_TIE = IafEntities.build("chain_tie", EntityChainTie::new, MobCategory.MISC, false, 0.8f, 0.9f);
    public static final RegistrySupplier<EntityType<EntityPixieCharge>> PIXIE_CHARGE = IafEntities.build("pixie_charge", EntityPixieCharge::new, MobCategory.MISC, false, 0.5f, 0.5f);
    public static final RegistrySupplier<EntityType<EntityTideTrident>> TIDE_TRIDENT = IafEntities.build("tide_trident", EntityTideTrident::new, MobCategory.MISC, false, 0.85f, 0.5f);
    public static final RegistrySupplier<EntityType<EntityMobSkull>> MOB_SKULL = IafEntities.build("mob_skull", EntityMobSkull::new, MobCategory.MISC, false, 0.85f, 0.85f);
    public static final RegistrySupplier<EntityType<EntityDreadThrall>> DREAD_THRALL = IafEntities.build("dread_thrall", EntityDreadThrall::new, MobCategory.MONSTER, false, 0.6f, 1.8f);
    public static final RegistrySupplier<EntityType<EntityDreadGhoul>> DREAD_GHOUL = IafEntities.build("dread_ghoul", EntityDreadGhoul::new, MobCategory.MONSTER, false, 0.6f, 1.8f);
    public static final RegistrySupplier<EntityType<EntityDreadBeast>> DREAD_BEAST = IafEntities.build("dread_beast", EntityDreadBeast::new, MobCategory.MONSTER, false, 1.2f, 0.9f);
    public static final RegistrySupplier<EntityType<EntityDreadScuttler>> DREAD_SCUTTLER = IafEntities.build("dread_scuttler", EntityDreadScuttler::new, MobCategory.MONSTER, false, 1.5f, 1.3f);
    public static final RegistrySupplier<EntityType<EntityDreadLich>> DREAD_LICH = IafEntities.build("dread_lich", EntityDreadLich::new, MobCategory.MONSTER, false, 0.6f, 1.8f);
    public static final RegistrySupplier<EntityType<EntityDreadLichSkull>> DREAD_LICH_SKULL = IafEntities.build("dread_lich_skull", EntityDreadLichSkull::new, MobCategory.MISC, false, 0.5f, 0.5f);
    public static final RegistrySupplier<EntityType<EntityDreadKnight>> DREAD_KNIGHT = IafEntities.build("dread_knight", EntityDreadKnight::new, MobCategory.MONSTER, false, 0.6f, 1.8f);
    public static final RegistrySupplier<EntityType<EntityDreadHorse>> DREAD_HORSE = IafEntities.build("dread_horse", EntityDreadHorse::new, MobCategory.MONSTER, false, 1.3964844f, 1.6f);
    public static final RegistrySupplier<EntityType<EntityHydra>> HYDRA = IafEntities.build("hydra", EntityHydra::new, MobCategory.CREATURE, false, 2.8f, 1.39f);
    public static final RegistrySupplier<EntityType<EntityHydraBreath>> HYDRA_BREATH = IafEntities.build("hydra_breath", EntityHydraBreath::new, MobCategory.MISC, false, 0.9f, 0.9f);
    public static final RegistrySupplier<EntityType<EntityHydraArrow>> HYDRA_ARROW = IafEntities.build("hydra_arrow", EntityHydraArrow::new, MobCategory.MISC, false, 0.5f, 0.5f);
    public static final RegistrySupplier<EntityType<EntityGhost>> GHOST = IafEntities.build("ghost", EntityGhost::new, MobCategory.MONSTER, true, 0.8f, 1.9f);
    public static final RegistrySupplier<EntityType<EntityGhostSword>> GHOST_SWORD = IafEntities.build("ghost_sword", EntityGhostSword::new, MobCategory.MISC, false, 0.5f, 0.5f);

    private static <T extends Entity> RegistrySupplier<EntityType<T>> build(String entityName, EntityType.EntityFactory<T> constructor, MobCategory category, boolean fireImmune, float sizeX, float sizeY) {
        EntityType.Builder builder = EntityType.Builder.of(constructor, (MobCategory)category).sized(sizeX, sizeY);
        if (fireImmune) {
            builder.fireImmune();
        }
        return IafEntities.register(entityName, () -> builder.build(entityName));
    }

    private static <T extends Entity> RegistrySupplier<EntityType<T>> build(String entityName, EntityType.EntityFactory<T> constructor, MobCategory category, boolean fireImmune, float sizeX, float sizeY, int trackingRange) {
        EntityType.Builder builder = EntityType.Builder.of(constructor, (MobCategory)category).sized(sizeX, sizeY).clientTrackingRange(trackingRange);
        if (fireImmune) {
            builder.fireImmune();
        }
        return IafEntities.register(entityName, () -> builder.build(entityName));
    }

    private static <T extends Entity> RegistrySupplier<EntityType<T>> register(String entityName, Supplier<EntityType<T>> builder) {
        return REGISTRY.register(entityName, builder);
    }

    public static void init() {
        IafEntities.addSpawners();
        IafEntities.commonSetup();
    }

    public static void bakeAttributes() {
        EntityAttributeRegistry.register(DRAGON_EGG, EntityDragonEgg::bakeAttributes);
        EntityAttributeRegistry.register(DRAGON_SKULL, EntityDragonSkull::bakeAttributes);
        EntityAttributeRegistry.register(FIRE_DRAGON, EntityDragonBase::bakeAttributes);
        EntityAttributeRegistry.register(ICE_DRAGON, EntityDragonBase::bakeAttributes);
        EntityAttributeRegistry.register(LIGHTNING_DRAGON, EntityDragonBase::bakeAttributes);
        EntityAttributeRegistry.register(HIPPOGRYPH, EntityHippogryph::bakeAttributes);
        EntityAttributeRegistry.register(GORGON, EntityGorgon::bakeAttributes);
        EntityAttributeRegistry.register(STONE_STATUE, EntityStoneStatue::bakeAttributes);
        EntityAttributeRegistry.register(PIXIE, EntityPixie::bakeAttributes);
        EntityAttributeRegistry.register(CYCLOPS, EntityCyclops::bakeAttributes);
        EntityAttributeRegistry.register(SIREN, EntitySiren::bakeAttributes);
        EntityAttributeRegistry.register(HIPPOCAMPUS, EntityHippocampus::bakeAttributes);
        EntityAttributeRegistry.register(DEATH_WORM, EntityDeathWorm::bakeAttributes);
        EntityAttributeRegistry.register(COCKATRICE, EntityCockatrice::bakeAttributes);
        EntityAttributeRegistry.register(STYMPHALIAN_BIRD, EntityStymphalianBird::bakeAttributes);
        EntityAttributeRegistry.register(TROLL, EntityTroll::bakeAttributes);
        EntityAttributeRegistry.register(AMPHITHERE, EntityAmphithere::bakeAttributes);
        EntityAttributeRegistry.register(SEA_SERPENT, EntitySeaSerpent::bakeAttributes);
        EntityAttributeRegistry.register(MOB_SKULL, EntityMobSkull::bakeAttributes);
        EntityAttributeRegistry.register(DREAD_THRALL, EntityDreadThrall::bakeAttributes);
        EntityAttributeRegistry.register(DREAD_LICH, EntityDreadLich::bakeAttributes);
        EntityAttributeRegistry.register(DREAD_BEAST, EntityDreadBeast::bakeAttributes);
        EntityAttributeRegistry.register(DREAD_HORSE, EntityDreadHorse::bakeAttributes);
        EntityAttributeRegistry.register(DREAD_GHOUL, EntityDreadGhoul::bakeAttributes);
        EntityAttributeRegistry.register(DREAD_KNIGHT, EntityDreadKnight::bakeAttributes);
        EntityAttributeRegistry.register(DREAD_SCUTTLER, EntityDreadScuttler::bakeAttributes);
        EntityAttributeRegistry.register(HYDRA, EntityHydra::bakeAttributes);
        EntityAttributeRegistry.register(GHOST, EntityGhost::bakeAttributes);
    }

    public static void commonSetup() {
        SpawnPlacements.register((EntityType)((EntityType)HIPPOGRYPH.get()), (SpawnPlacementType)SpawnPlacementTypes.ON_GROUND, (Heightmap.Types)Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, Mob::checkMobSpawnRules);
        SpawnPlacements.register((EntityType)((EntityType)TROLL.get()), (SpawnPlacementType)SpawnPlacementTypes.ON_GROUND, (Heightmap.Types)Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, EntityTroll::canTrollSpawnOn);
        SpawnPlacements.register((EntityType)((EntityType)DREAD_LICH.get()), (SpawnPlacementType)SpawnPlacementTypes.ON_GROUND, (Heightmap.Types)Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, EntityDreadLich::canLichSpawnOn);
        SpawnPlacements.register((EntityType)((EntityType)COCKATRICE.get()), (SpawnPlacementType)SpawnPlacementTypes.ON_GROUND, (Heightmap.Types)Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, EntityCockatrice::canCockatriceSpawn);
        SpawnPlacements.register((EntityType)((EntityType)AMPHITHERE.get()), (SpawnPlacementType)SpawnPlacementTypes.NO_RESTRICTIONS, (Heightmap.Types)Heightmap.Types.MOTION_BLOCKING, EntityAmphithere::canAmphithereSpawnOn);
    }

    public static void addSpawners() {
        if (Platform.isNeoForge()) {
            return;
        }
        if (((Boolean)IafCommonConfig.INSTANCE.hippogryphs.spawn.getValue()).booleanValue()) {
            BiomeModifications.addProperties(context -> context.hasTag(IafBiomeTags.HIPPOGRYPH), (context, mutable) -> mutable.getSpawnProperties().addSpawn(MobCategory.CREATURE, new MobSpawnSettings.SpawnerData((EntityType)HIPPOGRYPH.get(), ((Integer)IafCommonConfig.INSTANCE.hippogryphs.spawnWeight.getValue()).intValue(), 1, 1)));
        }
        if (((Boolean)IafCommonConfig.INSTANCE.lich.spawn.getValue()).booleanValue()) {
            BiomeModifications.addProperties(context -> context.hasTag(IafBiomeTags.MAUSOLEUM), (context, mutable) -> mutable.getSpawnProperties().addSpawn(MobCategory.MONSTER, new MobSpawnSettings.SpawnerData((EntityType)DREAD_LICH.get(), ((Integer)IafCommonConfig.INSTANCE.lich.spawnWeight.getValue()).intValue(), 1, 1)));
        }
        if (((Boolean)IafCommonConfig.INSTANCE.cockatrice.spawn.getValue()).booleanValue()) {
            BiomeModifications.addProperties(context -> context.hasTag(IafBiomeTags.COCKATRICE), (context, mutable) -> mutable.getSpawnProperties().addSpawn(MobCategory.CREATURE, new MobSpawnSettings.SpawnerData((EntityType)COCKATRICE.get(), ((Integer)IafCommonConfig.INSTANCE.cockatrice.spawnWeight.getValue()).intValue(), 1, 2)));
        }
        if (((Boolean)IafCommonConfig.INSTANCE.amphithere.spawn.getValue()).booleanValue()) {
            BiomeModifications.addProperties(context -> context.hasTag(IafBiomeTags.AMPHITHERE), (context, mutable) -> mutable.getSpawnProperties().addSpawn(MobCategory.CREATURE, new MobSpawnSettings.SpawnerData((EntityType)AMPHITHERE.get(), ((Integer)IafCommonConfig.INSTANCE.amphithere.spawnWeight.getValue()).intValue(), 1, 3)));
        }
        if (((Boolean)IafCommonConfig.INSTANCE.troll.spawn.getValue()).booleanValue()) {
            BiomeModifications.addProperties(context -> context.hasTag(IafBiomeTags.TROLL), (context, mutable) -> mutable.getSpawnProperties().addSpawn(MobCategory.MONSTER, new MobSpawnSettings.SpawnerData((EntityType)TROLL.get(), ((Integer)IafCommonConfig.INSTANCE.troll.spawnWeight.getValue()).intValue(), 1, 3)));
        }
    }
}

