/*
 * Decompiled with CFR 0.152.
 */
package com.iafenvoy.iceandfire.item;

import com.iafenvoy.iceandfire.data.HippogryphTypes;
import com.iafenvoy.iceandfire.entity.EntityHippogryphEgg;
import com.iafenvoy.iceandfire.registry.IafDataComponents;
import com.iafenvoy.iceandfire.registry.IafEntities;
import com.iafenvoy.iceandfire.registry.IafItems;
import java.util.List;
import java.util.concurrent.ThreadLocalRandom;
import net.minecraft.ChatFormatting;
import net.minecraft.core.Direction;
import net.minecraft.core.Position;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.network.chat.Component;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.entity.projectile.ThrownEgg;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.ProjectileItem;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;

public class ItemHippogryphEgg
extends Item
implements ProjectileItem {
    public ItemHippogryphEgg() {
        super(new Item.Properties().stacksTo(1));
    }

    public static ItemStack createEggStack(HippogryphTypes parent1, HippogryphTypes parent2) {
        HippogryphTypes eggType = ThreadLocalRandom.current().nextBoolean() ? parent1 : parent2;
        ItemStack stack = new ItemStack((ItemLike)IafItems.HIPPOGRYPH_EGG.get());
        stack.set((DataComponentType)IafDataComponents.STRING.get(), (Object)eggType.getName());
        return stack;
    }

    public InteractionResultHolder<ItemStack> use(Level worldIn, Player playerIn, InteractionHand handIn) {
        ItemStack itemstack = playerIn.getItemInHand(handIn);
        if (!playerIn.isCreative()) {
            itemstack.shrink(1);
        }
        worldIn.playSound(null, playerIn.getX(), playerIn.getY(), playerIn.getZ(), SoundEvents.EGG_THROW, SoundSource.PLAYERS, 0.5f, 0.4f / (worldIn.random.nextFloat() * 0.4f + 0.8f));
        if (!worldIn.isClientSide) {
            EntityHippogryphEgg entityegg = new EntityHippogryphEgg((EntityType<? extends ThrownEgg>)((EntityType)IafEntities.HIPPOGRYPH_EGG.get()), worldIn, (LivingEntity)playerIn, itemstack);
            entityegg.shootFromRotation((Entity)playerIn, playerIn.getXRot(), playerIn.getYRot(), 0.0f, 1.5f, 1.0f);
            worldIn.addFreshEntity((Entity)entityegg);
        }
        return new InteractionResultHolder(InteractionResult.SUCCESS, (Object)itemstack);
    }

    public void appendHoverText(ItemStack stack, Item.TooltipContext context, List<Component> tooltip, TooltipFlag type) {
        super.appendHoverText(stack, context, tooltip, type);
        String eggOrdinal = "";
        if (stack.has((DataComponentType)IafDataComponents.STRING.get())) {
            eggOrdinal = (String)stack.get((DataComponentType)IafDataComponents.STRING.get());
        }
        tooltip.add((Component)Component.translatable((String)("entity.iceandfire.hippogryph." + eggOrdinal)).withStyle(ChatFormatting.GRAY));
    }

    public Projectile asProjectile(Level world, Position pos, ItemStack stack, Direction direction) {
        return new EntityHippogryphEgg((EntityType<? extends ThrownEgg>)((EntityType)IafEntities.HIPPOGRYPH_EGG.get()), world, pos.x(), pos.y(), pos.z(), stack);
    }
}

