/*
 * Decompiled with CFR 0.152.
 */
package com.iafenvoy.iceandfire.item;

import com.iafenvoy.iceandfire.data.DragonColor;
import com.iafenvoy.iceandfire.entity.EntityDragonEgg;
import com.iafenvoy.iceandfire.registry.IafEntities;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import net.minecraft.core.BlockPos;
import net.minecraft.core.component.DataComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.UseOnContext;

public class ItemDragonEgg
extends Item {
    public static final Map<DragonColor, Item> EGGS = new HashMap<DragonColor, Item>();
    public final DragonColor type;

    public ItemDragonEgg(DragonColor type) {
        super(new Item.Properties().stacksTo(1));
        this.type = type;
        EGGS.put(type, this);
    }

    public String getDescriptionId() {
        return "item.iceandfire.dragonegg";
    }

    public void appendHoverText(ItemStack stack, Item.TooltipContext context, List<Component> tooltip, TooltipFlag type) {
        super.appendHoverText(stack, context, tooltip, type);
        tooltip.add((Component)Component.translatable((String)("dragon." + this.type.name().toLowerCase(Locale.ROOT))).withStyle(this.type.color()));
    }

    public InteractionResult useOn(UseOnContext context) {
        ItemStack itemstack = context.getPlayer().getItemInHand(context.getHand());
        BlockPos offset = context.getClickedPos().relative(context.getClickedFace());
        EntityDragonEgg egg = new EntityDragonEgg((EntityType<EntityDragonEgg>)((EntityType)IafEntities.DRAGON_EGG.get()), context.getLevel());
        egg.setEggType(this.type);
        egg.moveTo((double)offset.getX() + 0.5, offset.getY(), (double)offset.getZ() + 0.5, 0.0f, 0.0f);
        egg.onPlayerPlace(context.getPlayer());
        if (itemstack.has(DataComponents.CUSTOM_NAME)) {
            egg.setCustomName(itemstack.getHoverName());
        }
        if (!context.getLevel().isClientSide) {
            context.getLevel().addFreshEntity((Entity)egg);
        }
        itemstack.shrink(1);
        return InteractionResult.SUCCESS;
    }
}

