/*
 * Decompiled with CFR 0.152.
 */
package com.iafenvoy.iceandfire.item;

import com.iafenvoy.iceandfire.data.component.IafEntityData;
import com.iafenvoy.iceandfire.entity.EntityGorgon;
import com.iafenvoy.iceandfire.entity.util.IBlacklistedFromStatues;
import com.iafenvoy.iceandfire.entity.util.dragon.DragonUtils;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.Random;
import net.minecraft.ChatFormatting;
import net.minecraft.core.particles.ColorParticleOption;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleType;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.network.chat.Component;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.UseAnim;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;

public class ItemCockatriceScepter
extends Item {
    private final Random rand = new Random();
    private int specialWeaponDmg;

    public ItemCockatriceScepter() {
        super(new Item.Properties().durability(700));
    }

    public void appendHoverText(ItemStack stack, Item.TooltipContext context, List<Component> tooltip, TooltipFlag type) {
        super.appendHoverText(stack, context, tooltip, type);
        tooltip.add((Component)Component.translatable((String)"item.iceandfire.legendary_weapon.desc").withStyle(ChatFormatting.GRAY));
        tooltip.add((Component)Component.translatable((String)"item.iceandfire.cockatrice_scepter.desc_0").withStyle(ChatFormatting.GRAY));
        tooltip.add((Component)Component.translatable((String)"item.iceandfire.cockatrice_scepter.desc_1").withStyle(ChatFormatting.GRAY));
    }

    public void releaseUsing(ItemStack stack, Level worldIn, LivingEntity livingEntity, int timeLeft) {
        if (this.specialWeaponDmg > 0) {
            stack.hurtAndBreak(this.specialWeaponDmg, livingEntity, LivingEntity.getSlotForHand((InteractionHand)livingEntity.getUsedItemHand()));
            this.specialWeaponDmg = 0;
        }
        IafEntityData data = IafEntityData.get(livingEntity);
        data.miscData.getTargetedByScepter().clear();
    }

    public ItemStack finishUsingItem(ItemStack stack, Level world, LivingEntity user) {
        if (user instanceof Player) {
            Player player = (Player)user;
            player.getCooldowns().addCooldown((Item)this, 20);
        }
        return super.finishUsingItem(stack, world, user);
    }

    public int getUseDuration(ItemStack stack, LivingEntity user) {
        return 1;
    }

    public UseAnim getUseAnimation(ItemStack stack) {
        return UseAnim.BOW;
    }

    public InteractionResultHolder<ItemStack> use(Level worldIn, Player playerIn, InteractionHand hand) {
        ItemStack itemStackIn = playerIn.getItemInHand(hand);
        playerIn.startUsingItem(hand);
        return new InteractionResultHolder(InteractionResult.PASS, (Object)itemStackIn);
    }

    public void onUseTick(Level level, LivingEntity player, ItemStack stack, int count) {
        if (player instanceof Player) {
            double dist = 32.0;
            Vec3 playerEyePosition = player.getEyePosition(1.0f);
            Vec3 playerLook = player.getViewVector(1.0f);
            Vec3 Vector3d2 = playerEyePosition.add(playerLook.x * dist, playerLook.y * dist, playerLook.z * dist);
            Entity pointedEntity = null;
            List nearbyEntities = level.getEntities((Entity)player, player.getBoundingBox().expandTowards(playerLook.x * dist, playerLook.y * dist, playerLook.z * dist).inflate(1.0, 1.0, 1.0), entity -> {
                boolean blindness = entity instanceof LivingEntity && ((LivingEntity)entity).hasEffect(MobEffects.BLINDNESS) || entity instanceof IBlacklistedFromStatues && !((IBlacklistedFromStatues)entity).canBeTurnedToStone();
                return entity != null && entity.isPickable() && !blindness && (entity instanceof Player || entity instanceof LivingEntity && DragonUtils.isAlive((LivingEntity)entity));
            });
            double d2 = dist;
            for (Entity nearbyEntity : nearbyEntities) {
                double d3;
                AABB axisalignedbb = nearbyEntity.getBoundingBox().inflate((double)nearbyEntity.getPickRadius());
                Optional optional = axisalignedbb.clip(playerEyePosition, Vector3d2);
                if (axisalignedbb.contains(playerEyePosition)) {
                    if (!(d2 >= 0.0)) continue;
                    pointedEntity = nearbyEntity;
                    d2 = 0.0;
                    continue;
                }
                if (!optional.isPresent() || !((d3 = playerEyePosition.distanceTo((Vec3)optional.get())) < d2) && d2 != 0.0) continue;
                if (nearbyEntity.getRootVehicle() == player.getRootVehicle()) {
                    if (d2 != 0.0) continue;
                    pointedEntity = nearbyEntity;
                    continue;
                }
                pointedEntity = nearbyEntity;
                d2 = d3;
            }
            if (pointedEntity instanceof LivingEntity) {
                LivingEntity target = (LivingEntity)pointedEntity;
                if (!target.isAlive()) {
                    return;
                }
                IafEntityData data = IafEntityData.get(player);
                data.miscData.addScepterTarget(target);
            }
            this.attackTargets(player);
        }
    }

    private void attackTargets(LivingEntity caster) {
        IafEntityData data = IafEntityData.get(caster);
        ArrayList<LivingEntity> targets = new ArrayList<LivingEntity>(data.miscData.getTargetedByScepter());
        for (LivingEntity target : targets) {
            if (!EntityGorgon.isEntityLookingAt(caster, target, 0.2f) || caster.isRemoved() || target.isRemoved()) {
                data.miscData.removeScepterTarget(target);
                continue;
            }
            target.addEffect(new MobEffectInstance(MobEffects.WITHER, 40, 2));
            if (caster.tickCount % 20 == 0) {
                ++this.specialWeaponDmg;
                target.hurt(caster.level().damageSources.wither(), 2.0f);
            }
            this.drawParticleBeam(caster, target);
        }
    }

    private void drawParticleBeam(LivingEntity origin, LivingEntity target) {
        double d5 = 80.0;
        double d0 = target.getX() - origin.getX();
        double d1 = target.getY() + (double)(target.getBbHeight() * 0.5f) - (origin.getY() + (double)origin.getEyeHeight() * 0.5);
        double d2 = target.getZ() - origin.getZ();
        double d3 = Math.sqrt(d0 * d0 + d1 * d1 + d2 * d2);
        d0 /= d3;
        d1 /= d3;
        d2 /= d3;
        double d4 = this.rand.nextDouble();
        while (d4 < d3) {
            origin.level().addParticle((ParticleOptions)ColorParticleOption.create((ParticleType)ParticleTypes.ENTITY_EFFECT, (int)-16777216), origin.getX() + d0 * (d4 += 1.0), origin.getY() + d1 * d4 + (double)origin.getEyeHeight() * 0.5, origin.getZ() + d2 * d4, 0.0, 0.0, 0.0);
        }
    }
}

