/*
 * Decompiled with CFR 0.152.
 */
package com.iafenvoy.iceandfire.entity.ai;

import com.iafenvoy.iceandfire.entity.EntityPixie;
import java.util.EnumSet;
import net.minecraft.core.BlockPos;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.ai.goal.Goal;

public class PixieAIEnterHouse
extends Goal {
    final EntityPixie pixie;
    final RandomSource random;

    public PixieAIEnterHouse(EntityPixie entityPixieIn) {
        this.pixie = entityPixieIn;
        this.random = entityPixieIn.getRandom();
        this.setFlags(EnumSet.of(Goal.Flag.MOVE));
    }

    public boolean canUse() {
        if (this.pixie.isOwnerClose() || this.pixie.getMoveControl().hasWanted() || this.pixie.isPixieSitting() || this.random.nextInt(20) != 0 || this.pixie.ticksUntilHouseAI != 0) {
            return false;
        }
        BlockPos blockpos1 = EntityPixie.findAHouse((Entity)this.pixie, this.pixie.level());
        return !blockpos1.toString().equals(this.pixie.blockPosition().toString());
    }

    public boolean canContinueToUse() {
        return false;
    }

    public void tick() {
        for (int i = 0; i < 3; ++i) {
            BlockPos blockpos1 = EntityPixie.findAHouse((Entity)this.pixie, this.pixie.level());
            this.pixie.getMoveControl().setWantedPosition((double)blockpos1.getX() + 0.5, (double)blockpos1.getY() + 0.5, (double)blockpos1.getZ() + 0.5, 0.25);
            this.pixie.setHousePosition(blockpos1);
            if (this.pixie.getTarget() != null) continue;
            this.pixie.getLookControl().setLookAt((double)blockpos1.getX() + 0.5, (double)blockpos1.getY() + 0.5, (double)blockpos1.getZ() + 0.5, 180.0f, 20.0f);
        }
    }
}

