/*
 * Decompiled with CFR 0.152.
 */
package com.iafenvoy.iceandfire.entity.ai;

import com.iafenvoy.iceandfire.entity.EntityDeathWorm;
import com.iafenvoy.iceandfire.registry.IafEntities;
import java.util.EnumSet;
import java.util.function.Predicate;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.phys.AABB;

public class DeathWormAITarget<T extends LivingEntity>
extends NearestAttackableTargetGoal<T> {
    private final EntityDeathWorm deathworm;

    public DeathWormAITarget(EntityDeathWorm entityIn, Class<T> classTarget, boolean checkSight, Predicate<LivingEntity> targetPredicate) {
        super((Mob)entityIn, classTarget, 20, checkSight, false, targetPredicate);
        this.deathworm = entityIn;
        this.setFlags(EnumSet.of(Goal.Flag.TARGET));
    }

    public boolean canUse() {
        boolean canUse = super.canUse();
        if (canUse && this.target != null && this.target.getType() != IafEntities.DEATH_WORM.get()) {
            if (this.target instanceof Player && !this.deathworm.isOwnedBy(this.target)) {
                return !this.deathworm.isTame();
            }
            if (this.deathworm.isOwnedBy(this.target)) {
                return false;
            }
            if (this.target instanceof Monster && this.deathworm.getWormAge() > 2) {
                if (this.target instanceof PathfinderMob) {
                    return this.deathworm.getWormAge() > 3;
                }
                return true;
            }
        }
        return false;
    }

    protected AABB getTargetSearchArea(double targetDistance) {
        return this.deathworm.getBoundingBox().inflate(targetDistance, 6.0, targetDistance);
    }
}

