/*
 * Decompiled with CFR 0.152.
 */
package com.iafenvoy.iceandfire.data;

import com.google.common.collect.ImmutableList;
import com.iafenvoy.iceandfire.item.ItemSeaSerpentScales;
import com.iafenvoy.iceandfire.item.armor.ItemSeaSerpentArmor;
import com.iafenvoy.iceandfire.item.block.BlockSeaSerpentScales;
import com.iafenvoy.iceandfire.registry.IafArmorMaterials;
import com.iafenvoy.iceandfire.registry.IafBlocks;
import com.iafenvoy.iceandfire.registry.IafItems;
import com.iafenvoy.uranus.util.function.MemorizeSupplier;
import dev.architectury.registry.registries.RegistrySupplier;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Supplier;
import net.minecraft.ChatFormatting;
import net.minecraft.core.Holder;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.item.ArmorItem;
import net.minecraft.world.item.ArmorMaterial;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;

public class SeaSerpent {
    private static final List<SeaSerpent> TYPES = new ArrayList<SeaSerpent>();
    private static final Map<String, SeaSerpent> BY_NAME = new HashMap<String, SeaSerpent>();
    public static final SeaSerpent BLUE = new SeaSerpent("blue", ChatFormatting.BLUE);
    public static final SeaSerpent BRONZE = new SeaSerpent("bronze", ChatFormatting.GOLD);
    public static final SeaSerpent DEEPBLUE = new SeaSerpent("deepblue", ChatFormatting.DARK_BLUE);
    public static final SeaSerpent GREEN = new SeaSerpent("green", ChatFormatting.DARK_GREEN);
    public static final SeaSerpent PURPLE = new SeaSerpent("purple", ChatFormatting.DARK_PURPLE);
    public static final SeaSerpent RED = new SeaSerpent("red", ChatFormatting.DARK_RED);
    public static final SeaSerpent TEAL = new SeaSerpent("teal", ChatFormatting.AQUA);
    private final String name;
    private final ChatFormatting color;
    public RegistrySupplier<ArmorMaterial> armorMaterial;
    public RegistrySupplier<Item> scale;
    public RegistrySupplier<Item> helmet;
    public RegistrySupplier<Item> chestplate;
    public RegistrySupplier<Item> leggings;
    public RegistrySupplier<Item> boots;
    public RegistrySupplier<Block> scaleBlock;

    public SeaSerpent(String name, ChatFormatting color) {
        this.name = name;
        this.color = color;
        TYPES.add(this);
        BY_NAME.put(name, this);
    }

    public String getName() {
        return this.name;
    }

    public ChatFormatting getColor() {
        return this.color;
    }

    public ResourceLocation getTexture(boolean blink) {
        return ResourceLocation.fromNamespaceAndPath((String)"iceandfire", (String)String.format("textures/entity/seaserpent/seaserpent_%s%s.png", this.name, blink ? "_blink" : ""));
    }

    public static List<SeaSerpent> values() {
        return ImmutableList.copyOf(TYPES);
    }

    public static void initArmors() {
        for (SeaSerpent color : SeaSerpent.values()) {
            color.armorMaterial = IafArmorMaterials.register("sea_serpent_scales_" + color.name, new int[]{4, 7, 8, 4}, 25, (Holder<SoundEvent>)SoundEvents.ARMOR_EQUIP_GOLD, 2.5f, (Supplier<Ingredient>)new MemorizeSupplier(() -> Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)color.scale.get()})));
            color.scaleBlock = IafBlocks.register("sea_serpent_scale_block_" + color.name, () -> new BlockSeaSerpentScales(color.name, color.color));
            color.scale = IafItems.register("sea_serpent_scales_" + color.name, () -> new ItemSeaSerpentScales(color.name, color.color));
            color.helmet = IafItems.register("tide_" + color.name + "_helmet", () -> new ItemSeaSerpentArmor(color, (Holder<ArmorMaterial>)color.armorMaterial, ArmorItem.Type.HELMET));
            color.chestplate = IafItems.register("tide_" + color.name + "_chestplate", () -> new ItemSeaSerpentArmor(color, (Holder<ArmorMaterial>)color.armorMaterial, ArmorItem.Type.CHESTPLATE));
            color.leggings = IafItems.register("tide_" + color.name + "_leggings", () -> new ItemSeaSerpentArmor(color, (Holder<ArmorMaterial>)color.armorMaterial, ArmorItem.Type.LEGGINGS));
            color.boots = IafItems.register("tide_" + color.name + "_boots", () -> new ItemSeaSerpentArmor(color, (Holder<ArmorMaterial>)color.armorMaterial, ArmorItem.Type.BOOTS));
        }
    }

    public static SeaSerpent getByName(String name) {
        return BY_NAME.getOrDefault(name, BLUE);
    }
}

