/*
 * Decompiled with CFR 0.152.
 */
package it.hurts.sskirillss.relics.network.packets.sync;

import io.netty.buffer.ByteBuf;
import it.hurts.sskirillss.relics.entities.misc.ITargetableEntity;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.Level;
import net.neoforged.neoforge.network.handling.IPayloadContext;

public class S2CEntityTargetPacket
implements CustomPacketPayload {
    private final int sourceId;
    private final int targetId;
    public static final CustomPacketPayload.Type<S2CEntityTargetPacket> TYPE = new CustomPacketPayload.Type(ResourceLocation.fromNamespaceAndPath((String)"relics", (String)"entity_target"));
    public static final StreamCodec<ByteBuf, S2CEntityTargetPacket> STREAM_CODEC = StreamCodec.composite((StreamCodec)ByteBufCodecs.INT, S2CEntityTargetPacket::getTargetId, (StreamCodec)ByteBufCodecs.INT, S2CEntityTargetPacket::getSourceId, S2CEntityTargetPacket::new);

    public void handle(IPayloadContext ctx) {
        ctx.enqueueWork(() -> {
            Level level = ctx.player().getCommandSenderWorld();
            Entity patt0$temp = level.getEntity(this.sourceId);
            if (patt0$temp instanceof ITargetableEntity) {
                ITargetableEntity source = (ITargetableEntity)patt0$temp;
                Entity patt1$temp = level.getEntity(this.targetId);
                if (patt1$temp instanceof LivingEntity) {
                    LivingEntity target = (LivingEntity)patt1$temp;
                    source.setTarget(target);
                }
            }
        });
    }

    public CustomPacketPayload.Type<? extends CustomPacketPayload> type() {
        return TYPE;
    }

    public int getSourceId() {
        return this.sourceId;
    }

    public int getTargetId() {
        return this.targetId;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof S2CEntityTargetPacket)) {
            return false;
        }
        S2CEntityTargetPacket other = (S2CEntityTargetPacket)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getSourceId() != other.getSourceId()) {
            return false;
        }
        return this.getTargetId() == other.getTargetId();
    }

    protected boolean canEqual(Object other) {
        return other instanceof S2CEntityTargetPacket;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + this.getSourceId();
        result = result * 59 + this.getTargetId();
        return result;
    }

    public String toString() {
        return "S2CEntityTargetPacket(sourceId=" + this.getSourceId() + ", targetId=" + this.getTargetId() + ")";
    }

    public S2CEntityTargetPacket(int sourceId, int targetId) {
        this.sourceId = sourceId;
        this.targetId = targetId;
    }
}

