/*
 * Decompiled with CFR 0.152.
 */
package it.hurts.sskirillss.relics.items.relics.back;

import com.google.common.collect.Lists;
import it.hurts.sskirillss.relics.init.DataComponentRegistry;
import it.hurts.sskirillss.relics.init.EffectRegistry;
import it.hurts.sskirillss.relics.init.ItemRegistry;
import it.hurts.sskirillss.relics.items.relics.base.IRelicItem;
import it.hurts.sskirillss.relics.items.relics.base.IRenderableCurio;
import it.hurts.sskirillss.relics.items.relics.base.RelicItem;
import it.hurts.sskirillss.relics.items.relics.base.data.RelicData;
import it.hurts.sskirillss.relics.items.relics.base.data.cast.CastData;
import it.hurts.sskirillss.relics.items.relics.base.data.cast.misc.CastType;
import it.hurts.sskirillss.relics.items.relics.base.data.leveling.AbilitiesData;
import it.hurts.sskirillss.relics.items.relics.base.data.leveling.AbilityData;
import it.hurts.sskirillss.relics.items.relics.base.data.leveling.LevelingData;
import it.hurts.sskirillss.relics.items.relics.base.data.leveling.StatData;
import it.hurts.sskirillss.relics.items.relics.base.data.leveling.misc.UpgradeOperation;
import it.hurts.sskirillss.relics.items.relics.base.data.loot.LootData;
import it.hurts.sskirillss.relics.items.relics.base.data.loot.misc.LootEntries;
import it.hurts.sskirillss.relics.utils.EntityUtils;
import it.hurts.sskirillss.relics.utils.MathUtils;
import it.hurts.sskirillss.relics.utils.ParticleUtils;
import java.awt.Color;
import java.util.List;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.client.model.HumanoidModel;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeDeformation;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LightLayer;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.event.entity.living.LivingIncomingDamageEvent;
import top.theillusivec4.curios.api.SlotContext;

public class MidnightRobeItem
extends RelicItem
implements IRenderableCurio {
    @Override
    public RelicData constructDefaultRelicData() {
        return RelicData.builder().abilities(AbilitiesData.builder().ability(AbilityData.builder("vanish").requiredPoints(2).active(CastData.builder().type(CastType.TOGGLEABLE).build()).stat(StatData.builder("light").initialValue(1.0, 2.0).upgradeModifier(UpgradeOperation.ADD, 1.0).formatValue(value -> (int)MathUtils.round(value, 0)).build()).stat(StatData.builder("speed").initialValue(0.1, 0.35).upgradeModifier(UpgradeOperation.MULTIPLY_BASE, 0.35).formatValue(value -> (int)(MathUtils.round(value, 3) * 100.0)).build()).build()).ability(AbilityData.builder("backstab").stat(StatData.builder("damage").initialValue(1.25, 1.75).upgradeModifier(UpgradeOperation.MULTIPLY_BASE, 0.1).formatValue(value -> (int)(100.0 * MathUtils.round(value - 1.0, 1))).build()).stat(StatData.builder("distance").initialValue(20.0, 15.0).upgradeModifier(UpgradeOperation.ADD, -0.5).formatValue(value -> MathUtils.round(value, 1)).build()).build()).build()).leveling(new LevelingData(100, 10, 100)).loot(LootData.builder().entry(LootEntries.THE_END, LootEntries.END_LIKE).build()).build();
    }

    public void curioTick(SlotContext slotContext, ItemStack stack) {
        LivingEntity livingEntity = slotContext.entity();
        if (!(livingEntity instanceof Player)) {
            return;
        }
        Player player = (Player)livingEntity;
        Level level = player.getCommandSenderWorld();
        if (level.isClientSide()) {
            return;
        }
        ServerLevel serverLevel = (ServerLevel)level;
        LivingEntity target = MidnightRobeItem.getTarget((Level)serverLevel, stack);
        if (target != null) {
            double radius = this.getStatValue(stack, "backstab", "distance");
            double step = 0.15;
            int offset = 16;
            double len = (float)(Math.PI * 2 * radius);
            int num = (int)(len / step);
            for (int i = 0; i < num; ++i) {
                int tries;
                double angle = Math.toRadians((double)(360.0f / (float)num * (float)i) + 360.0 * ((len / step - (double)num) / (double)num / len));
                double extraX = radius * Math.sin(angle) + target.getX();
                double extraZ = radius * Math.cos(angle) + target.getZ();
                double extraY = target.getY() + (double)(target.getBbHeight() * 0.5f);
                boolean foundPos = false;
                for (tries = 0; tries < offset * 2; ++tries) {
                    Vec3 vec = new Vec3(extraX, extraY, extraZ);
                    BlockPos pos = new BlockPos((int)vec.x, (int)vec.y, (int)vec.z);
                    BlockState state = serverLevel.getBlockState(pos);
                    VoxelShape shape = state.getCollisionShape((BlockGetter)serverLevel, pos);
                    if (shape.isEmpty()) {
                        if (!foundPos) {
                            extraY -= 1.0;
                            continue;
                        }
                    } else {
                        foundPos = true;
                    }
                    if (shape.isEmpty()) break;
                    AABB aabb = shape.bounds();
                    if (!aabb.move(pos).contains(vec)) {
                        if (!(aabb.maxY >= 1.0)) break;
                        extraY += 1.0;
                        continue;
                    }
                    extraY += step;
                }
                if (tries >= offset * 2) continue;
                serverLevel.sendParticles(ParticleUtils.constructSimpleSpark(new Color(50 + serverLevel.getRandom().nextInt(50), 0, 255), 0.25f, 3, 0.75f), extraX, extraY + (double)0.2f, extraZ, 1, 0.05, 0.05, 0.05, 0.025);
            }
        }
        if (!MidnightRobeItem.canHide((LivingEntity)player)) {
            EntityUtils.removeAttribute((LivingEntity)player, stack, (Holder<Attribute>)Attributes.MOVEMENT_SPEED, AttributeModifier.Operation.ADD_MULTIPLIED_TOTAL);
            if (target != null && (target.isDeadOrDying() || target.position().distanceTo(player.position()) >= this.getStatValue(stack, "backstab", "distance"))) {
                stack.set(DataComponentRegistry.TARGET, (Object)"");
            }
        } else {
            player.addEffect(new MobEffectInstance(EffectRegistry.VANISHING, 5, 0, false, false));
            EntityUtils.applyAttribute((LivingEntity)player, stack, (Holder<Attribute>)Attributes.MOVEMENT_SPEED, (float)this.getStatValue(stack, "vanish", "speed"), AttributeModifier.Operation.ADD_MULTIPLIED_TOTAL);
        }
    }

    @Nullable
    private static LivingEntity getTarget(Level level, ItemStack stack) {
        LivingEntity target;
        if (level.isClientSide()) {
            return null;
        }
        ServerLevel serverLevel = (ServerLevel)level;
        String string = (String)stack.getOrDefault(DataComponentRegistry.TARGET, (Object)"");
        if (string.isEmpty()) {
            return null;
        }
        Entity entity = serverLevel.getEntity(UUID.fromString(string));
        if (!(entity instanceof LivingEntity) || (target = (LivingEntity)entity).isDeadOrDying()) {
            stack.set(DataComponentRegistry.TARGET, (Object)"");
            return null;
        }
        return target;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static boolean canHide(LivingEntity entity) {
        ItemStack stack = EntityUtils.findEquippedCurio((Entity)entity, (Item)ItemRegistry.MIDNIGHT_ROBE.get());
        Item item = stack.getItem();
        if (!(item instanceof IRelicItem)) return false;
        IRelicItem relic = (IRelicItem)item;
        Level world = entity.getCommandSenderWorld();
        BlockPos position = entity.blockPosition().above();
        double light = relic.getStatValue(stack, "vanish", "light");
        if (!relic.isAbilityTicking(stack, "vanish")) return false;
        if (!((String)stack.getOrDefault(DataComponentRegistry.TARGET, (Object)"")).isEmpty()) return false;
        double d = (double)world.getBrightness(LightLayer.BLOCK, position) + (double)world.getBrightness(LightLayer.SKY, position) / 2.0;
        double d2 = world.isNight() ? light * 1.5 : light;
        if (!(d <= d2)) return false;
        return true;
    }

    public void onUnequip(SlotContext slotContext, ItemStack newStack, ItemStack stack) {
        EntityUtils.removeAttribute(slotContext.entity(), stack, (Holder<Attribute>)Attributes.MOVEMENT_SPEED, AttributeModifier.Operation.ADD_MULTIPLIED_TOTAL);
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public LayerDefinition constructLayerDefinition() {
        MeshDefinition mesh = HumanoidModel.createMesh((CubeDeformation)new CubeDeformation(0.4f), (float)0.0f);
        PartDefinition root = mesh.getRoot();
        PartDefinition head = root.addOrReplaceChild("head", CubeListBuilder.create(), PartPose.offset((float)0.0f, (float)0.0f, (float)0.0f));
        PartDefinition cube_r1 = head.addOrReplaceChild("cube_r1", CubeListBuilder.create().texOffs(0, 25).addBox(-5.0f, -1.275f, -1.75f, 10.0f, 3.0f, 6.0f, new CubeDeformation(0.01f)), PartPose.offsetAndRotation((float)0.0f, (float)0.0f, (float)1.5f, (float)0.3927f, (float)0.0f, (float)0.0f));
        PartDefinition body = root.addOrReplaceChild("body", CubeListBuilder.create().texOffs(0, 0).addBox(-5.0f, -0.5f, -3.0f, 10.0f, 7.0f, 6.0f, new CubeDeformation(-0.01f)), PartPose.offset((float)0.0f, (float)0.0f, (float)0.0f));
        PartDefinition cube_r2 = body.addOrReplaceChild("cube_r2", CubeListBuilder.create().texOffs(32, 8).addBox(-5.0f, -6.6f, -1.6f, 10.0f, 8.0f, 0.0f, new CubeDeformation(0.0f)).texOffs(32, 0).addBox(-5.0f, -6.6f, 4.4f, 10.0f, 8.0f, 0.0f, new CubeDeformation(0.0f)).texOffs(0, 28).mirror().addBox(-4.99f, -6.6f, -1.6f, 0.0f, 8.0f, 6.0f, new CubeDeformation(0.0f)).mirror(false).texOffs(0, 28).addBox(4.99f, -6.6f, -1.6f, 0.0f, 8.0f, 6.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)0.0f, (float)17.9046f, (float)1.5671f, (float)0.3491f, (float)0.0f, (float)0.0f));
        PartDefinition cube_r3 = body.addOrReplaceChild("cube_r3", CubeListBuilder.create().texOffs(0, 13).addBox(-5.0f, -4.65f, -3.9f, 10.0f, 6.0f, 6.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)0.0f, (float)10.5f, (float)1.5f, (float)0.1309f, (float)0.0f, (float)0.0f));
        PartDefinition left_arm = root.addOrReplaceChild("left_arm", CubeListBuilder.create().texOffs(0, 43).addBox(-1.0f, -2.25f, -2.0f, 4.0f, 9.0f, 4.0f, new CubeDeformation(0.25f)), PartPose.offset((float)6.0f, (float)2.0f, (float)0.0f));
        PartDefinition right_arm = root.addOrReplaceChild("right_arm", CubeListBuilder.create().texOffs(0, 43).mirror().addBox(-3.0f, -2.25f, -2.0f, 4.0f, 9.0f, 4.0f, new CubeDeformation(0.25f)).mirror(false), PartPose.offset((float)-6.0f, (float)2.0f, (float)0.0f));
        return LayerDefinition.create((MeshDefinition)mesh, (int)64, (int)64);
    }

    @Override
    public List<String> headParts() {
        return Lists.newArrayList((Object[])new String[]{"head"});
    }

    @Override
    public List<String> bodyParts() {
        return Lists.newArrayList((Object[])new String[]{"right_arm", "left_arm", "body"});
    }

    @EventBusSubscriber
    public static class ServerEvents {
        @SubscribeEvent
        public static void onLivingHurt(LivingIncomingDamageEvent event) {
            IRelicItem relic;
            ItemStack stack;
            Player player;
            LivingEntity target;
            block7: {
                block6: {
                    block5: {
                        block4: {
                            target = event.getEntity();
                            Level level = target.getCommandSenderWorld();
                            Entity entity = event.getSource().getEntity();
                            if (!(entity instanceof Player)) break block4;
                            player = (Player)entity;
                            if (!level.isClientSide() && !target.getStringUUID().equals(player.getStringUUID())) break block5;
                        }
                        return;
                    }
                    stack = EntityUtils.findEquippedCurio((Entity)player, (Item)ItemRegistry.MIDNIGHT_ROBE.get());
                    Item item = stack.getItem();
                    if (!(item instanceof IRelicItem)) break block6;
                    relic = (IRelicItem)item;
                    if (!MidnightRobeItem.canHide((LivingEntity)player)) break block6;
                    Vec3 vec3 = new Vec3(target.getX(), player.getY(), target.getZ());
                    if (!(player.position().distanceTo(vec3) > relic.getStatValue(stack, "backstab", "distance"))) break block7;
                }
                return;
            }
            relic.spreadRelicExperience((LivingEntity)player, stack, Math.round(event.getAmount() * 0.5f));
            event.setAmount((float)((double)event.getAmount() * relic.getStatValue(stack, "backstab", "damage")));
            stack.set(DataComponentRegistry.TARGET, (Object)target.getStringUUID());
        }
    }
}

