/*
 * Decompiled with CFR 0.152.
 */
package it.hurts.sskirillss.relics.client.tooltip;

import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import it.hurts.sskirillss.relics.api.events.common.TooltipDisplayEvent;
import it.hurts.sskirillss.relics.items.relics.base.IRelicItem;
import it.hurts.sskirillss.relics.items.relics.base.data.style.TooltipData;
import it.hurts.sskirillss.relics.utils.data.AnimationData;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.client.event.RenderTooltipEvent;

@EventBusSubscriber(modid="relics", bus=EventBusSubscriber.Bus.GAME, value={Dist.CLIENT})
public class TooltipBorderHandler {
    @SubscribeEvent
    public static void onTooltipDisplay(TooltipDisplayEvent event) {
        LocalPlayer player = Minecraft.getInstance().player;
        if (player == null) {
            return;
        }
        ItemStack stack = event.getStack();
        Item item = stack.getItem();
        if (!(item instanceof IRelicItem)) {
            return;
        }
        IRelicItem relic = (IRelicItem)item;
        TooltipData tooltip = relic.getStyleData().getTooltip().apply((Player)player, stack);
        if (!tooltip.isTextured()) {
            return;
        }
        GuiGraphics graphics = event.getGraphics();
        PoseStack poseStack = graphics.pose();
        int width = event.getWidth();
        int height = event.getHeight();
        int x = event.getX();
        int y = event.getY();
        String id = tooltip.getIcon().isEmpty() ? BuiltInRegistries.ITEM.getKey((Object)stack.getItem()).getPath() : tooltip.getIcon();
        ResourceLocation texture = ResourceLocation.fromNamespaceAndPath((String)"relics", (String)("textures/gui/tooltip/frame/" + id + "_frame.png"));
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.setShaderTexture((int)0, (ResourceLocation)texture);
        Minecraft.getInstance().getTextureManager().getTexture(texture).bind();
        int texWidth = GlStateManager._getTexLevelParameter((int)3553, (int)0, (int)4096);
        int texHeight = GlStateManager._getTexLevelParameter((int)3553, (int)0, (int)4097);
        if (texHeight == 0 || texWidth == 0) {
            return;
        }
        int patternWidth = 160;
        int patternHeight = 64;
        int cornerWidth = 32;
        int cornerHeight = 32;
        int middleWidth = 96;
        int middleHeight = cornerHeight;
        poseStack.pushPose();
        RenderSystem.enableBlend();
        poseStack.translate(0.0, 0.0, 410.0);
        int frame = (Integer)AnimationData.construct(texHeight, patternHeight, 2).getFrameByTime(player.tickCount).getKey();
        int offset = patternHeight * frame;
        graphics.blit(texture, x - cornerWidth / 2 - 3, y - cornerHeight / 2 - 3, 0.0f, (float)offset, cornerWidth, cornerHeight, texWidth, texHeight);
        graphics.blit(texture, x + width - cornerWidth / 2 + 3, y - cornerHeight / 2 - 3, (float)(patternWidth - cornerWidth), (float)offset, cornerWidth, cornerHeight, texWidth, texHeight);
        graphics.blit(texture, x - cornerWidth / 2 - 3, y + height - cornerHeight / 2 + 3, 0.0f, (float)(patternHeight - cornerHeight + offset), cornerWidth, cornerHeight, texWidth, texHeight);
        graphics.blit(texture, x + width - cornerWidth / 2 + 3, y + height - cornerHeight / 2 + 3, (float)(patternWidth - cornerWidth), (float)(patternHeight - cornerHeight + offset), cornerWidth, cornerHeight, texWidth, texHeight);
        graphics.blit(texture, x + (width - middleWidth) / 2, y - middleHeight + 1, (float)cornerWidth, (float)offset, middleWidth, middleHeight, texWidth, texHeight);
        graphics.blit(texture, x + (width - middleWidth) / 2, y + height - 1, (float)cornerWidth, (float)(middleHeight + offset), middleWidth, middleHeight, texWidth, texHeight);
        texture = ResourceLocation.fromNamespaceAndPath((String)"relics", (String)("textures/gui/tooltip/frame/" + id + "_star.png"));
        RenderSystem.setShaderTexture((int)0, (ResourceLocation)texture);
        int xOff = 0;
        for (int i = 1; i < relic.getRelicQuality(stack) + 1; ++i) {
            boolean isAliquot = i % 2 == 1;
            float color = (float)((double)0.85f + Math.sin((double)player.tickCount * Math.ceil((float)i / 2.0f) * (double)0.075f) * (double)0.2f);
            RenderSystem.blendFunc((int)770, (int)1);
            RenderSystem.setShaderColor((float)color, (float)color, (float)color, (float)1.0f);
            graphics.blit(texture, x + width / 2 - 14 + xOff, y - 10, (float)(isAliquot ? 0 : 3), 0.0f, isAliquot ? 3 : 2, 5, 5, 5);
            RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            xOff += 3;
        }
        RenderSystem.disableBlend();
        poseStack.popPose();
    }

    @SubscribeEvent
    public static void onTooltipColorEvent(RenderTooltipEvent.Color event) {
        ItemStack stack = event.getItemStack();
        Item item = stack.getItem();
        if (!(item instanceof IRelicItem)) {
            return;
        }
        IRelicItem relic = (IRelicItem)item;
        TooltipData tooltip = relic.getStyleData().getTooltip().apply((Player)Minecraft.getInstance().player, stack);
        if (tooltip.getBorderTop() != -1) {
            event.setBorderStart(tooltip.getBorderTop());
        }
        if (tooltip.getBorderBottom() != -1) {
            event.setBorderEnd(tooltip.getBorderBottom());
        }
        if (tooltip.getBackgroundTop() != -1) {
            event.setBackgroundStart(tooltip.getBackgroundTop());
        }
        if (tooltip.getBackgroundBottom() != -1) {
            event.setBackgroundEnd(tooltip.getBackgroundBottom());
        }
    }
}

