/*
 * Decompiled with CFR 0.152.
 */
package it.hurts.sskirillss.relics.client.screen.description.ability.widgets;

import com.google.common.collect.Lists;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import it.hurts.sskirillss.relics.client.screen.base.IHoverableWidget;
import it.hurts.sskirillss.relics.client.screen.base.ITickingWidget;
import it.hurts.sskirillss.relics.client.screen.description.ability.AbilityDescriptionScreen;
import it.hurts.sskirillss.relics.client.screen.description.general.widgets.base.AbstractDescriptionWidget;
import it.hurts.sskirillss.relics.client.screen.description.misc.DescriptionTextures;
import it.hurts.sskirillss.relics.client.screen.description.misc.DescriptionUtils;
import it.hurts.sskirillss.relics.client.screen.description.relic.particles.ChainParticleData;
import it.hurts.sskirillss.relics.client.screen.description.relic.particles.ExperienceParticleData;
import it.hurts.sskirillss.relics.client.screen.description.relic.particles.SparkParticleData;
import it.hurts.sskirillss.relics.client.screen.description.research.AbilityResearchScreen;
import it.hurts.sskirillss.relics.client.screen.utils.ParticleStorage;
import it.hurts.sskirillss.relics.client.screen.utils.ScreenUtils;
import it.hurts.sskirillss.relics.items.relics.base.IRelicItem;
import it.hurts.sskirillss.relics.items.relics.base.data.leveling.AbilityData;
import it.hurts.sskirillss.relics.network.NetworkHandler;
import it.hurts.sskirillss.relics.network.packets.lock.PacketAbilityUnlock;
import it.hurts.sskirillss.relics.utils.MathUtils;
import it.hurts.sskirillss.relics.utils.RenderUtils;
import it.hurts.sskirillss.relics.utils.data.AnimationData;
import it.hurts.sskirillss.relics.utils.data.GUIRenderer;
import java.awt.Color;
import java.util.ArrayList;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Renderable;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.renderer.texture.TextureManager;
import net.minecraft.client.resources.sounds.SimpleSoundInstance;
import net.minecraft.client.resources.sounds.SoundInstance;
import net.minecraft.client.sounds.SoundManager;
import net.minecraft.core.Holder;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.Style;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.util.FormattedCharSequence;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.phys.Vec2;

public class AbilityCardWidget
extends AbstractDescriptionWidget
implements IHoverableWidget,
ITickingWidget {
    private final AbilityDescriptionScreen screen;
    private final String ability;
    private float scale = 1.0f;
    private float scaleOld = 1.0f;
    private int shakeDelta = 0;
    private int colorDelta = 0;

    public AbilityCardWidget(int x, int y, AbilityDescriptionScreen screen, String ability) {
        super(x, y, 32, 47);
        this.screen = screen;
        this.ability = ability;
    }

    @Override
    public void onPress() {
        Item item = this.screen.getStack().getItem();
        if (!(item instanceof IRelicItem)) {
            return;
        }
        IRelicItem relic = (IRelicItem)item;
        ItemStack stack = this.screen.getStack();
        boolean isEnoughLevel = relic.isEnoughLevel(stack, this.ability);
        boolean isLockUnlocked = relic.isLockUnlocked(stack, this.ability);
        boolean isAbilityResearched = relic.isAbilityResearched(stack, this.ability);
        SoundManager soundManager = this.minecraft.getSoundManager();
        if (isEnoughLevel) {
            if (isLockUnlocked) {
                if (isAbilityResearched) {
                    if (!this.screen.getSelectedAbility().equals(this.ability)) {
                        this.screen.setSelectedAbility(this.ability);
                        this.screen.rebuildWidgets();
                        for (Renderable entry : this.screen.renderables) {
                            if (!(entry instanceof AbilityCardWidget)) continue;
                            AbilityCardWidget card = (AbilityCardWidget)entry;
                            if (!card.ability.equals(this.ability)) continue;
                            card.scale = this.scale;
                            card.scaleOld = this.scaleOld;
                            card.shakeDelta = this.shakeDelta;
                            card.colorDelta = this.colorDelta;
                        }
                    }
                } else {
                    this.minecraft.setScreen((Screen)new AbilityResearchScreen((Player)this.minecraft.player, this.screen.container, this.screen.slot, this.screen, this.ability));
                }
            } else {
                Vec2 motion;
                Vec2 margin;
                Vec2 center;
                int i;
                int unlocks = relic.getLockUnlocks(stack, this.ability) + 1;
                RandomSource random = this.minecraft.player.getRandom();
                for (i = 0; i < unlocks * 50; ++i) {
                    center = new Vec2((float)this.width / 2.0f, (float)this.height / 2.0f);
                    margin = new Vec2(center.x + MathUtils.randomFloat(random) * 7.0f, center.y + MathUtils.randomFloat(random) * 8.5f);
                    motion = new Vec2(margin.x - center.x, margin.y - center.y).normalized().scale(5.0f + (float)unlocks);
                    ParticleStorage.addParticle(this.screen, new SparkParticleData(new Color(150 + random.nextInt(100), 100 + random.nextInt(50), 0), (float)this.getX() + margin.x, (float)this.getY() + margin.y, 1.0f + random.nextFloat() * 0.5f, 20 + random.nextInt(100)).setDeltaX(random.nextFloat() * motion.x).setDeltaY(random.nextFloat() * motion.y));
                }
                NetworkHandler.sendToServer(new PacketAbilityUnlock(this.screen.container, this.screen.slot, this.ability, unlocks));
                this.shakeDelta = Math.min(20, this.shakeDelta + 5 + random.nextInt(5));
                this.scale += 0.05f;
                soundManager.play((SoundInstance)SimpleSoundInstance.forUI((SoundEvent)SoundEvents.ZOMBIE_ATTACK_IRON_DOOR, (float)1.0f));
                if (unlocks >= relic.getMaxLockUnlocks()) {
                    for (i = 0; i < 25; ++i) {
                        center = new Vec2((float)this.width / 2.0f, (float)this.height / 2.0f);
                        margin = new Vec2(center.x + MathUtils.randomFloat(random) * 7.0f, center.y + MathUtils.randomFloat(random) * 8.5f);
                        motion = new Vec2(margin.x - center.x, margin.y - center.y).normalized().scale(7.5f);
                        ParticleStorage.addParticle(this.screen, new ChainParticleData(new Color(255, 255, 255), (float)this.getX() + margin.x, (float)this.getY() + margin.y, 1.0f + random.nextFloat() * 0.5f, 50 + random.nextInt(20)).setDeltaX(random.nextFloat() * motion.x).setDeltaY(random.nextFloat() * motion.y));
                    }
                    soundManager.play((SoundInstance)SimpleSoundInstance.forUI((SoundEvent)SoundEvents.WITHER_BREAK_BLOCK, (float)1.0f));
                    soundManager.play((SoundInstance)SimpleSoundInstance.forUI((Holder)SoundEvents.GENERIC_EXPLODE, (float)1.0f));
                }
            }
        } else {
            this.shakeDelta = Math.min(20, this.shakeDelta + 10);
            this.colorDelta = Math.min(20, this.colorDelta + 10);
            soundManager.play((SoundInstance)SimpleSoundInstance.forUI((SoundEvent)SoundEvents.CHAIN_BREAK, (float)1.0f));
        }
    }

    public void renderWidget(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTick) {
        Item item;
        LocalPlayer player = Minecraft.getInstance().player;
        if (player == null || !((item = this.screen.stack.getItem()) instanceof IRelicItem)) {
            return;
        }
        IRelicItem relic = (IRelicItem)item;
        ItemStack stack = this.screen.getStack();
        TextureManager manager = this.minecraft.getTextureManager();
        PoseStack poseStack = guiGraphics.pose();
        int unlocks = relic.getLockUnlocks(stack, this.ability);
        boolean isEnoughLevel = relic.isEnoughLevel(stack, this.ability);
        boolean isLockUnlocked = relic.isLockUnlocked(stack, this.ability);
        boolean isAbilityResearched = relic.isAbilityResearched(stack, this.ability);
        boolean canUse = isEnoughLevel && isLockUnlocked && isAbilityResearched;
        boolean canUpgrade = relic.mayPlayerUpgrade((Player)this.minecraft.player, stack, this.ability);
        boolean canResearch = relic.mayResearch(stack, this.ability);
        boolean canBeUpgraded = relic.canBeUpgraded(stack, this.ability);
        boolean hasAction = canUpgrade || canResearch;
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.enableBlend();
        poseStack.pushPose();
        float partialTicks = this.minecraft.getTimer().getGameTimeDeltaPartialTick(false);
        float lerpedScale = Mth.lerp((float)partialTicks, (float)this.scaleOld, (float)this.scale);
        poseStack.scale(lerpedScale, lerpedScale, lerpedScale);
        poseStack.translate(((float)this.getX() + (float)this.width / 2.0f) / lerpedScale, ((float)this.getY() + (float)this.height / 2.0f) / lerpedScale, 0.0f);
        float color = (float)((double)(canUpgrade ? 0.75f : 1.05f) + Math.sin((float)(player.tickCount + this.ability.length() * 10) * 0.2f) * (double)0.1f);
        if (isLockUnlocked) {
            GUIRenderer.begin(DescriptionTextures.getAbilityCardTexture(stack, this.ability), poseStack).color(color, color, color, 1.0f).texSize(22, 31).scale(1.01f).end();
        }
        if (!canUse) {
            GUIRenderer.begin(isLockUnlocked ? DescriptionTextures.SMALL_CARD_RESEARCH_BACKGROUND : DescriptionTextures.SMALL_CARD_LOCK_BACKGROUND, poseStack).scale(1.01f).end();
        }
        GUIRenderer.begin(canBeUpgraded ? (canUse ? DescriptionTextures.SMALL_CARD_FRAME_UNLOCKED_ACTIVE : DescriptionTextures.SMALL_CARD_FRAME_UNLOCKED_INACTIVE) : (canUse ? DescriptionTextures.SMALL_CARD_FRAME_LOCKED_ACTIVE : DescriptionTextures.SMALL_CARD_FRAME_LOCKED_INACTIVE), poseStack).end();
        if (this.isHovered()) {
            GUIRenderer.begin(DescriptionTextures.SMALL_CARD_FRAME_OUTLINE, poseStack).pos(0.0f, 0.5f).end();
        }
        if (isLockUnlocked) {
            if (!isAbilityResearched) {
                float time = (float)this.minecraft.player.tickCount + (float)this.ability.length() * 10.0f + partialTick;
                GUIRenderer.begin(DescriptionTextures.RESEARCH, poseStack).pos((float)Math.sin(time * 0.25f), (float)Math.cos(time * 0.25f) + 0.5f).patternSize(16, 16).animation(AnimationData.builder().frame(0, 2).frame(1, 2).frame(2, 2).frame(3, 2).frame(4, 2).frame(5, 2).frame(6, 2).frame(7, 2).frame(8, 2).frame(9, 2).frame(10, 2).frame(11, 40)).end();
            }
        } else {
            GUIRenderer.begin(isEnoughLevel ? ResourceLocation.fromNamespaceAndPath((String)"relics", (String)("textures/gui/description/relic/chains_active_" + unlocks + ".png")) : DescriptionTextures.CHAINS_INACTIVE, poseStack).pos(0.0f, -1.0f).end();
            MutableComponent level = Component.literal((String)String.valueOf(relic.getAbilityData(this.ability).getRequiredLevel())).withStyle(ChatFormatting.BOLD);
            color = Math.min(0.75f, (float)this.colorDelta * 0.04f);
            RenderSystem.setShaderColor((float)1.0f, (float)(1.0f - color), (float)(1.0f - color), (float)1.0f);
            poseStack.pushPose();
            if (this.shakeDelta > 0) {
                poseStack.mulPose(Axis.ZP.rotation((float)Math.sin(((float)player.tickCount + partialTick) * 0.75f) * ((float)this.shakeDelta / 30.0f * 0.75f)));
            }
            GUIRenderer.begin(isEnoughLevel ? ResourceLocation.fromNamespaceAndPath((String)"relics", (String)("textures/gui/description/relic/icons/lock_active_" + unlocks + ".png")) : DescriptionTextures.LOCK_INACTIVE, poseStack).end();
            poseStack.scale(0.5f, 0.5f, 0.5f);
            guiGraphics.drawString(this.minecraft.font, (Component)level, (-(this.width / 2) + 16) * 2 - this.minecraft.font.width((FormattedText)level) / 2, (-(this.height / 2) + 24) * 2, isEnoughLevel ? 16769656 : 12037849, true);
            RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            poseStack.popPose();
        }
        if (canUse && canUpgrade) {
            RenderSystem.setShaderTexture((int)0, (ResourceLocation)DescriptionTextures.UPGRADE);
            manager.bindForSetup(DescriptionTextures.UPGRADE);
            RenderSystem.enableBlend();
            RenderUtils.renderAnimatedTextureFromCenter(poseStack, 0.0f, -1.0f, 20.0f, 400.0f, 20.0f, 20.0f, 0.9f + (float)(Math.sin(((float)player.tickCount + partialTick) * 0.25f) * (double)0.025f), AnimationData.builder().frame(0, 2).frame(1, 2).frame(2, 2).frame(3, 2).frame(4, 2).frame(5, 2).frame(6, 2).frame(7, 2).frame(8, 2).frame(9, 2).frame(10, 2).frame(11, 2).frame(12, 2).frame(13, 2).frame(14, 2).frame(15, 2).frame(16, 2).frame(17, 2).frame(18, 2).frame(19, 2));
            RenderSystem.disableBlend();
        }
        if (canBeUpgraded && canUse) {
            int xOff = 0;
            for (int i = 0; i < 5; ++i) {
                guiGraphics.blit(DescriptionTextures.SMALL_STAR_HOLE, -(this.width / 2) + xOff + 4, -(this.height / 2) + 40, 0.0f, 0.0f, 4, 4, 4, 4);
                xOff += 5;
            }
            xOff = 0;
            int quality = relic.getAbilityQuality(this.screen.stack, this.ability);
            boolean isAliquot = quality % 2 == 1;
            int i = 0;
            while ((double)i < Math.floor((double)quality / 2.0)) {
                guiGraphics.blit(DescriptionTextures.SMALL_STAR_ACTIVE, -(this.width / 2) + xOff + 4, -(this.height / 2) + 40, 0.0f, 0.0f, 4, 4, 4, 4);
                xOff += 5;
                ++i;
            }
            if (isAliquot) {
                guiGraphics.blit(DescriptionTextures.SMALL_STAR_ACTIVE, -(this.width / 2) + xOff + 4, -(this.height / 2) + 40, 0.0f, 0.0f, 2, 4, 4, 4);
            }
        }
        if (canBeUpgraded) {
            MutableComponent title = Component.literal((String)(canUse ? String.valueOf(relic.getAbilityLevel(this.screen.stack, this.ability)) : "?")).withStyle(ChatFormatting.BOLD);
            float textScale = 0.5f;
            poseStack.scale(textScale, textScale, textScale);
            guiGraphics.drawString(this.minecraft.font, (Component)title, -((this.width + 1) / 2) - this.minecraft.font.width((FormattedText)title) / 2 + 16, -(this.height / 2) - 19, canUse ? 16769656 : 12037849, true);
        }
        RenderSystem.disableBlend();
        poseStack.popPose();
    }

    @Override
    public void onTick() {
        Item item = this.screen.stack.getItem();
        if (!(item instanceof IRelicItem)) {
            return;
        }
        IRelicItem relic = (IRelicItem)item;
        float maxScale = 1.15f;
        float minScale = 1.0f;
        RandomSource random = this.minecraft.player.getRandom();
        boolean canUpgrade = relic.mayPlayerUpgrade((Player)this.minecraft.player, this.screen.stack, this.ability);
        boolean canResearch = relic.mayResearch(this.screen.stack, this.ability);
        if ((canUpgrade || canResearch) && this.minecraft.player.tickCount % 7 == 0) {
            ParticleStorage.addParticle(this.screen, new ExperienceParticleData(new Color(200 + random.nextInt(50), 150 + random.nextInt(100), 0), this.getX() + 5 + random.nextInt(18), this.getY() + 18, 1.0f + random.nextFloat() * 0.5f, 100 + random.nextInt(50)));
        }
        this.scaleOld = this.scale;
        if (this.scale > maxScale) {
            this.scale = Math.max(minScale, this.scale - 0.01f);
        }
        if (this.isHovered()) {
            if (this.minecraft.player.tickCount % 3 == 0) {
                ParticleStorage.addParticle(this.screen, new ExperienceParticleData(new Color(200 + random.nextInt(50), 150 + random.nextInt(100), 0), this.getX() + random.nextInt(this.width), this.getY() - 1, 1.0f + random.nextFloat() * 0.5f, 100 + random.nextInt(50)));
            }
            if (this.scale < maxScale) {
                this.scale = Math.min(maxScale, this.scale + 0.04f);
            }
        } else if (this.scale > minScale) {
            this.scale = Math.max(minScale, this.scale - 0.03f);
        }
        if (this.shakeDelta > 0) {
            --this.shakeDelta;
        }
        if (this.colorDelta > 0) {
            --this.colorDelta;
        }
    }

    @Override
    public boolean isLocked() {
        return this.screen.getSelectedAbility().equals(this.ability);
    }

    @Override
    public void onHovered(GuiGraphics guiGraphics, int mouseX, int mouseY) {
        ItemStack stack = this.screen.stack;
        Item item = stack.getItem();
        if (!(item instanceof IRelicItem)) {
            return;
        }
        IRelicItem relic = (IRelicItem)item;
        AbilityData data = relic.getAbilityData(this.ability);
        if (data == null) {
            return;
        }
        PoseStack poseStack = guiGraphics.pose();
        ArrayList tooltip = Lists.newArrayList();
        MutableComponent title = Component.translatableWithFallback((String)("tooltip.relics." + BuiltInRegistries.ITEM.getKey((Object)stack.getItem()).getPath() + ".ability." + this.ability), (String)this.ability);
        int maxWidth = 110;
        int renderWidth = Math.min(this.minecraft.font.width((FormattedText)title.withStyle(ChatFormatting.BOLD)) / 2 + 4, maxWidth);
        ArrayList<MutableComponent> entries = new ArrayList<MutableComponent>();
        entries.add(Component.literal((String)" "));
        int level = relic.getRelicLevel(this.screen.stack);
        int requiredLevel = data.getRequiredLevel();
        if (level < requiredLevel) {
            entries.add(Component.literal((String)" "));
            entries.add(Component.literal((String)"").append((Component)Component.translatable((String)"tooltip.relics.researching.relic.card.low_level", (Object[])new Object[]{Component.literal((String)String.valueOf(requiredLevel)).withStyle(ChatFormatting.BOLD)})));
        } else if (!relic.isLockUnlocked(this.screen.stack, this.ability)) {
            entries.add(Component.literal((String)" "));
            entries.add(Component.literal((String)"").append((Component)Component.translatable((String)"tooltip.relics.researching.relic.card.ready_to_unlock", (Object[])new Object[]{Component.literal((String)String.valueOf(relic.getMaxLockUnlocks() - relic.getLockUnlocks(this.screen.stack, this.ability))).withStyle(ChatFormatting.BOLD)})));
        } else if (!relic.isAbilityResearched(this.screen.stack, this.ability)) {
            entries.add(Component.literal((String)" "));
            entries.add(Component.literal((String)"").append((Component)Component.translatable((String)"tooltip.relics.researching.relic.card.unresearched")));
        } else if (relic.mayPlayerUpgrade((Player)this.minecraft.player, this.screen.stack, this.ability)) {
            entries.add(Component.literal((String)" "));
            entries.add(Component.literal((String)"").append((Component)Component.translatable((String)"tooltip.relics.researching.relic.card.ready_to_upgrade")));
        }
        for (MutableComponent entry : entries) {
            int entryWidth = this.minecraft.font.width((FormattedText)entry) / 2;
            if (entryWidth > renderWidth) {
                renderWidth = Math.min(entryWidth + 4, maxWidth);
            }
            tooltip.addAll(this.minecraft.font.split((FormattedText)entry, maxWidth * 2));
        }
        int height = tooltip.size() * 5;
        int y = this.getHeight() / 2;
        float partialTicks = this.minecraft.getTimer().getGameTimeDeltaPartialTick(false);
        float lerpedScale = Mth.lerp((float)partialTicks, (float)this.scaleOld, (float)this.scale);
        poseStack.scale(lerpedScale, lerpedScale, lerpedScale);
        poseStack.translate(((float)this.getX() + (float)this.getWidth() / 2.0f) / lerpedScale, ((float)this.getY() + (float)this.getHeight() / 2.0f) / lerpedScale, 0.0f);
        DescriptionUtils.drawTooltipBackground(guiGraphics, renderWidth, height, -((renderWidth + 19) / 2), y);
        int yOff = 0;
        poseStack.pushPose();
        poseStack.scale(0.5f, 0.5f, 0.5f);
        if (!relic.isAbilityUnlocked(stack, this.ability)) {
            title = ScreenUtils.stylizeWithReplacement(title, 1.0, Style.EMPTY.withFont(ScreenUtils.ILLAGER_ALT_FONT).withColor(10354864), (long)this.ability.length());
            RandomSource random = this.minecraft.player.getRandom();
            float shakeX = MathUtils.randomFloat(random) * 0.5f;
            float shakeY = MathUtils.randomFloat(random) * 0.5f;
            poseStack.translate(shakeX, shakeY, 0.0f);
        } else {
            title.withStyle(ChatFormatting.BOLD);
        }
        guiGraphics.drawString(this.minecraft.font, (Component)title, -(this.minecraft.font.width((FormattedText)title) / 2), (y + yOff + 9) * 2, 6696723, false);
        poseStack.popPose();
        for (FormattedCharSequence entry : tooltip) {
            poseStack.pushPose();
            poseStack.scale(0.5f, 0.5f, 0.5f);
            guiGraphics.drawString(this.minecraft.font, entry, -(this.minecraft.font.width(entry) / 2), (y + yOff + 9) * 2, 6696723, false);
            yOff += 5;
            poseStack.popPose();
        }
    }

    @Override
    public void playDownSound(SoundManager handler) {
        IRelicItem relic;
        Item item;
        if (!this.isLocked() && (item = this.screen.getStack().getItem()) instanceof IRelicItem && (relic = (IRelicItem)item).isAbilityUnlocked(this.screen.stack, this.ability)) {
            super.playDownSound(handler);
        }
    }
}

