/*
 * Decompiled with CFR 0.152.
 */
package it.hurts.sskirillss.relics.blocks;

import com.mojang.serialization.MapCodec;
import it.hurts.sskirillss.relics.init.TileRegistry;
import it.hurts.sskirillss.relics.tiles.ResearchingTableTile;
import it.hurts.sskirillss.relics.utils.TickerUtils;
import net.minecraft.core.BlockPos;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.HorizontalDirectionalBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ResearchingTableBlock
extends HorizontalDirectionalBlock
implements EntityBlock {
    public ResearchingTableBlock(BlockBehaviour.Properties properties) {
        super(properties);
    }

    public void onRemove(BlockState state, Level worldIn, BlockPos pos, BlockState newState, boolean isMoving) {
        ResearchingTableTile tile;
        ItemStack stack;
        BlockEntity blockEntity;
        if (!state.is(newState.getBlock()) && (blockEntity = worldIn.getBlockEntity(pos)) instanceof ResearchingTableTile && (stack = (tile = (ResearchingTableTile)blockEntity).getStack()) != null && !stack.isEmpty()) {
            worldIn.addFreshEntity((Entity)new ItemEntity(worldIn, (double)pos.getX(), (double)pos.getY(), (double)pos.getZ(), stack));
        }
        super.onRemove(state, worldIn, pos, newState, isMoving);
    }

    public VoxelShape getShape(BlockState state, BlockGetter reader, BlockPos pos, CollisionContext context) {
        return Block.box((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)15.0, (double)16.0);
    }

    @Nullable
    public <T extends BlockEntity> BlockEntityTicker<T> getTicker(Level level, BlockState state, BlockEntityType<T> type) {
        return TickerUtils.getTicker(type, (BlockEntityType)TileRegistry.RESEARCHING_TABLE.get(), ResearchingTableTile::tick);
    }

    @Nullable
    public BlockEntity newBlockEntity(BlockPos pos, BlockState state) {
        return new ResearchingTableTile(pos, state);
    }

    public void createBlockStateDefinition(// Could not load outer class - annotation placement on inner may be incorrect
     @NotNull StateDefinition.Builder<Block, BlockState> builder) {
        super.createBlockStateDefinition(builder);
        builder.add(new Property[]{FACING});
    }

    @Nullable
    public BlockState getStateForPlacement(BlockPlaceContext context) {
        return (BlockState)this.defaultBlockState().setValue((Property)FACING, (Comparable)context.getHorizontalDirection().getOpposite());
    }

    protected MapCodec<? extends HorizontalDirectionalBlock> codec() {
        return ResearchingTableBlock.simpleCodec(ResearchingTableBlock::new);
    }
}

