/*
 * Decompiled with CFR 0.152.
 */
package earth.terrarium.handcrafted.common.blocks.crockery;

import com.mojang.serialization.MapCodec;
import earth.terrarium.handcrafted.common.blocks.base.SimpleBlock;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.HorizontalDirectionalBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CrockeryBlock
extends SimpleBlock {
    public static final MapCodec<CrockeryBlock> CODEC = CrockeryBlock.simpleCodec(CrockeryBlock::new);
    public static final IntegerProperty PIECES = IntegerProperty.create((String)"pieces", (int)1, (int)6);
    public static final VoxelShape SHAPE_1 = Block.box((double)3.0, (double)0.0, (double)3.0, (double)13.0, (double)1.0, (double)13.0);
    public static final VoxelShape SHAPE_2 = Block.box((double)3.0, (double)0.0, (double)3.0, (double)13.0, (double)2.0, (double)13.0);
    public static final VoxelShape SHAPE_3 = Block.box((double)3.0, (double)0.0, (double)3.0, (double)13.0, (double)3.0, (double)13.0);
    public static final VoxelShape SHAPE_4 = Block.box((double)3.0, (double)0.0, (double)3.0, (double)13.0, (double)4.0, (double)13.0);
    public static final VoxelShape SHAPE_5 = Block.box((double)3.0, (double)0.0, (double)3.0, (double)13.0, (double)5.0, (double)13.0);
    public static final VoxelShape SHAPE_6 = Block.box((double)3.0, (double)0.0, (double)3.0, (double)13.0, (double)6.0, (double)13.0);

    public CrockeryBlock(BlockBehaviour.Properties properties) {
        super(properties);
        this.registerDefaultState((BlockState)((BlockState)((BlockState)this.defaultBlockState().setValue((Property)PIECES, (Comparable)Integer.valueOf(1))).setValue((Property)FACING, (Comparable)Direction.NORTH)).setValue((Property)WATERLOGGED, (Comparable)Boolean.valueOf(false)));
    }

    protected MapCodec<? extends HorizontalDirectionalBlock> codec() {
        return CODEC;
    }

    @Override
    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        builder.add(new Property[]{FACING, PIECES, WATERLOGGED});
    }

    public boolean canBeReplaced(BlockState state, BlockPlaceContext useContext) {
        return !useContext.isSecondaryUseActive() && useContext.getItemInHand().is(this.asItem()) && (Integer)state.getValue((Property)PIECES) < 6 || super.canBeReplaced(state, useContext);
    }

    @NotNull
    public VoxelShape getShape(BlockState state, BlockGetter level, BlockPos pos, CollisionContext context) {
        return switch ((Integer)state.getValue((Property)PIECES)) {
            case 2 -> SHAPE_2;
            case 3 -> SHAPE_3;
            case 4 -> SHAPE_4;
            case 5 -> SHAPE_5;
            case 6 -> SHAPE_6;
            default -> SHAPE_1;
        };
    }

    @Override
    @Nullable
    public BlockState getStateForPlacement(BlockPlaceContext context) {
        BlockState state = context.getLevel().getBlockState(context.getClickedPos());
        if (state.is((Block)this)) {
            return (BlockState)state.setValue((Property)PIECES, (Comparable)Integer.valueOf(Math.min(6, (Integer)state.getValue((Property)PIECES) + 1)));
        }
        FluidState fluidState = context.getLevel().getFluidState(context.getClickedPos());
        boolean bl = fluidState.getType() == Fluids.WATER;
        BlockState placementState = super.getStateForPlacement(context);
        if (placementState == null) {
            return null;
        }
        return (BlockState)placementState.setValue((Property)WATERLOGGED, (Comparable)Boolean.valueOf(bl));
    }

    public static String piecesName(BlockState state) {
        return switch ((Integer)state.getValue((Property)PIECES)) {
            case 2 -> "double";
            case 3 -> "triple";
            case 4 -> "quadruple";
            case 5 -> "quintuple";
            case 6 -> "sextuple";
            default -> "single";
        };
    }
}

