/*
 * Decompiled with CFR 0.152.
 */
package com.seibel.distanthorizons.core.config;

import com.seibel.distanthorizons.core.config.Config;
import com.seibel.distanthorizons.core.config.file.ConfigFileHandler;
import com.seibel.distanthorizons.core.config.types.AbstractConfigType;
import com.seibel.distanthorizons.core.config.types.ConfigCategory;
import com.seibel.distanthorizons.core.config.types.ConfigEntry;
import com.seibel.distanthorizons.core.config.types.ConfigUIComment;
import com.seibel.distanthorizons.core.config.types.ConfigUISpacer;
import com.seibel.distanthorizons.core.config.types.ConfigUiLinkedEntry;
import com.seibel.distanthorizons.core.dependencyInjection.SingletonInjector;
import com.seibel.distanthorizons.core.logging.DhLoggerBuilder;
import com.seibel.distanthorizons.core.wrapperInterfaces.config.ILangWrapper;
import com.seibel.distanthorizons.core.wrapperInterfaces.minecraft.IMinecraftSharedWrapper;
import java.lang.reflect.Field;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.logging.log4j.Logger;

public class ConfigBase {
    public static ConfigBase INSTANCE;
    private static final Logger LOGGER;
    public static final List<Class<?>> ACCEPTABLE_INPUTS;
    public ConfigFileHandler configFileHandler;
    public final int configVersion;
    public boolean isLoaded = false;
    public boolean disableMinMax = false;
    public final List<AbstractConfigType<?, ?>> entries = new ArrayList();

    public static void RunFirstTimeSetup() {
        if (INSTANCE != null) {
            LOGGER.debug("ConfigBase setup already run, ignoring.");
            return;
        }
        INSTANCE = new ConfigBase(Config.class, 3);
    }

    private ConfigBase(Class<?> configClass, int configVersion) {
        LOGGER.info("Initialising config for [DistantHorizons]");
        this.configVersion = configVersion;
        this.initNestedClass(configClass, "");
        Path configPath = ConfigBase.getConfigPath("DistantHorizons");
        this.configFileHandler = new ConfigFileHandler(this, configPath);
        this.configFileHandler.loadFromFile();
        this.isLoaded = true;
        LOGGER.info("Config for [DistantHorizons] initialised");
    }

    private static Path getConfigPath(String modName) {
        return SingletonInjector.INSTANCE.get(IMinecraftSharedWrapper.class).getInstallationDirectory().toPath().resolve("config").resolve(modName + ".toml");
    }

    private void initNestedClass(Class<?> configClass, String category) {
        for (Field field : configClass.getFields()) {
            if (!AbstractConfigType.class.isAssignableFrom(field.getType())) continue;
            try {
                this.entries.add((AbstractConfigType)field.get(field.getType()));
            }
            catch (IllegalAccessException exception) {
                LOGGER.warn((Object)exception);
            }
            AbstractConfigType<?, ?> entry = this.entries.get(this.entries.size() - 1);
            entry.category = category;
            entry.name = field.getName();
            entry.configBase = this;
            if (ConfigEntry.class.isAssignableFrom(field.getType()) && !ConfigBase.isAcceptableType(entry.getType())) {
                LOGGER.error("Invalid variable type at [" + (category.isEmpty() ? "" : category + ".") + field.getName() + "].");
                LOGGER.error("Type [" + entry.getType() + "] is not one of these types [" + ACCEPTABLE_INPUTS.toString() + "]");
                this.entries.remove(this.entries.size() - 1);
            }
            if (!ConfigCategory.class.isAssignableFrom(field.getType())) continue;
            assert (entry instanceof ConfigCategory);
            if (((ConfigCategory)entry).getDestination() == null) {
                ((ConfigCategory)entry).destination = entry.getNameWCategory();
            }
            if (entry.get() == null) continue;
            this.initNestedClass((Class)((ConfigCategory)entry).get(), ((ConfigCategory)entry).getDestination());
        }
    }

    private static boolean isAcceptableType(Class<?> Clazz) {
        if (Clazz.isEnum()) {
            return true;
        }
        return ACCEPTABLE_INPUTS.contains(Clazz);
    }

    public String generateLang(boolean onlyShowMissing, boolean checkEnums) {
        ILangWrapper langWrapper = SingletonInjector.INSTANCE.get(ILangWrapper.class);
        ArrayList enumList = new ArrayList();
        String generatedLang = "";
        String starter = "  \"";
        String separator = "\":\n    \"";
        String ending = "\",\n";
        for (AbstractConfigType<?, ?> abstractConfigType : this.entries) {
            String entryPrefix = "distanthorizons.config." + abstractConfigType.getNameWCategory();
            if (checkEnums && abstractConfigType.getType().isEnum() && !enumList.contains(abstractConfigType.getType())) {
                enumList.add(abstractConfigType.getType());
            }
            if (!abstractConfigType.getAppearance().showInGui || ConfigUiLinkedEntry.class.isAssignableFrom(abstractConfigType.getClass()) || ConfigUISpacer.class.isAssignableFrom(abstractConfigType.getClass())) continue;
            if (ConfigUIComment.class.isAssignableFrom(abstractConfigType.getClass()) && ((ConfigUIComment)abstractConfigType).parentConfigPath != null) {
                entryPrefix = "distanthorizons.config." + ((ConfigUIComment)abstractConfigType).parentConfigPath;
            }
            if (langWrapper.langExists(entryPrefix) && onlyShowMissing) continue;
            generatedLang = generatedLang + starter + entryPrefix + separator + langWrapper.getLang(entryPrefix) + ending;
            if (langWrapper.langExists(entryPrefix + ".@tooltip") && onlyShowMissing) continue;
            generatedLang = generatedLang + starter + entryPrefix + ".@tooltip" + separator + langWrapper.getLang(entryPrefix + ".@tooltip").replaceAll("\n", "\\\\n").replaceAll("\"", "\\\\\"") + ending;
        }
        if (!enumList.isEmpty()) {
            generatedLang = generatedLang + "\n";
            for (Class clazz : enumList) {
                for (Object enumStr : new ArrayList(EnumSet.allOf(clazz))) {
                    String enumPrefix = "distanthorizons.config.enum." + clazz.getSimpleName() + "." + enumStr.toString();
                    if (langWrapper.langExists(enumPrefix) && onlyShowMissing) continue;
                    generatedLang = generatedLang + starter + enumPrefix + separator + langWrapper.getLang(enumPrefix) + ending;
                }
            }
        }
        return generatedLang;
    }

    static {
        LOGGER = DhLoggerBuilder.getLogger();
        ACCEPTABLE_INPUTS = new ArrayList<Class<?>>(){
            {
                this.add(Boolean.class);
                this.add(Byte.class);
                this.add(Integer.class);
                this.add(Double.class);
                this.add(Short.class);
                this.add(Long.class);
                this.add(Float.class);
                this.add(String.class);
                this.add(List.class);
                this.add(ArrayList.class);
                this.add(Map.class);
                this.add(HashMap.class);
            }
        };
    }
}

