/*
 * Decompiled with CFR 0.152.
 */
package com.brandon3055.brandonscore.init;

import com.brandon3055.brandonscore.client.BCClientEventHandler;
import com.brandon3055.brandonscore.client.BCGuiTextures;
import com.brandon3055.brandonscore.client.ProcessHandlerClient;
import com.brandon3055.brandonscore.client.hud.HudManager;
import com.brandon3055.brandonscore.client.model.EquippedItemModelLayer;
import com.brandon3055.brandonscore.client.shader.BCShaders;
import com.brandon3055.brandonscore.handlers.contributor.ContributorHandler;
import com.brandon3055.brandonscore.lib.DLRSCache;
import com.brandon3055.brandonscore.utils.BCProfiler;
import net.covers1624.quack.util.CrashLock;
import net.minecraft.client.Minecraft;
import net.minecraft.client.model.HumanoidModel;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.client.renderer.entity.LivingEntityRenderer;
import net.minecraft.client.resources.PlayerSkin;
import net.minecraft.world.entity.player.Player;
import net.neoforged.bus.api.IEventBus;
import net.neoforged.fml.event.lifecycle.FMLClientSetupEvent;
import net.neoforged.neoforge.client.event.EntityRenderersEvent;
import net.neoforged.neoforge.common.NeoForge;

public class BCClient {
    private static final CrashLock LOCK = new CrashLock("Already Initialized.");

    public static void init(IEventBus modBus) {
        LOCK.lock();
        modBus.addListener(BCClient::clientSetupEvent);
        modBus.addListener(BCClient::onAddRenderLayers);
        NeoForge.EVENT_BUS.addListener(event -> ContributorHandler.onClientLogin((Player)event.getPlayer()));
        ProcessHandlerClient.init();
        HudManager.init(modBus);
        BCShaders.init(modBus);
        BCProfiler.init();
        DLRSCache.init();
        BCGuiTextures.init(modBus);
    }

    private static void clientSetupEvent(FMLClientSetupEvent event) {
        BCClientEventHandler.init();
    }

    private static void onAddRenderLayers(EntityRenderersEvent.AddLayers event) {
        LivingEntityRenderer renderer;
        for (PlayerSkin.Model skin : event.getSkins()) {
            renderer = (LivingEntityRenderer)event.getSkin(skin);
            assert (renderer != null);
            renderer.addLayer(new EquippedItemModelLayer(renderer, skin.id().equals("slim")));
        }
        for (EntityRenderer r : Minecraft.getInstance().getEntityRenderDispatcher().renderers.values()) {
            if (!(r instanceof LivingEntityRenderer) || !((renderer = (LivingEntityRenderer)r).getModel() instanceof HumanoidModel)) continue;
            renderer.addLayer(new EquippedItemModelLayer(renderer, false));
        }
    }
}

