/*
 * Decompiled with CFR 0.152.
 */
package stepsword.mahoutsukai.render.entity.familiar;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Axis;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import it.unimi.dsi.fastutil.objects.ObjectList;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Random;
import net.minecraft.client.model.Model;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.core.Direction;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import org.joml.Matrix3f;
import org.joml.Matrix3fc;
import org.joml.Matrix4f;
import org.joml.Matrix4fc;
import org.joml.Vector3f;
import org.joml.Vector3fc;
import org.joml.Vector4f;
import stepsword.mahoutsukai.render.MahoujinRenderType;
import stepsword.mahoutsukai.render.entity.familiar.RenderFamiliarEntity;

@OnlyIn(value=Dist.CLIENT)
public class FamiliarModelRenderer
extends ModelPart {
    private float textureWidth;
    private float textureHeight;
    private int textureOffsetX;
    private int textureOffsetY;
    public float rotationPointX;
    public float rotationPointY;
    public float rotationPointZ;
    public float rotateAngleX;
    public float rotateAngleY;
    public float rotateAngleZ;
    public boolean mirror;
    public boolean showModel;
    public final ObjectList<ModelBox> cubeList;
    public final ObjectList<FamiliarModelRenderer> childModels;
    public boolean isRenderChild = false;

    public FamiliarModelRenderer(Model model) {
        super(new ArrayList(), new HashMap());
        this.textureWidth = 64.0f;
        this.textureHeight = 64.0f;
        this.showModel = true;
        this.cubeList = new ObjectArrayList();
        this.childModels = new ObjectArrayList();
    }

    public FamiliarModelRenderer(Model model, int texU, int texV) {
        super(new ArrayList(), new HashMap());
        this.cubeList = new ObjectArrayList();
        this.childModels = new ObjectArrayList();
        this.showModel = true;
        this.textureWidth = 64.0f;
        this.textureHeight = 64.0f;
    }

    public FamiliarModelRenderer(int texX, int texY, int offsetU, int offsetV) {
        super(new ArrayList(), new HashMap());
        this.textureWidth = 64.0f;
        this.textureHeight = 32.0f;
        this.showModel = true;
        this.cubeList = new ObjectArrayList();
        this.childModels = new ObjectArrayList();
        this.setTexSize(texX, texY);
        this.texOffs(offsetU, offsetV);
    }

    public void copyModelAngles(FamiliarModelRenderer renderer) {
        this.rotateAngleX = renderer.rotateAngleX;
        this.rotateAngleY = renderer.rotateAngleY;
        this.rotateAngleZ = renderer.rotateAngleZ;
        this.rotationPointX = renderer.rotationPointX;
        this.rotationPointY = renderer.rotationPointY;
        this.rotationPointZ = renderer.rotationPointZ;
    }

    public void addChild(FamiliarModelRenderer renderer) {
        this.childModels.add((Object)renderer);
    }

    public FamiliarModelRenderer texOffs(int offsetX, int offsetY) {
        this.textureOffsetX = offsetX;
        this.textureOffsetY = offsetY;
        return this;
    }

    public FamiliarModelRenderer addBox(String name, float x, float y, float z, int width, int height, int depth, float delta, int texX, int texY) {
        this.texOffs(texX, texY);
        this.addBox(this.textureOffsetX, this.textureOffsetY, x, y, z, width, height, depth, delta, delta, delta, this.mirror, false);
        return this;
    }

    public FamiliarModelRenderer addBox(float x, float y, float z, float width, float height, float depth) {
        this.addBox(this.textureOffsetX, this.textureOffsetY, x, y, z, width, height, depth, 0.0f, 0.0f, 0.0f, this.mirror, false);
        return this;
    }

    public FamiliarModelRenderer addBox(float x, float y, float z, float width, float height, float depth, boolean mirrorIn) {
        this.addBox(this.textureOffsetX, this.textureOffsetY, x, y, z, width, height, depth, 0.0f, 0.0f, 0.0f, mirrorIn, false);
        return this;
    }

    public void addBox(float x, float y, float z, float width, float height, float depth, float delta) {
        this.addBox(this.textureOffsetX, this.textureOffsetY, x, y, z, width, height, depth, delta, delta, delta, this.mirror, false);
    }

    public void addBox(float x, float y, float z, float width, float height, float depth, float deltaX, float deltaY, float deltaZ) {
        this.addBox(this.textureOffsetX, this.textureOffsetY, x, y, z, width, height, depth, deltaX, deltaY, deltaZ, this.mirror, false);
    }

    public void addBox(float x, float y, float z, float width, float height, float depth, float delta, boolean mirrorIn) {
        this.addBox(this.textureOffsetX, this.textureOffsetY, x, y, z, width, height, depth, delta, delta, delta, mirrorIn, false);
    }

    private void addBox(int texOffX, int texOffY, float x, float y, float z, float width, float height, float depth, float deltaX, float deltaY, float deltaZ, boolean mirorIn, boolean p_228305_13_) {
        this.cubeList.add((Object)new ModelBox(texOffX, texOffY, x, y, z, width, height, depth, deltaX, deltaY, deltaZ, mirorIn, this.textureWidth, this.textureHeight));
    }

    public void setPos(float rotationPointXIn, float rotationPointYIn, float rotationPointZIn) {
        this.rotationPointX = rotationPointXIn;
        this.rotationPointY = rotationPointYIn;
        this.rotationPointZ = rotationPointZIn;
    }

    public void render(PoseStack matrixStackIn, VertexConsumer bufferIn, int packedLightIn, int packedOverlayIn) {
        this.render(matrixStackIn, bufferIn, packedLightIn, packedOverlayIn, 1.0f, 1.0f, 1.0f, 1.0f);
    }

    public void render(PoseStack matrixStackIn, MultiBufferSource bufferIn, int packedLightIn, int packedOverlayIn) {
        this.render(matrixStackIn, bufferIn, packedLightIn, packedOverlayIn, 1.0f, 1.0f, 1.0f, 1.0f);
    }

    public void render(PoseStack matrixStackIn, MultiBufferSource bufferIn, int packedLightIn, int packedOverlayIn, float red, float green, float blue, float alpha) {
        if (!(!this.showModel || this.cubeList.isEmpty() && this.childModels.isEmpty())) {
            matrixStackIn.pushPose();
            this.translateAndRotate(matrixStackIn);
            VertexConsumer bb = this.isRenderChild ? bufferIn.getBuffer(MahoujinRenderType.createMahoujinRenderType(RenderFamiliarEntity.t2, 0, false)) : bufferIn.getBuffer(MahoujinRenderType.createMahoujinRenderType(RenderFamiliarEntity.t1, 0, false));
            if (!this.isRenderChild) {
                this.doRender(matrixStackIn.last(), bb, packedLightIn, packedOverlayIn, red, green, blue, alpha);
            } else {
                this.doRender(matrixStackIn.last(), bb, packedLightIn, packedOverlayIn, 1.0f, 1.0f, 1.0f, 1.0f);
            }
            for (FamiliarModelRenderer offsetu : this.childModels) {
                offsetu.render(matrixStackIn, bufferIn, packedLightIn, packedOverlayIn, red, green, blue, alpha);
            }
            matrixStackIn.popPose();
        }
    }

    public void render(PoseStack matrixStackIn, VertexConsumer bufferIn, int packedLightIn, int packedOverlayIn, float red, float green, float blue, float alpha) {
        if (!(!this.showModel || this.cubeList.isEmpty() && this.childModels.isEmpty())) {
            matrixStackIn.pushPose();
            this.translateAndRotate(matrixStackIn);
            this.doRender(matrixStackIn.last(), bufferIn, packedLightIn, packedOverlayIn, red, green, blue, alpha);
            for (FamiliarModelRenderer offsetu : this.childModels) {
                offsetu.render(matrixStackIn, bufferIn, packedLightIn, packedOverlayIn, red, green, blue, alpha);
            }
            matrixStackIn.popPose();
        }
    }

    public void translateAndRotate(PoseStack matrixStackIn) {
        matrixStackIn.translate((double)(this.rotationPointX / 16.0f), (double)(this.rotationPointY / 16.0f), (double)(this.rotationPointZ / 16.0f));
        if (this.rotateAngleZ != 0.0f) {
            matrixStackIn.mulPose(Axis.ZP.rotation(this.rotateAngleZ));
        }
        if (this.rotateAngleY != 0.0f) {
            matrixStackIn.mulPose(Axis.YP.rotation(this.rotateAngleY));
        }
        if (this.rotateAngleX != 0.0f) {
            matrixStackIn.mulPose(Axis.XP.rotation(this.rotateAngleX));
        }
    }

    private void doRender(PoseStack.Pose matrixEntryIn, VertexConsumer builder, int light, int overlay, float r, float g, float b, float a) {
        Matrix4f lvt_9_1_ = matrixEntryIn.pose();
        Matrix3f offsetu = matrixEntryIn.normal();
        for (ModelBox box : this.cubeList) {
            for (TexturedQuad endY : box.quads) {
                Vector3f endZ = new Vector3f((Vector3fc)endY.normal);
                endZ.mul((Matrix3fc)offsetu);
                float zx = endZ.x();
                float zy = endZ.y();
                float zz = endZ.z();
                for (int k = 0; k < 4; ++k) {
                    PositionTextureVertex vertex = endY.vertexPositions[k];
                    float lvt_23_1_ = vertex.position.x() / 16.0f;
                    float lvt_24_1_ = vertex.position.y() / 16.0f;
                    float lvt_25_1_ = vertex.position.z() / 16.0f;
                    Vector4f vec = new Vector4f(lvt_23_1_, lvt_24_1_, lvt_25_1_, 1.0f);
                    vec.mul((Matrix4fc)lvt_9_1_);
                    builder.addVertex(vec.x(), vec.y(), vec.z()).setColor(r, g, b, a).setUv(vertex.textureU, vertex.textureV).setOverlay(overlay).setUv2(light, light).setNormal(zx, zy, zz);
                }
            }
        }
    }

    public FamiliarModelRenderer setTexSize(int textureWidthIn, int textureHeightIn) {
        this.textureWidth = textureWidthIn;
        this.textureHeight = textureHeightIn;
        return this;
    }

    public ModelBox getRandomCube(Random randomIn) {
        return (ModelBox)((Object)this.cubeList.get(randomIn.nextInt(this.cubeList.size())));
    }

    @OnlyIn(value=Dist.CLIENT)
    public static class ModelBox
    extends ModelPart.Cube {
        private final TexturedQuad[] quads;
        public final float posX1;
        public final float posY1;
        public final float posZ1;
        public final float posX2;
        public final float posY2;
        public final float posZ2;

        public ModelBox(int texOffX, int texOffY, float x, float y, float z, float width, float height, float depth, float deltaX, float deltaY, float deltaZ, boolean mirrorIn, float texHeight, float texWidth) {
            super(texOffX, texOffY, x, y, z, width, height, depth, deltaX, deltaY, deltaZ, mirrorIn, texHeight, texWidth, new HashSet());
            this.posX1 = x;
            this.posY1 = y;
            this.posZ1 = z;
            this.posX2 = x + width;
            this.posY2 = y + height;
            this.posZ2 = z + depth;
            this.quads = new TexturedQuad[6];
            float endX = x + width;
            float endY = y + height;
            float endZ = z + depth;
            x -= deltaX;
            y -= deltaY;
            z -= deltaZ;
            endX += deltaX;
            endY += deltaY;
            endZ += deltaZ;
            if (mirrorIn) {
                float swap = endX;
                endX = x;
                x = swap;
            }
            PositionTextureVertex lvt_18_2_ = new PositionTextureVertex(x, y, z, 0.0f, 0.0f);
            PositionTextureVertex lvt_19_1_ = new PositionTextureVertex(endX, y, z, 0.0f, 8.0f);
            PositionTextureVertex lvt_20_1_ = new PositionTextureVertex(endX, endY, z, 8.0f, 8.0f);
            PositionTextureVertex k = new PositionTextureVertex(x, endY, z, 8.0f, 0.0f);
            PositionTextureVertex lvt_22_1_ = new PositionTextureVertex(x, y, endZ, 0.0f, 0.0f);
            PositionTextureVertex lvt_23_1_ = new PositionTextureVertex(endX, y, endZ, 0.0f, 8.0f);
            PositionTextureVertex lvt_24_1_ = new PositionTextureVertex(endX, endY, endZ, 8.0f, 8.0f);
            PositionTextureVertex lvt_25_1_ = new PositionTextureVertex(x, endY, endZ, 8.0f, 0.0f);
            float vec = texOffX;
            float lvt_27_1_ = (float)texOffX + depth;
            float lvt_28_1_ = (float)texOffX + depth + width;
            float lvt_29_1_ = (float)texOffX + depth + width + width;
            float lvt_30_1_ = (float)texOffX + depth + width + depth;
            float lvt_31_1_ = (float)texOffX + depth + width + depth + width;
            float lvt_32_1_ = texOffY;
            float lvt_33_1_ = (float)texOffY + depth;
            float lvt_34_1_ = (float)texOffY + depth + height;
            this.quads[2] = new TexturedQuad(new PositionTextureVertex[]{lvt_23_1_, lvt_22_1_, lvt_18_2_, lvt_19_1_}, lvt_27_1_, lvt_32_1_, lvt_28_1_, lvt_33_1_, texHeight, texWidth, mirrorIn, Direction.DOWN);
            this.quads[3] = new TexturedQuad(new PositionTextureVertex[]{lvt_20_1_, k, lvt_25_1_, lvt_24_1_}, lvt_28_1_, lvt_33_1_, lvt_29_1_, lvt_32_1_, texHeight, texWidth, mirrorIn, Direction.UP);
            this.quads[1] = new TexturedQuad(new PositionTextureVertex[]{lvt_18_2_, lvt_22_1_, lvt_25_1_, k}, vec, lvt_33_1_, lvt_27_1_, lvt_34_1_, texHeight, texWidth, mirrorIn, Direction.WEST);
            this.quads[4] = new TexturedQuad(new PositionTextureVertex[]{lvt_19_1_, lvt_18_2_, k, lvt_20_1_}, lvt_27_1_, lvt_33_1_, lvt_28_1_, lvt_34_1_, texHeight, texWidth, mirrorIn, Direction.NORTH);
            this.quads[0] = new TexturedQuad(new PositionTextureVertex[]{lvt_23_1_, lvt_19_1_, lvt_20_1_, lvt_24_1_}, lvt_28_1_, lvt_33_1_, lvt_30_1_, lvt_34_1_, texHeight, texWidth, mirrorIn, Direction.EAST);
            this.quads[5] = new TexturedQuad(new PositionTextureVertex[]{lvt_22_1_, lvt_23_1_, lvt_24_1_, lvt_25_1_}, lvt_30_1_, lvt_33_1_, lvt_31_1_, lvt_34_1_, texHeight, texWidth, mirrorIn, Direction.SOUTH);
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    static class TexturedQuad {
        public final PositionTextureVertex[] vertexPositions;
        public final Vector3f normal;

        public TexturedQuad(PositionTextureVertex[] positions, float u1, float v1, float u2, float v2, float texWidth, float texHeight, boolean mirror, Direction facing) {
            this.vertexPositions = positions;
            float offsetu = 0.0f / texWidth;
            float offsetv = 0.0f / texHeight;
            positions[0] = positions[0].setTextureUV(0.0f, 0.0f);
            positions[1] = positions[1].setTextureUV(0.0f, 1.0f);
            positions[2] = positions[2].setTextureUV(1.0f, 1.0f);
            positions[3] = positions[3].setTextureUV(1.0f, 0.0f);
            if (mirror) {
                int box = positions.length;
                for (int lvt_13_1_ = 0; lvt_13_1_ < box / 2; ++lvt_13_1_) {
                    PositionTextureVertex lvt_14_1_ = positions[lvt_13_1_];
                    positions[lvt_13_1_] = positions[box - 1 - lvt_13_1_];
                    positions[box - 1 - lvt_13_1_] = lvt_14_1_;
                }
            }
            this.normal = facing.step();
            if (mirror) {
                this.normal.mul(-1.0f, 1.0f, 1.0f);
            }
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    static class PositionTextureVertex {
        public final Vector3f position;
        public final float textureU;
        public final float textureV;

        public PositionTextureVertex(float x, float y, float z, float texU, float texV) {
            this(new Vector3f(x, y, z), texU, texV);
        }

        public PositionTextureVertex setTextureUV(float texU, float texV) {
            return new PositionTextureVertex(this.position, texU, texV);
        }

        public PositionTextureVertex(Vector3f posIn, float texU, float texV) {
            this.position = posIn;
            this.textureU = texU;
            this.textureV = texV;
        }
    }
}

