/*
 * Decompiled with CFR 0.152.
 */
package stepsword.mahoutsukai.render.entity;

import com.mojang.blaze3d.vertex.PoseStack;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.texture.TextureAtlas;
import net.minecraft.resources.ResourceLocation;
import stepsword.mahoutsukai.entity.mahoujin.GunBeamProjectileEntity;
import stepsword.mahoutsukai.render.MahoujinRenderType;
import stepsword.mahoutsukai.render.RenderUtils;

public class RenderGunBeamProjectile
extends EntityRenderer<GunBeamProjectileEntity> {
    static RenderType sphere1 = MahoujinRenderType.wrapCullLayer(MahoujinRenderType.createSphereRenderType(RenderUtils.beam, 0));
    static RenderType sphere2 = MahoujinRenderType.wrapCullLayer(MahoujinRenderType.createSphereRenderType(RenderUtils.beam, 1));
    static RenderType sphere3 = MahoujinRenderType.wrapCullLayer(MahoujinRenderType.createSphereRenderType(RenderUtils.beam, 2));
    static RenderType sphere4 = MahoujinRenderType.wrapCullLayer(MahoujinRenderType.createSphereRenderType(RenderUtils.beam, 3));
    static RenderType beam1 = MahoujinRenderType.wrapCullLayer(MahoujinRenderType.createBeamRenderType(RenderUtils.beam, 4));
    static RenderType beam2 = MahoujinRenderType.wrapCullLayer(MahoujinRenderType.createBeamRenderType(RenderUtils.beam, 5));

    public RenderGunBeamProjectile(EntityRendererProvider.Context renderManager) {
        super(renderManager);
    }

    public ResourceLocation getTextureLocation(GunBeamProjectileEntity entity) {
        return TextureAtlas.LOCATION_BLOCKS;
    }

    public void render(GunBeamProjectileEntity entity, float eyaw, float partialTicks, PoseStack matrix, MultiBufferSource buffer, int packedLight) {
    }

    public static void renderGunBeam(GunBeamProjectileEntity entity, double x, double y, double z, PoseStack matrix, float partialTicks) {
        float[] colors = entity.getColor();
        float r = colors[0];
        float g = colors[1];
        float b = colors[2];
        float a = colors[3];
        float r2 = colors[4];
        float g2 = colors[5];
        float b2 = colors[6];
        float a2 = colors[7];
        float radius = entity.getRadius();
        float length = entity.getLength();
        matrix.pushPose();
        matrix.translate(x, y, z);
        RenderUtils.rotateQ(entity.getRotationYaw(), 0.0f, 1.0f, 0.0f, matrix);
        RenderUtils.rotateQ(entity.getRotationPitch(), 1.0f, 0.0f, 0.0f, matrix);
        if (!entity.getFired()) {
            // empty if block
        }
        MultiBufferSource.BufferSource buf = Minecraft.getInstance().renderBuffers().bufferSource();
        float buffer = 0.02f;
        float factor = length < 0.1f ? 1.0f : Math.max(4.0f, 4.0f * length * length);
        matrix.scale(1.0f, factor, 1.0f);
        RenderUtils.renderSphere(matrix, (MultiBufferSource)buf, radius - buffer, 8, 240, 240, r2, g2, b2, a2, sphere1, 0.52f);
        matrix.translate(0.0f, -length / factor, 0.0f);
        RenderUtils.rotateQ(180.0f, 1.0f, 0.0f, 0.0f, matrix);
        RenderUtils.renderSphere(matrix, (MultiBufferSource)buf, radius - buffer, 8, 240, 240, r2, g2, b2, a2, sphere3, 0.52f);
        RenderUtils.rotateQ(180.0f, 1.0f, 0.0f, 0.0f, matrix);
        matrix.translate(0.0f, length / factor, 0.0f);
        matrix.scale(1.0f, 1.0f / factor, 1.0f);
        RenderUtils.renderRing(matrix, (MultiBufferSource)buf, 0.0, 90.0f, Math.max(0.0f, radius - buffer), length, 16, 240, 240, r2, g2, b2, a2, beam1);
        RenderUtils.renderRing(matrix, (MultiBufferSource)buf, 0.0, 90.0f, radius, length, 16, 240, 240, r, g, b, a, beam2);
        matrix.scale(1.0f, factor, 1.0f);
        RenderUtils.renderSphere(matrix, (MultiBufferSource)buf, radius, 16, 240, 240, r, g, b, a, sphere2, 0.5f);
        matrix.translate(0.0f, -length / factor, 0.0f);
        RenderUtils.rotateQ(180.0f, 1.0f, 0.0f, 0.0f, matrix);
        RenderUtils.renderSphere(matrix, (MultiBufferSource)buf, radius, 16, 240, 240, r, g, b, a, sphere4, 0.5f);
        buf.endBatch(sphere1);
        buf.endBatch(sphere3);
        buf.endBatch(beam1);
        buf.endBatch(beam2);
        buf.endBatch(sphere4);
        buf.endBatch(sphere2);
        matrix.popPose();
    }
}

