/*
 * Decompiled with CFR 0.152.
 */
package stepsword.mahoutsukai.networking;

import io.netty.buffer.ByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.neoforged.neoforge.network.handling.IPayloadContext;
import stepsword.mahoutsukai.entity.MentalDisplacementEntity;
import stepsword.mahoutsukai.networking.MahouPackets;

public class MentalDisplacementUpdatePacket
implements CustomPacketPayload {
    public int entityId;
    public double x;
    public double y;
    public double z;
    public double vx;
    public double vy;
    public double vz;
    public double yaw;
    public double pitch;
    public static final StreamCodec<ByteBuf, MentalDisplacementUpdatePacket> STREAM_CODEC = new StreamCodec<ByteBuf, MentalDisplacementUpdatePacket>(){

        public MentalDisplacementUpdatePacket decode(ByteBuf buf) {
            MentalDisplacementUpdatePacket packet = new MentalDisplacementUpdatePacket();
            packet.decode(buf);
            return packet;
        }

        public void encode(ByteBuf buf, MentalDisplacementUpdatePacket packet) {
            packet.encode(buf);
        }
    };

    public MentalDisplacementUpdatePacket() {
    }

    public MentalDisplacementUpdatePacket(Entity e, double x, double y, double z, double vx, double vy, double vz, double yaw, double pitch) {
        this.entityId = e.getId();
        this.x = x;
        this.y = y;
        this.z = z;
        this.vx = vx;
        this.vy = vy;
        this.vz = vz;
        this.yaw = yaw;
        this.pitch = pitch;
    }

    public void decode(ByteBuf buf) {
        this.entityId = buf.readInt();
        this.x = buf.readDouble();
        this.y = buf.readDouble();
        this.z = buf.readDouble();
        this.vx = buf.readDouble();
        this.vy = buf.readDouble();
        this.vz = buf.readDouble();
        this.yaw = buf.readDouble();
        this.pitch = buf.readDouble();
    }

    public void encode(ByteBuf buf) {
        buf.writeInt(this.entityId);
        buf.writeDouble(this.x);
        buf.writeDouble(this.y);
        buf.writeDouble(this.z);
        buf.writeDouble(this.vx);
        buf.writeDouble(this.vy);
        buf.writeDouble(this.vz);
        buf.writeDouble(this.yaw);
        buf.writeDouble(this.pitch);
    }

    public static void handle(MentalDisplacementUpdatePacket message, IPayloadContext context) {
        Player player = context.player();
        Level world = player.level();
        Entity e = world.getEntity(message.entityId);
        if (e instanceof MentalDisplacementEntity) {
            MentalDisplacementUpdatePacket.updatePosition((MentalDisplacementEntity)e, message);
        }
    }

    public static void updatePosition(MentalDisplacementEntity entity, MentalDisplacementUpdatePacket packet) {
        entity.updatePacket(packet);
    }

    public CustomPacketPayload.Type<MentalDisplacementUpdatePacket> type() {
        return MahouPackets.MENTAL_DISPLACEMENT_UPDATE_TYPE;
    }
}

