/*
 * Decompiled with CFR 0.152.
 */
package stepsword.mahoutsukai.item.rulebreaker;

import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.SwordItem;
import net.minecraft.world.item.Tier;
import net.minecraft.world.item.Tiers;
import net.minecraft.world.level.Level;
import net.neoforged.neoforge.event.entity.living.LivingIncomingDamageEvent;
import stepsword.mahoutsukai.config.MTConfig;
import stepsword.mahoutsukai.datacomponents.DataComponents;
import stepsword.mahoutsukai.datacomponents.rulebreaker.RuleBreakerMahou;
import stepsword.mahoutsukai.potion.ModEffects;
import stepsword.mahoutsukai.potion.ProbabilityAlterPotion;
import stepsword.mahoutsukai.util.EffectUtil;
import stepsword.mahoutsukai.util.Utils;

public class RuleBreaker
extends SwordItem {
    public static String MODULUS_TAG = "MAHOUTSUKAI_RB_MODULUS";
    public static String DESIGNATION_TAG = "MAHOUTSUKAI_RB_DESIGNATION";

    public RuleBreaker() {
        super((Tier)Tiers.IRON, new Item.Properties().component(DataComponents.RULE_BREAKER_COMPONENT, (Object)new RuleBreakerMahou()).stacksTo(1).durability(MTConfig.RULE_BREAKER_DURABILITY));
    }

    public int getMaxDamage(ItemStack stack) {
        return MTConfig.RULE_BREAKER_DURABILITY;
    }

    public InteractionResultHolder<ItemStack> use(Level world, Player player, InteractionHand hand) {
        ItemStack stack = player.getItemInHand(hand);
        if (!world.isClientSide) {
            if (player.isDiscrete()) {
                RuleBreaker.setDesignation(stack, RuleBreaker.getDesignation(stack) + 1);
            } else if (!EffectUtil.hasBuff((LivingEntity)player, ModEffects.PROBABILITY_ALTER)) {
                player.hurt(player.damageSources().generic(), 2.0f);
                int mod = RuleBreaker.getModulus(stack);
                int des = RuleBreaker.getDesignation(stack);
                ProbabilityAlterPotion.createProbabilityAlter((LivingEntity)player, des, mod);
                EffectUtil.buff((LivingEntity)player, ModEffects.PROBABILITY_ALTER, false, MTConfig.RULE_BREAKER_DURATION);
                stack.hurtAndBreak(1, (LivingEntity)player, EquipmentSlot.MAINHAND);
            }
        }
        return InteractionResultHolder.success((Object)stack);
    }

    public static void ruleBreakerLivingHurt(LivingIncomingDamageEvent event) {
        Entity e = event.getSource().getEntity();
        if (e instanceof LivingEntity && ((LivingEntity)e).getMainHandItem().getItem() instanceof RuleBreaker) {
            LivingEntity target = event.getEntity();
            ItemStack stack = ((LivingEntity)e).getMainHandItem();
            if (!target.level().isClientSide && !EffectUtil.hasBuff(target, ModEffects.PROBABILITY_ALTER)) {
                int mod = RuleBreaker.getModulus(stack);
                int des = RuleBreaker.getDesignation(stack);
                ProbabilityAlterPotion.createProbabilityAlter(target, des, mod);
                EffectUtil.buff(target, ModEffects.PROBABILITY_ALTER, false, MTConfig.RULE_BREAKER_DURATION);
            }
        }
    }

    public static void setModulus(ItemStack stack, int m) {
        RuleBreakerMahou mahou = Utils.getRuleBreakerMahou(stack);
        mahou.setModulus(Math.max(2, m));
        Utils.setRuleBreakerMahou(stack, mahou);
    }

    public static void setDesignation(ItemStack stack, int d) {
        RuleBreakerMahou mahou = Utils.getRuleBreakerMahou(stack);
        mahou.setDesignation(Math.floorMod(d, RuleBreaker.getModulus(stack)));
        Utils.setRuleBreakerMahou(stack, mahou);
    }

    public static int getModulus(ItemStack stack) {
        return Utils.getRuleBreakerMahou(stack).getModulus();
    }

    public static int getDesignation(ItemStack stack) {
        return Utils.getRuleBreakerMahou(stack).getDesignation();
    }
}

