/*
 * Decompiled with CFR 0.152.
 */
package stepsword.mahoutsukai.integration.emi;

import dev.emi.emi.api.recipe.BasicEmiRecipe;
import dev.emi.emi.api.recipe.EmiRecipe;
import dev.emi.emi.api.render.EmiTexture;
import dev.emi.emi.api.stack.EmiIngredient;
import dev.emi.emi.api.stack.EmiStack;
import dev.emi.emi.api.widget.WidgetHolder;
import java.util.ArrayList;
import net.minecraft.client.Minecraft;
import net.minecraft.core.Holder;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.ItemTags;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import org.jetbrains.annotations.Nullable;
import stepsword.mahoutsukai.block.spells.MahoujinRecipeRegistrar;
import stepsword.mahoutsukai.effects.projection.PowerConsolidationSpellEffect;
import stepsword.mahoutsukai.integration.emi.MahouEmiPlugin;
import stepsword.mahoutsukai.integration.emi.MahoujinEmiStack;
import stepsword.mahoutsukai.item.ModItems;
import stepsword.mahoutsukai.util.UnorderedList;
import stepsword.mahoutsukai.util.Utils;

public class CaliburnEmiRecipe
extends BasicEmiRecipe {
    public CaliburnEmiRecipe(ResourceLocation id) {
        super(MahouEmiPlugin.SCROLL_RECIPES, id, 78, 70);
        UnorderedList recipe = MahoujinRecipeRegistrar.makeRecipe(MahoujinRecipeRegistrar.POWDERED_DIAMOND, MahoujinRecipeRegistrar.POWDERED_DIAMOND, MahoujinRecipeRegistrar.POWDERED_EMERALD);
        Block powerConsolidation = MahoujinRecipeRegistrar.recipes.get(recipe);
        String block_id = Utils.getRegistryKey(powerConsolidation, (Level)Minecraft.getInstance().level).getPath();
        MahoujinEmiStack block = new MahoujinEmiStack(ResourceLocation.fromNamespaceAndPath((String)"mahoutsukai", (String)("mahoujin_" + block_id + "_emi")), powerConsolidation, recipe);
        ArrayList<EmiStack> swords = new ArrayList<EmiStack>();
        for (Holder<Item> holder : Utils.getItemsFromTag((TagKey<Item>)ItemTags.SWORD_ENCHANTABLE)) {
            if (!PowerConsolidationSpellEffect.isItemAllowed(new ItemStack(holder), (Level)Minecraft.getInstance().level)) continue;
            swords.add(EmiStack.of((ItemLike)((ItemLike)holder.value())));
        }
        this.inputs.add(EmiIngredient.of(swords));
        this.inputs.add(block);
        this.inputs.add(EmiStack.of((ItemLike)Items.ENCHANTED_BOOK));
        this.outputs.add(EmiStack.of((ItemLike)((ItemLike)ModItems.caliburn.get())));
    }

    public void addWidgets(WidgetHolder widgets) {
        int px = 26;
        int offset = 0;
        int right = 0;
        widgets.addSlot((EmiIngredient)this.inputs.get(0), offset + right * px, 0);
        widgets.addSlot((EmiIngredient)this.inputs.get(1), offset + right * px, 26);
        widgets.addSlot((EmiIngredient)this.inputs.get(2), offset + right * px, 52);
        widgets.addTexture(EmiTexture.EMPTY_ARROW, offset + ++right * px, 26);
        widgets.addSlot((EmiIngredient)this.outputs.get(0), (offset += 6) + ++right * px, 26).recipeContext((EmiRecipe)this);
    }

    public boolean supportsRecipeTree() {
        return super.supportsRecipeTree();
    }

    public boolean hideCraftable() {
        return super.hideCraftable();
    }

    @Nullable
    public RecipeHolder<?> getBackingRecipe() {
        return super.getBackingRecipe();
    }
}

