/*
 * Decompiled with CFR 0.152.
 */
package stepsword.mahoutsukai.effects.displacement;

import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.neoforged.neoforge.event.entity.player.PlayerInteractEvent;
import stepsword.mahoutsukai.dataattachments.mahou.IMahou;
import stepsword.mahoutsukai.tile.displacement.EquivalentDisplacementMahoujinTileEntity;
import stepsword.mahoutsukai.util.BlockDim;
import stepsword.mahoutsukai.util.EffectUtil;
import stepsword.mahoutsukai.util.Utils;

public class EquivalentDisplacementSpellEffect {
    public static void equivalentDisplacementShiftRightClick(PlayerInteractEvent.RightClickBlock event) {
        if (!event.getLevel().isClientSide && event.getHand() == InteractionHand.MAIN_HAND) {
            BlockEntity te = event.getLevel().getBlockEntity(event.getPos());
            Player player = event.getEntity();
            IMahou mahou = Utils.getPlayerMahou(player);
            if (mahou != null && player.isDiscrete()) {
                if (te instanceof EquivalentDisplacementMahoujinTileEntity) {
                    EquivalentDisplacementMahoujinTileEntity mte = (EquivalentDisplacementMahoujinTileEntity)te;
                    if (player.getUUID().equals(mte.getCasterUUID())) {
                        BlockDim bd = mahou.getMemorizedEDMTE();
                        if (bd == null || bd.pos == null) {
                            bd = new BlockDim(event.getPos(), EffectUtil.getDimension(player.level()));
                            mahou.setMemorizedEDMTE(bd);
                            player.displayClientMessage((Component)Component.literal((String)(String.valueOf(ChatFormatting.GREEN) + "Saving circle for binding.")), true);
                        } else if (!bd.pos.equals((Object)mte.getBlockPos()) || !EffectUtil.compareDimensions(bd.dim, EffectUtil.getDimension(player.level()))) {
                            BlockEntity tte = EffectUtil.getNewDimensionByName((ServerLevel)player.level(), bd.dim).getBlockEntity(bd.pos);
                            if (tte instanceof EquivalentDisplacementMahoujinTileEntity) {
                                EquivalentDisplacementMahoujinTileEntity targette = (EquivalentDisplacementMahoujinTileEntity)tte;
                                if (player.getUUID().equals(targette.getCasterUUID())) {
                                    targette.setTargetLocation(event.getPos());
                                }
                                targette.setTargetDimension(player.level().dimension().location());
                                mte.setTargetDimension(bd.dim);
                                mte.setTargetLocation(bd.pos);
                                mahou.setMemorizedEDMTE(null);
                                player.displayClientMessage((Component)Component.literal((String)(String.valueOf(ChatFormatting.RED) + "Binding circle to " + bd.pos.toString() + " in dimension " + String.valueOf(bd.dim) + ".")), true);
                            } else {
                                mahou.setMemorizedEDMTE(null);
                                event.getEntity().displayClientMessage((Component)Component.literal((String)(String.valueOf(ChatFormatting.RED) + "(MahouTsukai) Cleared saved circle for binding.")), true);
                            }
                        }
                    }
                } else if (mahou.getMemorizedEDMTE() != null) {
                    mahou.setMemorizedEDMTE(null);
                    player.displayClientMessage((Component)Component.literal((String)(String.valueOf(ChatFormatting.RED) + "(MahouTsukai) Cleared saved circle for binding.")), true);
                }
            }
        }
    }
}

